/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.common.actions;

import com.ibm.etools.webedit.common.actions.UpdateAction;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.RangeCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webedit.common.utils.Debug;
import com.ibm.etools.webedit.extension.override.CommandExtensionContext;
import com.ibm.etools.webedit.extension.override.DefaultCommandExtensionContext;
import com.ibm.etools.webedit.internal.extension.OverrideActionRegistry;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;

public abstract class CommandAction
extends Action
implements UpdateAction {
    private HTMLEditDomain target;
    private boolean delay = false;
    private String extensionId;
    private CommandExtensionContext commandExtensionContext;

    public CommandAction(String id, String text) {
        this(id, text, null, null, null);
    }

    public CommandAction(String id, String text, ImageDescriptor image, ImageDescriptor hoverImage, ImageDescriptor disabledImage) {
        this(id, text, null, image, hoverImage, disabledImage);
    }

    public CommandAction(String id, String text, String tooltip, ImageDescriptor image, ImageDescriptor hoverImage, ImageDescriptor disabledImage) {
        super(text);
        Debug.assertion(id != null);
        if (id != null) {
            this.setId(id);
        }
        if (tooltip != null) {
            this.setToolTipText(tooltip);
        }
        if (image != null) {
            this.setImageDescriptor(image);
        }
        if (hoverImage != null) {
            this.setHoverImageDescriptor(hoverImage);
        }
        if (disabledImage != null) {
            this.setDisabledImageDescriptor(disabledImage);
        }
    }

    protected boolean getChecked() {
        return false;
    }

    protected abstract Command getCommandForExec();

    protected abstract Command getCommandForUpdate();

    protected final HTMLEditDomain getTarget() {
        if (this.target != null) {
            return this.target;
        }
        try {
            return ActionUtil.getActiveHTMLEditDomain();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    protected void postRun() {
    }

    protected void preRun() {
    }

    public final void run() {
        HTMLEditDomain target;
        if (this.delay) {
            this.update();
            if (!this.isEnabled()) {
                return;
            }
            if (this.getStyle() == 2 || this.getStyle() == 8) {
                this.setChecked(!this.isChecked());
            }
        }
        if ((target = this.getTarget()) != null) {
            this.extensionId = this.getId();
            this.commandExtensionContext = null;
            this.preRun();
            Command command = this.getCommandForExec();
            if (this.extensionId != null && command instanceof HTMLCommand) {
                CommandExtensionContext context = this.commandExtensionContext != null ? this.commandExtensionContext : new DefaultCommandExtensionContext(this.getTarget(), (HTMLCommand)command, this.extensionId);
                command = OverrideActionRegistry.generateExtendedCommand((HTMLCommand)command, context, this.extensionId);
            }
            if (target != null && command != null && command instanceof HTMLCommand) {
                ((HTMLCommand)command).setCommandTarget(target);
                if (!target.canDoRemoveOperation(command)) {
                    command = null;
                }
            }
            Cursor waitCursor = null;
            try {
                waitCursor = new Cursor((Device)target.getDialogParent().getDisplay(), 1);
                this.setDisplayCursor(target.getDialogParent(), waitCursor);
                if (command != null) {
                    if (command instanceof RangeCommand) {
                        ((RangeCommand)command).setSelectionMediator(target.getSelectionMediator());
                    }
                    target.execCommand(command);
                }
                this.postRun();
            }
            finally {
                this.setDisplayCursor(target.getDialogParent(), null);
                if (waitCursor != null && !waitCursor.isDisposed()) {
                    waitCursor.dispose();
                    Object var3_3 = null;
                }
            }
        }
    }

    protected void allowExtend(String extensionId) {
        this.extensionId = extensionId;
    }

    protected void setCommandExtensionContext(CommandExtensionContext context) {
        this.commandExtensionContext = context;
    }

    public CommandExtensionContext getCommandExtensionContext() {
        return this.commandExtensionContext;
    }

    private void setDisplayCursor(Shell shell, Cursor c) {
        Shell[] shells = shell.getDisplay().getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setCursor(c);
            ++i;
        }
    }

    public final void setTarget(HTMLEditDomain target) {
        this.target = target;
    }

    @Override
    public final void update() {
        boolean newChecked;
        boolean oldChecked;
        boolean oldEnabled;
        Command command;
        this.delay = false;
        boolean status = false;
        HTMLEditDomain target = this.getTarget();
        if (target != null && target.getActivePageType() != 2 && (command = this.getCommandForUpdate()) != null) {
            if (command instanceof RangeCommand) {
                ((RangeCommand)command).setSelectionMediator(target.getSelectionMediator());
            }
            if (command instanceof HTMLCommand) {
                ((HTMLCommand)command).setCommandTarget(target);
            }
            status = command.canExecute();
        }
        if ((oldEnabled = this.isEnabled()) != status) {
            this.setEnabled(status);
        }
        if ((oldChecked = this.isChecked()) != (newChecked = this.getChecked())) {
            this.setChecked(newChecked);
        }
    }

    public final void delayedUpdate() {
        this.delay = true;
    }

    public boolean isChecked() {
        if (this.delay) {
            this.update();
        }
        return super.isChecked();
    }

    public boolean isEnabled() {
        if (this.delay) {
            this.update();
        }
        return super.isEnabled();
    }
}

