/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.util;

import com.ibm.etools.tiles.Logger;
import com.ibm.etools.tiles.internal.util.TilesActionTaglibURIRegistryReader;
import com.ibm.etools.tiles.util.ITilesConstants;
import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.editdomain.HTMLSubModelContext;
import com.ibm.etools.webedit.util.HTMLTaglibDirectiveUtil;
import com.ibm.etools.webedit.util.ITaglibDirective;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.html.core.internal.modelquery.DocumentQuery;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMNodeWrapper;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class TilesUtil
implements ITilesConstants {
    public static final String TILES_TYPE_NONE = "NoRelationToTemplate";
    public static final String TILES_TYPE_INSTANCE = "TilesInstance";
    public static final String TILES_TYPE_TEMPLATE = "TilesTemplate";
    public static final String TILES_NODE_TYPE_TEMPLATE = "TilesInsert";
    public static final String TILES_NODE_TYPE_PUT = "TilesPut";
    public static final String TILES_NODE_TYPE_PUTLIST = "TilesPutList";
    public static final String TILES_NODE_TYPE_ADD = "TilesAdd";
    public static final String TILES_NODE_TYPE_GET = "TilesGet";
    public static final String TILES_NODE_TYPE_NONE = "TilesNodeNone";
    public static String TILES_DEFINITIONS_CONTENT_TYPE = "com.ibm.etools.tiles.TilesDefinitions";

    public static String[] collectGetAreaNames(IDOMModel model) {
        return TilesUtil.collectGetAreaNames(model, true, true, true);
    }

    public static String getTilesTaglibURI(HTMLEditDomain domain, IDOMModel model) {
        if (domain == null) {
            return TilesUtil.getTilesTaglibURI(HTMLTaglibDirectiveUtil.getTaglibDirectivesEx((IDOMModel)model));
        }
        HTMLSubModelContext[] contexts = domain.getSubModelContextsFor(model);
        if (contexts != null && contexts.length > 0) {
            Object[] taglibs = contexts[0].getTaglibNodes(model.getDocument().getLastChild());
            return TilesUtil.getTilesTaglibURI(taglibs);
        }
        return TilesUtil.getTilesTaglibURI(HTMLTaglibDirectiveUtil.getTaglibDirectivesEx((IDOMModel)model));
    }

    public static String getTilesTaglibPrefix(HTMLEditDomain domain, IDOMModel model) {
        if (domain == null) {
            return TilesUtil.getTilesTaglibPrefix(HTMLTaglibDirectiveUtil.getTaglibDirectivesEx((IDOMModel)model));
        }
        HTMLSubModelContext[] contexts = domain.getSubModelContextsFor(model);
        if (contexts != null && contexts.length > 0) {
            Object[] taglibs = contexts[0].getTaglibNodes(model.getDocument().getLastChild());
            return TilesUtil.getTilesTaglibPrefix(taglibs);
        }
        return TilesUtil.getTilesTaglibPrefix(HTMLTaglibDirectiveUtil.getTaglibDirectivesEx((IDOMModel)model));
    }

    public static String[] getTilesTaglibURIAndPrefixToInsert(HTMLEditDomain domain, IProject project, IDOMModel model) {
        String uri = TilesUtil.getTilesTaglibURI(domain, model);
        if (uri != null) {
            return new String[]{uri, TilesUtil.getTilesTaglibPrefix(domain, model)};
        }
        String[] taglibInfo = TilesUtil.getAvailableTaglibURI(project);
        if (taglibInfo != null) {
            return taglibInfo;
        }
        WebArtifactEdit webEdit = WebArtifactEdit.getWebArtifactEditForRead((IProject)project);
        try {
            if (webEdit != null && webEdit.getJSPVersion() == 11) {
                String[] stringArray = new String[]{"/WEB-INF/struts-tiles.tld", "tiles"};
                return stringArray;
            }
            String[] stringArray = new String[]{"http://jakarta.apache.org/struts/tags-tiles", "tiles"};
            return stringArray;
        }
        finally {
            if (webEdit != null) {
                webEdit.dispose();
            }
        }
    }

    private static String[] getPreferredTaglibURI(IProject project) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {}
        if (facetedProject != null) {
            TilesActionTaglibURIRegistryReader.Element[] elements = TilesActionTaglibURIRegistryReader.getElements();
            int i = 0;
            while (i < elements.length) {
                TilesActionTaglibURIRegistryReader.Element element = elements[i];
                for (IProjectFacetVersion facetVersion : element.facetVersions) {
                    if (!facetedProject.hasProjectFacet(facetVersion)) continue;
                    return new String[]{element.uri, element.prefix};
                }
                ++i;
            }
        }
        return null;
    }

    public static String[] getAvailableTaglibURI(IProject project) {
        String[] taglibInfo = TilesUtil.getPreferredTaglibURI(project);
        if (taglibInfo != null) {
            return taglibInfo;
        }
        IProject taglibKey = project;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            taglibKey = component.getRootFolder().getUnderlyingResource();
        }
        ITaglibRecord[] tagRecs = TaglibIndex.getAvailableTaglibRecords((IPath)taglibKey.getFullPath());
        String[] uriCandidates = new String[]{"/WEB-INF/struts-tiles.tld", "http://jakarta.apache.org/struts/tags-tiles", "http://struts.apache.org/tags-tiles", "http://jakarta.apache.org/struts/tags-tiles-1.1"};
        if (tagRecs != null) {
            int j = 0;
            while (j < uriCandidates.length) {
                int i = 0;
                while (i < tagRecs.length) {
                    String uri = null;
                    if (tagRecs[i].getRecordType() == 1) {
                        uri = ((ITLDRecord)tagRecs[i]).getURI();
                    } else if (tagRecs[i].getRecordType() == 4) {
                        uri = ((IURLRecord)tagRecs[i]).getURI();
                    }
                    if (uriCandidates[j].equals(uri)) {
                        String prefix = null;
                        if (tagRecs[i].getRecordType() == 1) {
                            prefix = ((ITLDRecord)tagRecs[i]).getShortName();
                        } else if (tagRecs[i].getRecordType() == 4) {
                            prefix = ((IURLRecord)tagRecs[i]).getShortName();
                        }
                        prefix = prefix.trim();
                        int len = prefix.indexOf(32);
                        if (len > 0) {
                            prefix = prefix.substring(0, len);
                        }
                        if (prefix.length() <= 0) {
                            prefix = "tiles";
                        }
                        return new String[]{uri, prefix};
                    }
                    ++i;
                }
                ++j;
            }
        }
        return null;
    }

    private static String getTilesTaglibURI(Object[] taglibs) {
        ITaglibDirective td = TilesUtil.getTilesTaglibEntry(taglibs);
        if (td == null) {
            return null;
        }
        return td.getURI();
    }

    private static String getTilesTaglibPrefix(Object[] taglibs) {
        ITaglibDirective td = TilesUtil.getTilesTaglibEntry(taglibs);
        if (td == null) {
            return null;
        }
        return td.getPrefix();
    }

    private static boolean isValidTilesURI(String uri) {
        return uri != null && (uri.endsWith("struts-tiles.tld") || uri.equals("http://jakarta.apache.org/struts/tags-tiles") || uri.equals("http://jakarta.apache.org/struts/tags-tiles-1.1") || uri.equals("http://struts.apache.org/tags-tiles"));
    }

    private static ITaglibDirective getTilesTaglibEntry(Object[] taglibs) {
        if (taglibs == null) {
            return null;
        }
        int i = 0;
        while (i < taglibs.length) {
            if (taglibs[i] instanceof ITaglibDirective) {
                ITaglibDirective dirc = (ITaglibDirective)taglibs[i];
                if (TilesUtil.isValidTilesURI(dirc.getURI())) {
                    return dirc;
                }
            } else {
                Element elem = (Element)taglibs[i];
                String elementName = elem.getTagName();
                if (elementName != null) {
                    if (elementName.equals("jsp:directive.taglib")) {
                        ITaglibDirective td = (ITaglibDirective)HTMLTaglibDirectiveUtil.getTaglibDirective((Node)elem);
                        if (TilesUtil.isValidTilesURI(td.getURI())) {
                            return td;
                        }
                    } else {
                        NamedNodeMap map = elem.getAttributes();
                        if (map != null) {
                            int nEntry = map.getLength();
                            int j = 0;
                            while (j < nEntry) {
                                ITaglibDirective td;
                                String pre;
                                Node attr = map.item(j);
                                if (attr != null && attr.getNodeType() == 2 && (pre = HTMLTaglibDirectiveUtil.getTaglibPrefix((String)attr.getNodeName())) != null && TilesUtil.isValidTilesURI((td = (ITaglibDirective)HTMLTaglibDirectiveUtil.getTaglibDirective((Node)attr)).getURI())) {
                                    return td;
                                }
                                ++j;
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private static Map getAreaName(Node node, String insertName, String getName, String getAsStringName, boolean withInsert, boolean withGet, boolean withGetAsString) {
        HashMap<String, ContentArea> ret;
        block12: {
            block11: {
                ret = new HashMap<String, ContentArea>();
                if (node == null) {
                    return ret;
                }
                if (node.getNodeType() != 1) break block11;
                String areaName = null;
                Element ele = (Element)node;
                if (withInsert && ele.getNodeName().equals(insertName)) {
                    areaName = ele.getAttribute("attribute");
                } else if (withGet && ele.getNodeName().equals(getName)) {
                    areaName = ele.getAttribute("name");
                } else if (withGetAsString && ele.getNodeName().equals(getAsStringName)) {
                    areaName = ele.getAttribute("name");
                }
                if (areaName == null) break block12;
                ret.put(areaName, new ContentArea(node));
                break block12;
            }
            if (node.getNodeType() == 2) {
                String value = node.getNodeValue();
                Map subMap = TilesUtil.getAreaName(value, insertName, getName, getAsStringName, withInsert, withGet, withGetAsString);
                for (Object area : subMap.keySet()) {
                    int[] pos = (int[])subMap.get(area);
                    ret.put((String)area, new ContentArea(node, pos[0], pos[1]));
                }
            } else if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                int[] reg = TilesUtil.getTrimCommentRegion(value);
                Map subMap = TilesUtil.getAreaName(value.substring(reg[0], reg[1]), insertName, getName, getAsStringName, withInsert, withGet, withGetAsString);
                for (Object area : subMap.keySet()) {
                    int[] pos = (int[])subMap.get(area);
                    ret.put((String)area, new ContentArea(node, pos[0] + reg[0], pos[1] + reg[0]));
                }
            }
        }
        return ret;
    }

    private static Map getAreaName(String nodeText, String insertName, String getName, String getAsStringName, boolean withInsert, boolean withGet, boolean withGetAsString) {
        HashMap<String, int[]> ret = new HashMap<String, int[]>();
        try {
            IStructuredDocument doc = StructuredModelManager.getModelManager().createStructuredDocumentFor("a.jsp", nodeText, null);
            IStructuredDocumentRegion structuredNode = doc.getFirstStructuredDocumentRegion();
            boolean insertTag = false;
            boolean getTag = false;
            boolean getAsStringTag = false;
            IStructuredDocumentRegion startNode = null;
            String areaName = null;
            while (structuredNode != null) {
                String regionType = structuredNode.getType();
                if ("XML_TAG_NAME".equals(regionType)) {
                    if ("XML_TAG_OPEN".equals(structuredNode.getFirstRegion().getType())) {
                        startNode = structuredNode;
                        Iterator it = structuredNode.getRegions().iterator();
                        boolean attrStarted = false;
                        while (it.hasNext()) {
                            ITextRegion region = (ITextRegion)it.next();
                            if ("XML_TAG_NAME".equals(region.getType())) {
                                String tagName = structuredNode.getText(region);
                                if (tagName.equals(insertName) && withInsert) {
                                    insertTag = true;
                                    continue;
                                }
                                if (tagName.equals(getName) && withGet) {
                                    getTag = true;
                                    continue;
                                }
                                if (tagName.equals(getAsStringName) && withGetAsString) {
                                    getAsStringTag = true;
                                    continue;
                                }
                                break;
                            }
                            if ("XML_TAG_ATTRIBUTE_NAME".equals(region.getType())) {
                                attrStarted = false;
                                String attrName = structuredNode.getText(region);
                                if (insertTag) {
                                    if (!attrName.equals("attribute")) continue;
                                    attrStarted = true;
                                    continue;
                                }
                                if (!getTag && !getAsStringTag || !attrName.equals("name")) continue;
                                attrStarted = true;
                                continue;
                            }
                            if ("XML_TAG_ATTRIBUTE_VALUE".equals(region.getType())) {
                                if (!attrStarted) continue;
                                areaName = TilesUtil.trimQuotes(structuredNode.getText(region));
                                continue;
                            }
                            if (!"XML_EMPTY_TAG_CLOSE".equals(region.getType())) continue;
                            getAsStringTag = false;
                            getTag = false;
                            insertTag = false;
                            startNode = null;
                            if (areaName == null) continue;
                            ret.put(areaName, new int[]{structuredNode.getStart(), structuredNode.getEnd()});
                            areaName = null;
                        }
                    } else if ("XML_END_TAG_OPEN".equals(structuredNode.getFirstRegion().getType())) {
                        for (ITextRegion region : structuredNode.getRegions()) {
                            if (!"XML_TAG_NAME".equals(region.getType())) continue;
                            boolean isEndTag = false;
                            if (insertTag) {
                                if (structuredNode.getText(region).equals(insertName)) {
                                    isEndTag = true;
                                }
                            } else if (getTag) {
                                if (structuredNode.getText(region).equals(getName)) {
                                    isEndTag = true;
                                }
                            } else if (getAsStringTag && structuredNode.getText(region).equals(getAsStringName)) {
                                isEndTag = true;
                            }
                            if (!isEndTag) break;
                            getAsStringTag = false;
                            getTag = false;
                            insertTag = false;
                            ret.put(areaName, new int[]{startNode.getStart(), structuredNode.getEnd()});
                            startNode = null;
                            areaName = null;
                            break;
                        }
                    }
                }
                structuredNode = structuredNode.getNext();
            }
        }
        catch (IOException ioe) {
            Logger.logException(ioe);
        }
        return ret;
    }

    protected static String trimQuotes(String val) {
        int length = val.length();
        if (val != null && length > 1) {
            if (val.charAt(0) == '\"' && val.charAt(length - 1) == '\"') {
                return val.substring(1, length - 1);
            }
            if (val.charAt(0) == '\'' && val.charAt(length - 1) == '\'') {
                return val.substring(1, length - 1);
            }
        }
        return val;
    }

    protected static int[] getTrimCommentRegion(String val) {
        int commentStartPos = val.indexOf("<!--");
        if (commentStartPos < 0) {
            int[] nArray = new int[2];
            nArray[1] = val.length();
            return nArray;
        }
        int commentEndPos = val.substring(commentStartPos += "<!--".length()).indexOf("-->") + commentStartPos;
        return new int[]{commentStartPos, commentEndPos < 0 ? val.length() : commentEndPos};
    }

    private static Map joinMap(Map src1, Map src2) {
        for (Object key : src2.keySet()) {
            src1.put(key, src2.get(key));
        }
        return src1;
    }

    public static Map collectGetAreaMap(IDOMModel model, boolean withInsert, boolean withGet, boolean withGetAsString) {
        return TilesUtil.collectGetAreaMap(model, null, withInsert, withGet, withGetAsString);
    }

    public static Map collectGetAreaMap(IDOMModel model, Node rootNode, boolean withInsert, boolean withGet, boolean withGetAsString) {
        Map areas = new HashMap();
        String prefix = TilesUtil.getTilesTaglibPrefix(null, model);
        DocumentQuery editQuery = EditQueryUtil.getDocumentQuery((Node)model.getDocument());
        if (rootNode == null) {
            rootNode = model.getDocument();
        }
        NodeIterator it = ((DocumentTraversal)model.getDocument()).createNodeIterator(rootNode, 1, null, false);
        Node ele = it.nextNode();
        String insertName = String.valueOf(prefix) + ":" + "insert";
        String getName = String.valueOf(prefix) + ":" + "get";
        String getAsStringName = String.valueOf(prefix) + ":" + "getAsString";
        boolean searchHead = true;
        while (ele != null) {
            Map subMap = TilesUtil.getAreaName(ele, insertName, getName, getAsStringName, withInsert, withGet, withGetAsString);
            if (subMap != null && subMap.size() > 0) {
                areas = TilesUtil.joinMap(areas, subMap);
            } else if (searchHead) {
                if (editQuery.isRenderRoot(ele)) {
                    searchHead = false;
                    continue;
                }
                NamedNodeMap map = ele.getAttributes();
                int len = map.getLength();
                int i = 0;
                while (i < len) {
                    IDOMAttr attr = (IDOMAttr)map.item(i);
                    if (attr.hasNestedValue() && (subMap = TilesUtil.getAreaName((Node)attr, insertName, getName, getAsStringName, withInsert, withGet, withGetAsString)) != null && subMap.size() > 0) {
                        areas = TilesUtil.joinMap(areas, subMap);
                    }
                    ++i;
                }
                if ((ele.getNodeName().equalsIgnoreCase("STYLE") || ele.getNodeName().equalsIgnoreCase("SCRIPT")) && ele.getFirstChild() != null && ele.getFirstChild().getNodeType() == 3 && (subMap = TilesUtil.getAreaName(ele.getFirstChild(), insertName, getName, getAsStringName, withInsert, withGet, withGetAsString)) != null && subMap.size() > 0) {
                    areas = TilesUtil.joinMap(areas, subMap);
                }
            }
            ele = it.nextNode();
        }
        return areas;
    }

    private static Set joinSet(Set src1, Set src2) {
        Iterator it = src2.iterator();
        while (it.hasNext()) {
            src1.add(it.next());
        }
        return src1;
    }

    public static String[] collectGetAreaNames(IDOMModel model, boolean withInsert, boolean withGet, boolean withGetAsString) {
        if (model == null) {
            return new String[0];
        }
        Set areaNames = new HashSet();
        String prefix = TilesUtil.getTilesTaglibPrefix(null, model);
        DocumentQuery editQuery = EditQueryUtil.getDocumentQuery((Node)model.getDocument());
        NodeIterator it = ((DocumentTraversal)model.getDocument()).createNodeIterator((Node)model.getDocument(), 1, null, false);
        Node ele = it.nextNode();
        String insertName = String.valueOf(prefix) + ":" + "insert";
        String getName = String.valueOf(prefix) + ":" + "get";
        String getAsStringName = String.valueOf(prefix) + ":" + "getAsString";
        boolean searchHead = true;
        while (ele != null) {
            Map subMap = TilesUtil.getAreaName(ele, insertName, getName, getAsStringName, withInsert, withGet, withGetAsString);
            if (subMap != null && subMap.size() > 0) {
                areaNames = TilesUtil.joinSet(areaNames, subMap.keySet());
            } else if (searchHead) {
                if (editQuery.isRenderRoot(ele)) {
                    searchHead = false;
                    continue;
                }
                NamedNodeMap map = ele.getAttributes();
                int len = map.getLength();
                int i = 0;
                while (i < len) {
                    IDOMAttr attr = (IDOMAttr)map.item(i);
                    if (attr.hasNestedValue() && (subMap = TilesUtil.getAreaName((Node)attr, insertName, getName, getAsStringName, withInsert, withGet, withGetAsString)) != null && subMap.size() > 0) {
                        areaNames = TilesUtil.joinSet(areaNames, subMap.keySet());
                    }
                    ++i;
                }
                if ((ele.getNodeName().equalsIgnoreCase("STYLE") || ele.getNodeName().equalsIgnoreCase("SCRIPT")) && ele.getFirstChild() != null && ele.getFirstChild().getNodeType() == 3 && (subMap = TilesUtil.getAreaName(ele.getFirstChild(), insertName, getName, getAsStringName, withInsert, withGet, withGetAsString)) != null && subMap.size() > 0) {
                    areaNames = TilesUtil.joinSet(areaNames, subMap.keySet());
                }
            }
            ele = it.nextNode();
        }
        String[] getAreas = new String[areaNames.size()];
        areaNames.toArray(getAreas);
        return getAreas;
    }

    public static String getTilesNodeType(Element node) {
        String name;
        if (node == null) {
            return TILES_NODE_TYPE_NONE;
        }
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument());
        CMElementDeclaration elementDecl = modelQuery.getCMElementDeclaration(node);
        if (elementDecl != null && elementDecl instanceof CMNodeWrapper) {
            TLDDocument tldDoc;
            TLDElementDeclaration d;
            CMNode n = ((CMNodeWrapper)elementDecl).getOriginNode();
            try {
                d = (TLDElementDeclaration)n;
            }
            catch (ClassCastException classCastException) {
                d = null;
            }
            if (d == null) {
                return TILES_NODE_TYPE_NONE;
            }
            try {
                tldDoc = (TLDDocument)d.getOwnerDocument();
            }
            catch (ClassCastException classCastException) {
                tldDoc = null;
            }
            if (tldDoc == null) {
                return TILES_NODE_TYPE_NONE;
            }
            if (tldDoc.getUri() == null) {
                return TILES_NODE_TYPE_NONE;
            }
            if (!(tldDoc.getUri().equals("http://jakarta.apache.org/struts/tags-tiles") || tldDoc.getUri().equals("http://jakarta.apache.org/struts/tags-tiles-1.1") || tldDoc.getUri().equals("http://struts.apache.org/tags-tiles"))) {
                return TILES_NODE_TYPE_NONE;
            }
        }
        if ("put".equals(name = node.getLocalName())) {
            return TILES_NODE_TYPE_PUT;
        }
        if ("putList".equals(name)) {
            return TILES_NODE_TYPE_PUTLIST;
        }
        if ("add".equals(name)) {
            return TILES_NODE_TYPE_ADD;
        }
        if ("get".equals(name)) {
            return TILES_NODE_TYPE_GET;
        }
        if ("getAsString".equals(name)) {
            return TILES_NODE_TYPE_GET;
        }
        if ("insert".equals(name)) {
            if (node.hasAttribute("attribute")) {
                return TILES_NODE_TYPE_GET;
            }
            return TILES_NODE_TYPE_TEMPLATE;
        }
        return TILES_NODE_TYPE_NONE;
    }

    public static String getTilesPutTagContentType(Element put) {
        String type = TilesUtil.getTilesNodeType(put);
        if (!TILES_NODE_TYPE_PUT.equals(type) && !TILES_NODE_TYPE_ADD.equals(type)) {
            return null;
        }
        String directVal = put.getAttribute("direct");
        if (directVal != null) {
            if ("true".equals(directVal)) {
                return "string";
            }
            return "page";
        }
        String typeVal = put.getAttribute("type");
        if ("string".equals(typeVal)) {
            return "string";
        }
        if ("definition".equals(typeVal)) {
            return "definition";
        }
        if ("page".equals(typeVal) || "template".equals(typeVal)) {
            return "page";
        }
        String value = TilesUtil.getPutValue(put, false);
        if (value != null && value.length() > 0 && put instanceof IDOMElement) {
            IDOMModel model = ((IDOMElement)put).getModel();
            IFile file = WebComponent.getFileForLocation((IPath)new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)model)));
            if (file != null) {
                TilesDefinitionUtil util = new TilesDefinitionUtil(WebComponent.getComponent((IResource)file), file);
                try {
                    if (util.lookupDefinition(value) != null) {
                        return "definition";
                    }
                }
                finally {
                    util.dispose();
                }
            }
        } else {
            String directValue = TilesUtil.getPutValueFromElementChild(put);
            if (directValue != null && directValue.length() > 0) {
                return "string";
            }
        }
        return "page";
    }

    public static String getPutValue(Element put) {
        return TilesUtil.getPutValue(put, true);
    }

    private static String getPutValue(Element put, boolean considerElementBody) {
        String type = TilesUtil.getTilesNodeType(put);
        if (!TILES_NODE_TYPE_PUT.equals(type) && !TILES_NODE_TYPE_ADD.equals(type)) {
            return null;
        }
        String value = put.getAttribute("value");
        if (value == null) {
            value = put.getAttribute("content");
        }
        if (value == null) {
            value = considerElementBody ? TilesUtil.getPutValueFromElementChild(put) : "";
        }
        return value;
    }

    private static String getPutValueFromElementChild(Element put) {
        StringBuffer buf = new StringBuffer();
        Node child = put.getFirstChild();
        while (child != null) {
            buf.append(((IDOMNode)child).getSource());
            child = child.getNextSibling();
        }
        return buf.toString();
    }

    public static String getGetValue(Element get) {
        String type = TilesUtil.getTilesNodeType(get);
        if (!TILES_NODE_TYPE_GET.equals(type)) {
            return null;
        }
        String areaName = null;
        if (get.getLocalName().equals("insert")) {
            areaName = get.getAttribute("attribute");
        } else if (get.getLocalName().equals("get")) {
            areaName = get.getAttribute("name");
        } else if (get.getLocalName().equals("getAsString")) {
            areaName = get.getAttribute("name");
        }
        return areaName;
    }

    public static void setPutValue(Element put, String value) {
        if (put == null || value == null) {
            return;
        }
        String type = TilesUtil.getTilesNodeType(put);
        if (!TILES_NODE_TYPE_PUT.equals(type) && !TILES_NODE_TYPE_ADD.equals(type)) {
            return;
        }
        put.setAttribute("value", value);
        put.setAttribute("content", null);
    }

    public static String getTilesType(IDOMModel model) {
        Node node;
        String prefix = TilesUtil.getTilesTaglibPrefix(null, model);
        if (prefix == null || prefix.length() <= 0) {
            return TILES_TYPE_NONE;
        }
        NodeIterator nit = ((DocumentTraversal)model.getDocument()).createNodeIterator((Node)model.getDocument(), 1, null, false);
        boolean foundTemplateNode = false;
        while ((node = nit.nextNode()) != null) {
            if (!node.getNodeName().startsWith(String.valueOf(prefix) + ":")) continue;
            String nodeName = TilesUtil.getTilesNodeType((Element)node);
            if (nodeName.equals(TILES_NODE_TYPE_GET)) {
                return TILES_TYPE_TEMPLATE;
            }
            if (!nodeName.equals(TILES_NODE_TYPE_TEMPLATE)) continue;
            foundTemplateNode = true;
        }
        if (foundTemplateNode) {
            return TILES_TYPE_INSTANCE;
        }
        return TILES_TYPE_NONE;
    }

    public static boolean hasTilesTaglib(HTMLEditDomain domain, IDOMModel model) {
        String prefix = TilesUtil.getTilesTaglibPrefix(domain, model);
        return prefix != null && prefix.trim().length() > 0;
    }

    public static String[] collectPutAreaNames(IDOMModel model) {
        ArrayList<String> areaNames = new ArrayList<String>();
        String prefix = TilesUtil.getTilesTaglibPrefix(null, model);
        NodeIterator it = ((DocumentTraversal)model.getDocument()).createNodeIterator(TilesUtil.getTemplateNode(model), 1, null, false);
        Element ele = (Element)it.nextNode();
        String putName = String.valueOf(prefix) + ":" + "put";
        while (ele != null) {
            String areaName;
            if (ele.getNodeName().equals(putName) && !areaNames.contains(areaName = ele.getAttribute("name"))) {
                areaNames.add(areaName);
            }
            ele = (Element)it.nextNode();
        }
        String[] putAreas = new String[areaNames.size()];
        areaNames.toArray(putAreas);
        return putAreas;
    }

    public static Map collectPutAreaMap(IDOMModel model) {
        HashMap<String, String> areaMap = new HashMap<String, String>();
        String prefix = TilesUtil.getTilesTaglibPrefix(null, model);
        NodeIterator it = ((DocumentTraversal)model.getDocument()).createNodeIterator(TilesUtil.getTemplateNode(model), 1, null, false);
        Element ele = (Element)it.nextNode();
        String putName = String.valueOf(prefix) + ":" + "put";
        while (ele != null) {
            String areaName;
            if (ele.getNodeName().equals(putName) && (areaName = ele.getAttribute("name")) != null && areaName.length() > 0) {
                areaMap.put(areaName, TilesUtil.getPutValue(ele));
            }
            ele = (Element)it.nextNode();
        }
        return areaMap;
    }

    public static Map collectPutAreaMapWithType(IDOMModel model) {
        return TilesUtil.collectPutAreaMapWithType(model, false);
    }

    public static Map collectPutAreaMapWithType(IDOMModel model, boolean withPutList) {
        HashMap<String, Object[]> areaMap = new HashMap<String, Object[]>();
        String prefix = TilesUtil.getTilesTaglibPrefix(null, model);
        NodeIterator it = ((DocumentTraversal)model.getDocument()).createNodeIterator(TilesUtil.getTemplateNode(model), 1, null, false);
        Element ele = (Element)it.nextNode();
        String putName = String.valueOf(prefix) + ":" + "put";
        String putListName = String.valueOf(prefix) + ":" + "putList";
        while (ele != null) {
            String areaName;
            if (ele.getNodeName().equals(putName)) {
                areaName = ele.getAttribute("name");
                if (areaName != null && areaName.length() > 0) {
                    areaMap.put(areaName, new Object[]{TilesUtil.getPutValue(ele), TilesUtil.getTilesPutTagContentType(ele)});
                }
            } else if (withPutList && ele.getNodeName().equals(putListName) && (areaName = ele.getAttribute("name")) != null && areaName.length() > 0) {
                areaMap.put(areaName, new Object[]{TilesUtil.getAddListWithType(ele, prefix).toArray(), "list"});
            }
            ele = (Element)it.nextNode();
        }
        return areaMap;
    }

    protected static List getAddListWithType(Element ele, String prefix) {
        if (ele == null) {
            return null;
        }
        ArrayList<Object[]> adds = new ArrayList<Object[]>();
        Node child = ele.getFirstChild();
        String addTagName = String.valueOf(prefix) + ":" + "add";
        while (child != null) {
            if (child.getNodeType() == 1 && child.getNodeName().equals(addTagName)) {
                adds.add(new Object[]{TilesUtil.getPutValue((Element)child), TilesUtil.getTilesPutTagContentType((Element)child)});
            }
            child = child.getNextSibling();
        }
        return adds;
    }

    public static Node getPutAreaNode(IDOMModel model, String area) {
        String prefix = TilesUtil.getTilesTaglibPrefix(null, model);
        NodeIterator it = ((DocumentTraversal)model.getDocument()).createNodeIterator(TilesUtil.getTemplateNode(model), 1, null, false);
        Element ele = (Element)it.nextNode();
        String putName = String.valueOf(prefix) + ":" + "put";
        while (ele != null) {
            String areaName;
            if (ele.getNodeName().equals(putName) && (areaName = ele.getAttribute("name")).equals(area)) {
                return ele;
            }
            ele = (Element)it.nextNode();
        }
        return null;
    }

    public static boolean isPutDirect(IDOMModel model, String area) {
        Element putNode = (Element)TilesUtil.getPutAreaNode(model, area);
        if (putNode == null) {
            return false;
        }
        String directValue = putNode.getAttribute("direct");
        if (directValue != null) {
            return "true".equals(directValue);
        }
        String typeValue = putNode.getAttribute("type");
        if (typeValue != null) {
            return "string".equals(typeValue);
        }
        return false;
    }

    public static Node getTemplateNode(IDOMModel model) {
        String prefix = TilesUtil.getTilesTaglibPrefix(null, model);
        NodeIterator it = ((DocumentTraversal)model.getDocument()).createNodeIterator((Node)model.getDocument(), 1, null, false);
        Element ele = (Element)it.nextNode();
        String insertName = String.valueOf(prefix) + ":" + "insert";
        while (ele != null) {
            if (ele.getNodeName().equals(insertName) && TilesUtil.getTilesNodeType(ele).equals(TILES_NODE_TYPE_TEMPLATE)) {
                return ele;
            }
            ele = (Element)it.nextNode();
        }
        return null;
    }

    public static String getTemplatePageValue(IDOMModel model) {
        Element ele = (Element)TilesUtil.getTemplateNode(model);
        if (ele == null) {
            return null;
        }
        String value = ele.getAttribute("page");
        if (value != null) {
            return value;
        }
        value = ele.getAttribute("template");
        if (value != null) {
            return value;
        }
        return ele.getAttribute("component");
    }

    public static String getTemplateDefinitionValue(IDOMModel model) {
        Element ele = (Element)TilesUtil.getTemplateNode(model);
        return ele != null ? ele.getAttribute("definition") : null;
    }

    public static boolean isTilesDefinitionsFile(IFile file) {
        try {
            IContentType contentType;
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription != null && (contentType = contentDescription.getContentType()) != null) {
                return TILES_DEFINITIONS_CONTENT_TYPE.equals(contentType.getId());
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static class ContentArea {
        private final Node node;
        private final int startPosInNode;
        private final int endPosInNode;

        public ContentArea(Node node) {
            this.node = node;
            this.endPosInNode = -1;
            this.startPosInNode = -1;
        }

        public ContentArea(Node node, int startPos, int endPos) {
            this.node = node;
            this.startPosInNode = startPos;
            this.endPosInNode = endPos;
        }

        public Node getNode() {
            return this.node;
        }

        public Node getContainerNode() {
            if (this.node.getNodeType() == 2) {
                return ((Attr)this.node).getOwnerElement();
            }
            if (!this.hasRegion()) {
                return this.node.getParentNode();
            }
            return this.node;
        }

        public boolean hasRegion() {
            return this.startPosInNode >= 0 && this.endPosInNode >= 0;
        }

        public int getStartPos() {
            return this.startPosInNode;
        }

        public int getEndPos() {
            return this.endPosInNode;
        }
    }
}

