/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.util;

import com.ibm.etools.tiles.Logger;
import com.ibm.etools.tiles.TilesPlugin;
import com.ibm.etools.tiles.facet.TilesFacetInstallDataModelProvider;
import com.ibm.etools.tiles.nls.ResourceHandler;
import com.ibm.etools.tiles.util.ITilesConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class TilesFacetUtil
implements ITilesConstants {
    public static final String TILES_FACET_NAME = "web.struts.tiles";

    public static void installTilesFacet(IVirtualComponent component) throws CoreException {
        TilesFacetUtil.installTilesFacet(component, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void installTilesFacet(IVirtualComponent component, IProgressMonitor monitor) throws CoreException {
        TilesFacetInstallDataModelProvider provider = new TilesFacetInstallDataModelProvider();
        IDataModel model = (IDataModel)provider.create();
        TilesFacetUtil.installTilesFacet(component, model, monitor);
    }

    public static void installTilesFacet(IVirtualComponent component, IDataModel dataModel, IProgressMonitor monitor) throws CoreException {
        IProjectFacet facet;
        if (component == null) {
            throw new CoreException((IStatus)new Status(4, TilesPlugin.getPluginId(), 4, ResourceHandler._UI_Tiles_Facet_Util_0, null));
        }
        if (TilesFacetUtil.hasTilesFacet(component)) {
            return;
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)component.getProject());
        if (facetedProject.hasProjectFacet(facet = ProjectFacetsManager.getProjectFacet((String)TILES_FACET_NAME))) {
            return;
        }
        IProjectFacetVersion fv = facet.getLatestVersion();
        facetedProject.installProjectFacet(fv, (Object)dataModel, monitor);
    }

    public static boolean hasTilesFacet(IVirtualComponent component) {
        IFacetedProject facetedProject;
        block5: {
            if (component == null) {
                return false;
            }
            facetedProject = ProjectFacetsManager.create((IProject)component.getProject());
            if (facetedProject != null) break block5;
            return false;
        }
        try {
            IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)TILES_FACET_NAME);
            return facetedProject.hasProjectFacet(facet);
        }
        catch (CoreException ce) {
            Logger.logException(ce);
            return false;
        }
        catch (Exception e) {
            Logger.logException(e);
            return false;
        }
    }

    public static boolean confirmInstallTilesFacet(Shell shell, String operationTitle, IVirtualComponent component) {
        if (TilesFacetUtil.hasTilesFacet(component)) {
            return true;
        }
        return MessageDialog.openConfirm((Shell)shell, (String)operationTitle, (String)ResourceHandler._UI_Tiles_Facet_Util_1);
    }
}

