/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.util;

import com.ibm.etools.tiles.definitions.Add;
import com.ibm.etools.tiles.definitions.ContentType;
import com.ibm.etools.tiles.definitions.Definition;
import com.ibm.etools.tiles.definitions.Put;
import com.ibm.etools.tiles.definitions.PutList;
import com.ibm.etools.tiles.definitions.TilesDefinitions;
import com.ibm.etools.tiles.definitions.TilesFactory;
import com.ibm.etools.tiles.util.ITilesConstants;
import com.ibm.etools.tiles.util.ITilesDefinitionFileProvider;
import com.ibm.etools.tiles.util.TilesArtifactEdit;
import com.ibm.etools.tiles.util.TilesDefinitionProviderRegistry;
import com.ibm.etools.tiles.util.TilesUtil;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webedit.viewer.utils.LinkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class TilesDefinitionUtil
implements ITilesConstants {
    private final IVirtualComponent component;
    private IFile file;
    private String[] definitionPaths;
    private boolean[] modified;
    private TilesArtifactEdit[] artifacts;
    private List templateJspModels;
    private Map artifactsCache;

    public TilesDefinitionUtil(IVirtualComponent component) {
        this.component = component;
    }

    public TilesDefinitionUtil(IVirtualComponent component, IFile targetFile) {
        this.component = component;
        this.file = targetFile;
    }

    public void setTargetFile(IFile targetFile) {
        if (this.file == null && targetFile == null) {
            return;
        }
        if (this.file != null && this.file.equals((Object)targetFile)) {
            return;
        }
        this.file = targetFile;
        this.cacheArtifacts();
    }

    protected TilesArtifactEdit[] getArtifactEdit() {
        if (this.artifacts == null) {
            String[] defFiles = this.getDefinitionPaths();
            if (defFiles == null) {
                return null;
            }
            this.artifacts = new TilesArtifactEdit[defFiles.length];
            this.modified = new boolean[defFiles.length];
            int i = 0;
            while (i < defFiles.length) {
                Object[] cached;
                if (this.artifactsCache != null && (cached = (Object[])this.artifactsCache.remove(defFiles[i])) != null) {
                    this.artifacts[i] = (TilesArtifactEdit)((Object)cached[1]);
                    this.modified[i] = (Boolean)cached[0];
                } else {
                    this.artifacts[i] = TilesArtifactEdit.getTilesArtifactEditForRead(this.component, defFiles[i]);
                    this.modified[i] = false;
                }
                ++i;
            }
        }
        return this.artifacts;
    }

    protected String[] getDefinitionPaths() {
        if (this.definitionPaths == null) {
            ITilesDefinitionFileProvider[] providers = TilesDefinitionProviderRegistry.getInstance().getProviders();
            HashSet<String> pathList = new HashSet<String>();
            int i = 0;
            while (providers != null && i < providers.length) {
                String[] paths = providers[i].getDefinitionFiles(this.component, this.file);
                if (paths != null) {
                    pathList.addAll(Arrays.asList(paths));
                }
                ++i;
            }
            this.definitionPaths = pathList.toArray(new String[pathList.size()]);
        }
        return this.definitionPaths;
    }

    protected TilesArtifactEdit getArtifactEdit(int index) {
        TilesArtifactEdit[] artifactEdits = this.getArtifactEdit();
        if (artifactEdits != null && index >= 0 && index < artifactEdits.length) {
            return artifactEdits[index];
        }
        return null;
    }

    protected void switchArtifactEdit(int i) {
        TilesArtifactEdit oldArtifact = this.artifacts[i];
        this.artifacts[i] = TilesArtifactEdit.getTilesArtifactEditForWrite(this.component, this.definitionPaths[i]);
        if (oldArtifact != null) {
            oldArtifact.dispose();
        }
    }

    public static IFile getWebFile(IFile baseFile, IPath relativePath) {
        if (baseFile == null || relativePath == null) {
            return null;
        }
        String absPath = LinkUtil.getAbsURL((IPath)baseFile.getLocation(), (IPath)baseFile.getLocation(), (String)relativePath.toString(), (boolean)false);
        return WebComponent.getFileForLocation((IPath)new Path(absPath));
    }

    public static IFile getWebFile(IVirtualComponent component, IPath path) {
        if (component == null || path == null) {
            return null;
        }
        WebComponent webComponent = new WebComponent(component);
        if (webComponent.getComponent() == null) {
            return null;
        }
        return webComponent.getComponent().getRootFolder().getFile(path).getUnderlyingFile();
    }

    public static IPath getWebFilePath(IVirtualComponent component, IFile file) {
        if (component == null || file == null) {
            return null;
        }
        if (component.equals(WebComponent.getComponent((IResource)file))) {
            return WebComponent.getVirtualResource((IResource)file).getRuntimePath();
        }
        return null;
    }

    public void dispose() {
        this.disposeCachedArtifacts();
        if (this.artifacts != null) {
            int i = 0;
            while (i < this.artifacts.length) {
                if (this.modified[i] && this.artifacts[i] != null) {
                    this.artifacts[i].save((IProgressMonitor)new NullProgressMonitor());
                }
                ++i;
            }
            this.modified = null;
        }
        if (this.templateJspModels != null) {
            Iterator it = this.templateJspModels.iterator();
            while (it.hasNext()) {
                ((IDOMModel)it.next()).releaseFromRead();
            }
        }
        if (this.artifacts != null) {
            int i = 0;
            while (i < this.artifacts.length) {
                this.artifacts[i].dispose();
                ++i;
            }
            this.artifacts = null;
        }
    }

    private void disposeCachedArtifacts() {
        if (this.artifactsCache != null) {
            Iterator it = this.artifactsCache.keySet().iterator();
            while (it.hasNext()) {
                Object[] cache = (Object[])this.artifactsCache.get(it.next());
                if (cache == null || cache[0] == null || cache[1] == null) continue;
                if (((Boolean)cache[0]).booleanValue()) {
                    ((TilesArtifactEdit)((Object)cache[1])).save((IProgressMonitor)new NullProgressMonitor());
                }
                ((TilesArtifactEdit)((Object)cache[1])).dispose();
            }
            this.artifactsCache = null;
        }
    }

    private void cacheArtifacts() {
        if (this.artifacts == null) {
            return;
        }
        if (this.artifactsCache == null) {
            this.artifactsCache = new HashMap();
        }
        int i = 0;
        while (i < this.artifacts.length) {
            Object[] value = new Object[]{this.modified[i], this.artifacts[i]};
            this.artifactsCache.put(this.definitionPaths[i], value);
            ++i;
        }
        this.definitionPaths = null;
        this.artifacts = null;
        this.modified = null;
    }

    public String[] getDefinitions() {
        DefinitionIterator it = new DefinitionIterator();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            Definition def = it.next().getDefinition();
            if (def.getName() == null || def.getName().trim().length() <= 0 || list.contains(def.getName())) continue;
            list.add(def.getName());
        }
        String[] defs = new String[list.size()];
        list.toArray(defs);
        return defs;
    }

    public String[] getValidDefinitions() {
        DefinitionIterator it = new DefinitionIterator();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            IFile file;
            IPath path;
            Definition def = it.next().getDefinition();
            if (def.getName() == null || def.getName().trim().length() <= 0 || list.contains(def.getName()) || (path = this.lookupTemplateJspFor(def.getName())) == null || (file = TilesDefinitionUtil.getWebFile(this.component, path)) == null || !file.exists()) continue;
            list.add(def.getName());
        }
        String[] defs = new String[list.size()];
        list.toArray(defs);
        return defs;
    }

    protected static String getPage(Definition def) {
        String path = def.getPath();
        if (path == null) {
            path = def.getPage();
        }
        if (path == null) {
            path = def.getTemplate();
        }
        return path;
    }

    protected static void setPage(Definition def, String page) {
        if (def == null || page == null) {
            return;
        }
        def.setPath(page);
        def.unsetPage();
        def.unsetTemplate();
    }

    protected DefinitionIdentifier lookupDefinitionIdentifierFor(String definitionName) {
        if (definitionName == null) {
            return null;
        }
        DefinitionIterator it = new DefinitionIterator();
        while (it.hasNext()) {
            DefinitionIdentifier id = it.next();
            Definition def = id.getDefinition();
            if (!definitionName.equals(def.getName())) continue;
            return id;
        }
        return null;
    }

    protected Definition lookupDefinition(String definitionName) {
        DefinitionIdentifier id = this.lookupDefinitionIdentifierFor(definitionName);
        return id != null ? id.getDefinition() : null;
    }

    public IPath lookupTemplateJspFor(String definitionName) {
        Definition def = this.lookupDefinition(definitionName);
        ArrayList<String> allDefs = new ArrayList<String>();
        while (def != null) {
            String page = TilesDefinitionUtil.getPage(def);
            if (page != null && page.trim().length() > 0) {
                return new Path(page);
            }
            allDefs.add(def.getName());
            String superDef = def.getExtends();
            if (superDef == null || superDef.length() <= 0 || allDefs.contains(superDef)) break;
            def = this.lookupDefinition(superDef);
        }
        return null;
    }

    protected static String getAddValue(Add add) {
        if (add == null) {
            return null;
        }
        String value = add.getValue();
        if (value == null) {
            value = add.getContent();
        }
        if (value == null) {
            value = add.getBody();
        }
        return value;
    }

    protected static String getPutValue(Put put) {
        if (put == null) {
            return null;
        }
        String value = put.getValue();
        if (value == null) {
            value = put.getContent();
        }
        if (value == null) {
            value = put.getBody();
        }
        return value;
    }

    protected static void setPutValue(Put put, String value) {
        if (put == null || value == null) {
            return;
        }
        put.setValue(value);
        put.unsetContent();
    }

    protected String getContentType(Add add) {
        String value;
        if (add == null) {
            return null;
        }
        if (add.isSetDirect()) {
            if (add.isDirect()) {
                return "string";
            }
            return "page";
        }
        ContentType type = add.getType();
        if (add.isSetType()) {
            if (type.getValue() == 0) {
                return "string";
            }
            if (type.getValue() == 3) {
                return "definition";
            }
            if (type.getValue() == 2 || type.getValue() == 1) {
                return "page";
            }
        }
        if ((value = TilesDefinitionUtil.getAddValue(add)) != null && value.length() > 0 && this.lookupDefinition(value) != null) {
            return "definition";
        }
        return "page";
    }

    protected String getContentType(Put put) {
        String value;
        if (put == null) {
            return null;
        }
        if (put.isSetDirect()) {
            if (put.isDirect()) {
                return "string";
            }
            return "page";
        }
        ContentType type = put.getType();
        if (put.isSetType()) {
            if (type.getValue() == 0) {
                return "string";
            }
            if (type.getValue() == 3) {
                return "definition";
            }
            if (type.getValue() == 2 || type.getValue() == 1) {
                return "page";
            }
        }
        if ((value = TilesDefinitionUtil.getPutValue(put)) != null && value.length() > 0 && this.lookupDefinition(value) != null) {
            return "definition";
        }
        return "page";
    }

    public Map lookupPutAreaMap(String definitionName) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (definitionName == null) {
            return map;
        }
        Definition def = this.lookupDefinition(definitionName);
        while (def != null) {
            for (Put put : def.getPuts()) {
                if (map.get(put.getName()) != null) continue;
                map.put(put.getName(), TilesDefinitionUtil.getPutValue(put));
            }
            String superDef = def.getExtends();
            if (superDef == null || superDef.length() <= 0) break;
            def = this.lookupDefinition(superDef);
        }
        return map;
    }

    public Map lookupPutAreaMapWithType(String definitionName) {
        return this.lookupPutAreaMapWithType(definitionName, false);
    }

    public Map lookupPutAreaMapWithType(String definitionName, boolean withPutList) {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        if (definitionName == null) {
            return map;
        }
        Definition def = this.lookupDefinition(definitionName);
        while (def != null) {
            String superDef;
            for (Put put : def.getPuts()) {
                if (map.get(put.getName()) != null || put.getName() == null) continue;
                map.put(put.getName(), new Object[]{TilesDefinitionUtil.getPutValue(put), this.getContentType(put)});
            }
            if (withPutList) {
                for (PutList putList : def.getPutLists()) {
                    if (map.get(putList.getName()) != null || putList.getName() == null) continue;
                    map.put(putList.getName(), new Object[]{this.getAddTagsListWithType(putList).toArray(), "list"});
                }
            }
            if ((superDef = def.getExtends()) == null || superDef.length() <= 0) break;
            def = this.lookupDefinition(superDef);
        }
        return map;
    }

    protected List getAddTagsListWithType(PutList putList) {
        if (putList == null) {
            return null;
        }
        ArrayList<Object[]> adds = new ArrayList<Object[]>();
        for (Add add : putList.getAdds()) {
            adds.add(new Object[]{TilesDefinitionUtil.getAddValue(add), this.getContentType(add)});
        }
        return adds;
    }

    public String[] collectGetAreaNames(String definitionName) {
        return this.collectGetAreaNames(definitionName, true, true, true);
    }

    public String[] collectGetAreaNames(String definitionName, boolean withInsert, boolean withGet, boolean withGetAsString) {
        IPath path = this.lookupTemplateJspFor(definitionName);
        if (path == null) {
            return new String[0];
        }
        IFile jsp = TilesDefinitionUtil.getWebFile(this.component, path.makeRelative());
        IDOMModel jspModel = null;
        try {
            jspModel = (IDOMModel)new ModelManagerUtil(null, null).getModelForRead(jsp);
            String[] stringArray = TilesUtil.collectGetAreaNames(jspModel, withInsert, withGet, withGetAsString);
            return stringArray;
        }
        finally {
            if (jspModel != null) {
                jspModel.releaseFromRead();
            }
        }
    }

    public Map collectGetAreaMap(String definitionName, boolean withInsert, boolean withGet, boolean withGetAsString) {
        IPath path = this.lookupTemplateJspFor(definitionName);
        if (path == null) {
            return Collections.EMPTY_MAP;
        }
        IFile jsp = TilesDefinitionUtil.getWebFile(this.component, path.makeRelative());
        IDOMModel jspModel = (IDOMModel)new ModelManagerUtil(null, null).getModelForRead(jsp);
        if (jspModel != null) {
            if (this.templateJspModels == null) {
                this.templateJspModels = new ArrayList();
            }
            if (this.templateJspModels.contains(jspModel)) {
                jspModel.releaseFromRead();
            } else {
                this.templateJspModels.add(jspModel);
            }
        }
        return TilesUtil.collectGetAreaMap(jspModel, withInsert, withGet, withGetAsString);
    }

    private void cleanupSampleDefinitionEntry(int defArtifactIndex) {
        DefinitionIterator it = new DefinitionIterator();
        TilesArtifactEdit edit = this.getArtifactEdit(defArtifactIndex);
        while (it.hasNext()) {
            Definition def;
            String name;
            DefinitionIdentifier id = it.next();
            if (id.getTilesArtifactEdit() != edit || (name = (def = id.getDefinition()).getName()) != null && name.trim().length() > 0 || def.getPuts().size() + def.getPutLists().size() > 0) continue;
            TilesDefinitions definitions = this.getArtifactEdit(defArtifactIndex).getTilesDefinitions();
            definitions.getDefinitions().remove((Object)def);
            this.modified[defArtifactIndex] = true;
        }
    }

    public boolean register(String definitionName, IPath template, Map putAreaMap) {
        return this.register(definitionName, null, template, putAreaMap);
    }

    public boolean register(String definitionName, String superDefinitionName, IPath template, Map putAreaMapWithType) {
        Definition def;
        if (this.getArtifactEdit() == null || definitionName == null) {
            return false;
        }
        DefinitionIdentifier id = this.lookupDefinitionIdentifierFor(definitionName);
        int index = this.getArtifactEdit().length - 1;
        if (id != null) {
            index = id.index();
        }
        if (index < 0) {
            return false;
        }
        if (!this.modified[index]) {
            this.switchArtifactEdit(index);
            id = this.lookupDefinitionIdentifierFor(definitionName);
        }
        Definition definition = def = id != null ? id.getDefinition() : null;
        if (def == null) {
            TilesDefinitions definitions = this.getArtifactEdit(index).getTilesDefinitions();
            if (definitions == null) {
                definitions = TilesFactory.eINSTANCE.createTilesDefinitions();
                this.getArtifactEdit(index).setRoot(definitions);
            }
            def = TilesFactory.eINSTANCE.createDefinition();
            def.setName(definitionName);
            definitions.getDefinitions().add((Object)def);
        } else if (definitionName.equals(superDefinitionName)) {
            superDefinitionName = null;
        }
        if (superDefinitionName != null) {
            def.setExtends(superDefinitionName);
        }
        if (template != null) {
            TilesDefinitionUtil.setPage(def, template.toString());
        }
        if (putAreaMapWithType != null) {
            for (Object name : putAreaMapWithType.keySet()) {
                Object[] valueWithType = (Object[])putAreaMapWithType.get(name);
                Object value = valueWithType[0];
                String type = valueWithType[1].toString();
                ContentType contentType = TilesDefinitionUtil.getContentType(type);
                if (name == null || value == null || contentType == null) continue;
                Put put = null;
                for (Put testPut : def.getPuts()) {
                    if (!name.equals(testPut.getName())) continue;
                    put = testPut;
                    break;
                }
                if (put == null) {
                    put = TilesFactory.eINSTANCE.createPut();
                    put.setName(name.toString());
                    def.getPuts().add((Object)put);
                }
                TilesDefinitionUtil.setPutValue(put, value.toString());
                put.setType(contentType);
            }
        }
        this.cleanupSampleDefinitionEntry(index);
        this.modified[index] = true;
        return true;
    }

    protected static ContentType getContentType(String type) {
        if ("page".equals(type)) {
            return ContentType.PAGE_LITERAL;
        }
        if ("string".equals(type)) {
            return ContentType.STRING_LITERAL;
        }
        if ("definition".equals(type)) {
            return ContentType.DEFINITION_LITERAL;
        }
        if ("template".equals(type)) {
            return ContentType.TEMPLATE_LITERAL;
        }
        return null;
    }

    public void remove(String definitionName) {
        Definition def;
        if (this.getArtifactEdit() == null || definitionName == null) {
            return;
        }
        DefinitionIdentifier id = this.lookupDefinitionIdentifierFor(definitionName);
        if (id == null) {
            return;
        }
        if (!this.modified[id.index()]) {
            this.switchArtifactEdit(id.index());
            id = this.lookupDefinitionIdentifierFor(definitionName);
        }
        if ((def = id.getDefinition()) != null) {
            TilesDefinitions definitions = this.getArtifactEdit(id.index()).getTilesDefinitions();
            definitions.getDefinitions().remove((Object)def);
            this.modified[id.index()] = true;
        }
        this.cleanupSampleDefinitionEntry(id.index());
    }

    public class DefinitionIdentifier {
        private final TilesArtifactEdit edit;
        private final Definition def;
        private final int index;

        public DefinitionIdentifier(TilesArtifactEdit edit, int index, Definition def) {
            this.edit = edit;
            this.def = def;
            this.index = index;
        }

        public TilesArtifactEdit getTilesArtifactEdit() {
            return this.edit;
        }

        public Definition getDefinition() {
            return this.def;
        }

        public int index() {
            return this.index;
        }
    }

    public class DefinitionIterator {
        int artifactIndex = -1;
        ListIterator it;

        public DefinitionIterator() {
            if (TilesDefinitionUtil.this.getArtifactEdit() == null) {
                return;
            }
            this.artifactIndex = TilesDefinitionUtil.this.getArtifactEdit().length - 1;
            this.initIterator();
        }

        private void initIterator() {
            if (this.artifactIndex < 0) {
                return;
            }
            TilesDefinitions definitions = TilesDefinitionUtil.this.getArtifactEdit(this.artifactIndex).getTilesDefinitions();
            if (definitions == null) {
                return;
            }
            EList defList = definitions.getDefinitions();
            this.it = defList.listIterator(defList.size());
        }

        public boolean hasNext() {
            if (this.it != null && this.it.hasPrevious()) {
                return true;
            }
            int index = this.artifactIndex;
            while (index > 0) {
                EList defList;
                TilesDefinitions definitions;
                if ((definitions = TilesDefinitionUtil.this.getArtifactEdit(--index).getTilesDefinitions()) == null || (defList = definitions.getDefinitions()) == null || defList.size() <= 0) continue;
                return true;
            }
            return false;
        }

        public DefinitionIdentifier next() {
            if (this.it != null && this.it.hasPrevious()) {
                Definition def = (Definition)this.it.previous();
                return new DefinitionIdentifier(TilesDefinitionUtil.this.getArtifactEdit(this.artifactIndex), this.artifactIndex, def);
            }
            if (this.artifactIndex > 0) {
                --this.artifactIndex;
                this.initIterator();
                return this.next();
            }
            return null;
        }
    }
}

