/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.util;

import com.ibm.etools.tiles.definitions.TilesDefinitions;
import com.ibm.etools.tiles.definitions.xml.TilesDefinitionsResource;
import com.ibm.etools.tiles.definitions.xml.TilesDefinitionsResourceFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.internal.listeners.ValidateEditListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateInputProvider;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorImpl;

public class TilesArtifactEdit
extends ArtifactEdit {
    private final URI uri;
    private boolean registered;

    public static TilesArtifactEdit getTilesArtifactEditForRead(IVirtualComponent component, String filePath) {
        return new TilesArtifactEdit(component, filePath, true);
    }

    public static TilesArtifactEdit getTilesArtifactEditForWrite(IVirtualComponent component, String filePath) {
        return new TilesArtifactEdit(component, filePath, false);
    }

    public TilesArtifactEdit(IVirtualComponent component, String filePath, boolean toAccessAsReadOnly) {
        super(component.getProject(), toAccessAsReadOnly);
        this.uri = URI.createURI((String)filePath);
    }

    public TilesDefinitions getTilesDefinitions() {
        Object rootObject;
        EList contents;
        TilesDefinitionsResource resource = this.getTilesDefinitionsResource();
        if (resource != null && (contents = resource.getContents()).size() > 0 && (rootObject = contents.get(0)) instanceof TilesDefinitions) {
            return (TilesDefinitions)contents.get(0);
        }
        return null;
    }

    public void setRoot(TilesDefinitions defs) {
        TilesDefinitionsResource resource = this.getTilesDefinitionsResource();
        if (resource != null) {
            EList contents = resource.getContents();
            contents.add(0, defs);
        }
    }

    private TilesDefinitionsResource getTilesDefinitionsResource() {
        if (!this.registered) {
            ResourceSet resSet = this.getArtifactEditModel().getResourceSet();
            WTPResourceFactoryRegistry registry = (WTPResourceFactoryRegistry)resSet.getResourceFactoryRegistry();
            registry.registerLastFileSegment(this.uri.lastSegment(), (Resource.Factory)new TilesDefinitionsResourceFactory());
            this.registered = true;
        }
        TilesDefinitionsResource resource = (TilesDefinitionsResource)this.getArtifactEditModel().getResource(this.uri);
        return resource;
    }

    public IFile getFile() {
        IVirtualResource resource = this.getComponent().getRootFolder().findMember(this.uri.toString());
        if (resource != null && resource.getType() == 16) {
            return ((IVirtualFile)resource).getUnderlyingFile();
        }
        return null;
    }

    public ResourceStateInputProvider getResourceStateInputProvider() {
        return new TilesResourceStateInputProvider();
    }

    public IStatus validateEdit() {
        ValidateEditListener listener = new ValidateEditListener(null, (ResourceStateValidator)new ResourceStateValidatorImpl(this.getResourceStateInputProvider()));
        final Shell[] shells = new Shell[1];
        if (PlatformUI.isWorkbenchRunning()) {
            final Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    shells[0] = display.getActiveShell();
                }
            });
        }
        listener.setShell(shells[0]);
        return listener.validateState();
    }

    class TilesResourceStateInputProvider
    implements ResourceStateInputProvider {
        TilesResourceStateInputProvider() {
        }

        public void cacheNonResourceValidateState(List roNonResourceFiles) {
            TilesArtifactEdit.this.getArtifactEditModel().cacheNonResourceValidateState(roNonResourceFiles);
        }

        public List getNonResourceFiles() {
            return null;
        }

        public List getNonResourceInconsistentFiles() {
            return null;
        }

        public List getResources() {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.add(TilesArtifactEdit.this.getArtifactEditModel().getResource(TilesArtifactEdit.this.uri));
            return resources;
        }

        public boolean isDirty() {
            return TilesArtifactEdit.this.getArtifactEditModel().getResource(TilesArtifactEdit.this.uri).isModified();
        }
    }
}

