/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.pd.vct.tags;

import com.ibm.etools.tiles.pd.vct.TilesDefinitionContextVisualizer;
import com.ibm.etools.tiles.pd.vct.TilesVisualizerUtil;
import com.ibm.etools.tiles.util.ITilesConstants;
import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webedit.links.util.InvalidURLException;
import com.ibm.etools.webedit.vct.Context;
import com.ibm.etools.webedit.vct.VisualizerReturnCode;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TilesInsertTagVisualizer
extends TilesDefinitionContextVisualizer
implements ITilesConstants {
    private boolean typePage;

    public VisualizerReturnCode doStart(Context context) {
        this.typePage = false;
        Node self = context.getSelf();
        ArrayList<Node> nodeList = new ArrayList<Node>();
        Path insertedFilePath = null;
        NamedNodeMap attributes = self.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.item(i).getNodeName();
            String value = attributes.item(i).getNodeValue();
            if (name.equalsIgnoreCase("template") || name.equalsIgnoreCase("page") || name.equalsIgnoreCase("component")) {
                nodeList.add(context.createIncludeElement(value));
                if (value.startsWith("/")) {
                    insertedFilePath = new Path(value);
                } else {
                    try {
                        FileURL fileURL = new FileURL(context.getMyPath());
                        IFile baseFile = WebComponent.getFileForLocation((IPath)fileURL.getPath());
                        IFile file = TilesDefinitionUtil.getWebFile(baseFile, (IPath)new Path(value));
                        insertedFilePath = TilesDefinitionUtil.getWebFilePath(WebComponent.getComponent((IResource)file), file);
                    }
                    catch (InvalidURLException invalidURLException) {}
                }
                this.typePage = true;
                break;
            }
            if (name.equalsIgnoreCase("definition")) {
                IVirtualComponent component = TilesVisualizerUtil.getComponent(context);
                TilesDefinitionUtil util = new TilesDefinitionUtil(component, TilesVisualizerUtil.getFile(context));
                try {
                    IPath path = util.lookupTemplateJspFor(value);
                    if (path != null) {
                        nodeList.add(context.createIncludeElement(path.toString()));
                        insertedFilePath = path;
                        this.typePage = true;
                    }
                    nodeList.add(0, TilesVisualizerUtil.createHiddenTagIcon(context, "tiles/insert_pal"));
                }
                finally {
                    util.dispose();
                }
            } else if (name.equalsIgnoreCase("attribute")) {
                this.processGet(context, value, nodeList);
                break;
            }
            ++i;
        }
        String tagPrefix = self.getNodeName().substring(0, self.getNodeName().length() - self.getLocalName().length());
        String tagPut = String.valueOf(tagPrefix) + "put";
        String tagPutList = String.valueOf(tagPrefix) + "putList";
        Node orgNode = self.getFirstChild();
        while (orgNode != null) {
            boolean add = true;
            if (orgNode.getNodeType() == 1) {
                if (this.typePage && (tagPut.equals(orgNode.getNodeName()) || tagPutList.equals(orgNode.getNodeName())) && orgNode.getAttributes().getNamedItem("name") != null) {
                    add = false;
                }
            } else if (orgNode.getNodeType() == 3 && orgNode.getNodeValue().trim().length() <= 0) {
                add = false;
            }
            if (add) {
                nodeList.add(orgNode);
            }
            orgNode = orgNode.getNextSibling();
        }
        if (nodeList.isEmpty()) {
            nodeList.add(TilesVisualizerUtil.createHiddenTagIcon(context, "tiles/insert_pal"));
        }
        context.putVisual(nodeList);
        if (insertedFilePath != null) {
            this.registerDefinitionContext(context, (IPath)insertedFilePath, null);
        }
        return VisualizerReturnCode.OK;
    }

    public boolean isReadOnlyVisual() {
        return false;
    }

    public boolean hasPage() {
        return this.typePage;
    }
}

