/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.pd.vct;

import com.ibm.etools.tiles.nls.ResourceHandler;
import com.ibm.etools.tiles.pd.vct.TilesDefinitionContext;
import com.ibm.etools.tiles.pd.vct.TilesVisualizer;
import com.ibm.etools.tiles.pd.vct.TilesVisualizerUtil;
import com.ibm.etools.tiles.util.ITilesConstants;
import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.webedit.common.commands.utils.ImportSource;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webedit.editor.WebEditPlugin;
import com.ibm.etools.webedit.editor.internal.pane.PageDesignerPanePreferences;
import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webedit.links.util.InvalidURLException;
import com.ibm.etools.webedit.vct.Context;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webedit.viewer.vct.OptionSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TilesDefinitionContextVisualizer
extends TilesVisualizer
implements ITilesConstants {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List getNodeFromContent(Object content, String contentType, Context context, IFile targetFile) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (contentType == null || contentType.equalsIgnoreCase("page") || contentType.equalsIgnoreCase("template")) {
            nodes.add(context.createIncludeElement(content.toString()));
            return nodes;
        } else if (contentType.equalsIgnoreCase("string")) {
            if (content instanceof NodeList) {
                Node child = ((NodeList)content).item(0);
                while (child != null) {
                    nodes.add(child);
                    child = child.getNextSibling();
                }
                return nodes;
            } else {
                if (content == null) return nodes;
                Node node = this.getTextNodeFromContentString(context, content.toString());
                if (node != null && node.getNodeType() == 11) {
                    Node child = node.getFirstChild();
                    while (child != null) {
                        nodes.add(child);
                        child = child.getNextSibling();
                    }
                    return nodes;
                } else {
                    nodes.add(node);
                }
            }
            return nodes;
        } else if (contentType.equalsIgnoreCase("definition")) {
            TilesDefinitionUtil util = new TilesDefinitionUtil(TilesVisualizerUtil.getComponent(context), targetFile);
            try {
                IPath path = util.lookupTemplateJspFor(content.toString());
                if (path == null) return nodes;
                nodes.add(context.createIncludeElement(path.toString()));
                return nodes;
            }
            finally {
                util.dispose();
            }
        } else {
            nodes.add(TilesVisualizerUtil.createHiddenTagIcon(context, "tiles/get_pal"));
        }
        return nodes;
    }

    public Node getTextNodeFromContentString(Context context, String contentString) {
        Document doc = context.getDocument();
        ImportSource is = new ImportSource(doc, null);
        is.doFixup(false);
        DocumentFragment docFrag = is.getFragment(contentString);
        return docFrag;
    }

    protected TilesDefinitionContext getParentDefinitionContext(Context context) {
        Object value;
        IVirtualComponent component = null;
        FileURL fileURL = null;
        try {
            fileURL = new FileURL(context.getMyPath());
        }
        catch (InvalidURLException invalidURLException) {}
        if (fileURL == null) {
            return null;
        }
        IFile file = fileURL.getIFile();
        component = WebComponent.getComponent((IResource)file);
        IPath path = TilesDefinitionUtil.getWebFilePath(component, file);
        if (path == null) {
            return null;
        }
        OptionSet optionSet = (OptionSet)context.getAttribute("OptionSet");
        Object option = optionSet.getOption("TilesInsertTag");
        if (option instanceof Map && (value = ((Map)option).get(path)) instanceof TilesDefinitionContext) {
            return (TilesDefinitionContext)value;
        }
        return null;
    }

    protected void registerDefinitionContext(Context context, IPath path, TilesDefinitionContext defContext) {
        OptionSet optionSet = (OptionSet)context.getAttribute("OptionSet");
        HashMap option = optionSet.getOption("TilesInsertTag");
        if (!(option instanceof Map)) {
            option = new HashMap();
            optionSet.addOption("TilesInsertTag", option);
        }
        if (defContext == null) {
            defContext = new TilesDefinitionContext(context);
        }
        ((Map)option).put(path, defContext);
    }

    protected void processGet(Context context, String value, List nodeList) {
        this.processGet(context, value, nodeList, false);
    }

    /*
     * WARNING - void declaration
     */
    protected void processGet(Context context, String value, List nodeList, boolean asString) {
        TilesDefinitionContext defContext = this.getParentDefinitionContext(context);
        List contentNodes = null;
        if (defContext != null) {
            Object[] objectArray = defContext.getContentAndType(value);
            if (objectArray != null) {
                Object content = objectArray[0];
                String contentType = objectArray[1].toString();
                List<Object> contents = null;
                if ("list".equals(contentType)) {
                    contents = content instanceof Object[] ? Arrays.asList((Object[])content) : Collections.EMPTY_LIST;
                } else {
                    contents = new ArrayList();
                    contents.add(new Object[]{content, contentType});
                }
                for (Object[] objectArray2 : contents) {
                    if (contentType == null) continue;
                    content = objectArray2[0];
                    contentType = objectArray2[1].toString();
                    List nodes = this.getNodeFromContent(content, asString ? "string" : contentType, context, defContext.getTargetFile());
                    if (contentNodes == null) {
                        contentNodes = nodes;
                    } else {
                        contentNodes.addAll(nodes);
                    }
                    if (!contentType.equalsIgnoreCase("definition")) continue;
                    TilesDefinitionUtil util = new TilesDefinitionUtil(TilesVisualizerUtil.getComponent(context), defContext.getTargetFile());
                    try {
                        IPath insertedFilePath = util.lookupTemplateJspFor(content.toString());
                        if (insertedFilePath == null) continue;
                        this.registerDefinitionContext(context, insertedFilePath, new TilesDefinitionContext(context, content.toString()));
                        insertedFilePath = null;
                    }
                    finally {
                        util.dispose();
                    }
                }
            } else {
                nodeList.clear();
                Document doc = context.getDocument();
                String text = NLS.bind((String)ResourceHandler._UI_Tiles_Definition_Context_Visualizer_0, (Object)value);
                String tagSource = NLS.bind((String)"<span style='font-style:italic;font-size:smaller'>{0}</span>", (Object)text);
                ImportSource is = new ImportSource(doc, null);
                is.doFixup(false);
                DocumentFragment fragment = is.getFragment(tagSource);
                Node node = fragment.getFirstChild();
                while (node != null) {
                    nodeList.add(node);
                    node = node.getNextSibling();
                }
            }
        } else if (nodeList.size() <= 0) {
            Document document = context.getDocument();
            String text = NLS.bind((String)ResourceHandler._UI_Tiles_Definition_Context_Visualizer_1, (Object)value);
            String tagSource = NLS.bind((String)"<span style='font-style:italic;font-size:smaller'>{0}</span>", (Object)text);
            ImportSource is = new ImportSource(document, null);
            is.doFixup(false);
            DocumentFragment fragment = is.getFragment(tagSource);
            Node node = fragment.getFirstChild();
            while (node != null) {
                nodeList.add(node);
                node = node.getNextSibling();
            }
        }
        String string = ActionUtil.getActivePaneDomain();
        if (contentNodes == null) {
            void var7_14;
            if (string == null) {
                String string2 = TilesDefinitionContextVisualizer.getDomainFromSavedPreference(string);
            }
            if (!var7_14.equalsIgnoreCase("Preview")) {
                nodeList.add(0, TilesVisualizerUtil.createHiddenTagIconWithFullPath(context, "icons/full/ctool16/content_area_start.gif"));
                nodeList.add(TilesVisualizerUtil.createHiddenTagIconWithFullPath(context, "icons/full/ctool16/content_area_end.gif"));
            }
        } else {
            nodeList.addAll(contentNodes);
        }
    }

    private static String getDomainFromSavedPreference(String domain) {
        PageDesignerPanePreferences pref = new PageDesignerPanePreferences(WebEditPlugin.getDefault().getPreferenceStore());
        if (pref != null) {
            domain = pref.getActiveTabId();
        }
        return domain;
    }
}

