/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.pd.vct;

import com.ibm.etools.tiles.pd.vct.TilesVisualizerUtil;
import com.ibm.etools.tiles.util.ITilesConstants;
import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.tiles.util.TilesUtil;
import com.ibm.etools.webedit.internal.vct.ContextEx;
import com.ibm.etools.webedit.vct.Context;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TilesDefinitionContext
implements ITilesConstants {
    private Node realNode;
    private String definition;
    private IVirtualComponent component;
    private IFile targetFile;

    public TilesDefinitionContext(Context externalContext) {
        this.realNode = ((ContextEx)externalContext).getRealNode();
        this.definition = ((Element)this.realNode).getAttribute("definition");
        this.component = TilesVisualizerUtil.getComponent(externalContext);
        this.targetFile = TilesVisualizerUtil.getFile(externalContext);
    }

    public TilesDefinitionContext(Context context, String definition) {
        this.definition = definition;
        this.component = TilesVisualizerUtil.getComponent(context);
        this.targetFile = TilesVisualizerUtil.getFile(context);
    }

    public Object[] getContentAndType(String name) {
        if (name == null) {
            return null;
        }
        if (this.realNode != null) {
            Node child = this.realNode.getFirstChild();
            while (child != null) {
                Element ele;
                if (child.getNodeType() == 1 && name.equals((ele = (Element)child).getAttribute("name"))) {
                    String type = TilesUtil.getTilesNodeType(ele);
                    if ("TilesPut".equals(type)) {
                        Object content = TilesUtil.getPutValue(ele);
                        String contentType = TilesUtil.getTilesPutTagContentType(ele);
                        if (name != null) {
                            if (content == null) {
                                content = ele.getChildNodes();
                            }
                            return new Object[]{content, contentType};
                        }
                    } else if ("TilesPutList".equals(type)) {
                        Node orgNode = ele.getFirstChild();
                        ArrayList<Object[]> contents = new ArrayList<Object[]>();
                        while (orgNode != null) {
                            Element addEle;
                            String tilesNodeType;
                            if (orgNode.getNodeType() == 1 && "TilesAdd".equals(tilesNodeType = TilesUtil.getTilesNodeType(addEle = (Element)orgNode))) {
                                Object content = TilesUtil.getPutValue(addEle);
                                String contentType = TilesUtil.getTilesPutTagContentType(addEle);
                                if (name != null) {
                                    if (content == null) {
                                        content = ele.getChildNodes();
                                    }
                                    contents.add(new Object[]{content, contentType});
                                }
                            }
                            orgNode = orgNode.getNextSibling();
                        }
                        return new Object[]{contents.toArray(), "list"};
                    }
                }
                child = child.getNextSibling();
            }
        }
        if (this.definition != null) {
            TilesDefinitionUtil util = new TilesDefinitionUtil(this.component, this.targetFile);
            try {
                IPath path = util.lookupTemplateJspFor(this.definition);
                if (path != null) {
                    Map map = util.lookupPutAreaMapWithType(this.definition, true);
                    Object[] objectArray = (Object[])map.get(name);
                    return objectArray;
                }
            }
            finally {
                util.dispose();
            }
        }
        return null;
    }

    public IFile getTargetFile() {
        return this.targetFile;
    }
}

