/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.internal.util;

import com.ibm.etools.tiles.Logger;
import com.ibm.etools.tiles.TilesPlugin;
import com.ibm.etools.tiles.util.ITilesDefinitionFileProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class TilesDefinitionProviderRegistryReader {
    public static final String EXTENSION_POINT = "definitionFileProvider";
    public static final String ELE_PROVIDER = "provider";
    public static final String ATTR_CLASS = "class";
    List providers = new ArrayList();

    public ITilesDefinitionFileProvider[] getProviders() {
        ITilesDefinitionFileProvider[] array = new ITilesDefinitionFileProvider[this.providers.size()];
        this.providers.toArray(array);
        return array;
    }

    public TilesDefinitionProviderRegistryReader() {
        this.readRegistry(Platform.getExtensionRegistry(), TilesPlugin.getPluginId(), EXTENSION_POINT);
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element != null && element.getName().equals(ELE_PROVIDER)) {
            try {
                Object provider = element.createExecutableExtension(ATTR_CLASS);
                if (provider instanceof ITilesDefinitionFileProvider) {
                    this.providers.add(provider);
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
            return true;
        }
        return false;
    }

    protected void readElementChildren(IConfigurationElement element) {
        this.readElements(element.getChildren());
    }

    protected void readElements(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!this.readElement(elements[i])) {
                this.logUnknownElement(elements[i]);
            }
            ++i;
        }
    }

    protected void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    protected void readRegistry(IExtensionRegistry registry, String pluginId, String extensionPoint) {
        IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPoint);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                this.readExtension(extensions[i]);
                ++i;
            }
        }
    }

    protected void logUnknownElement(IConfigurationElement element) {
        this.logError(element, "Unknown extension tag found: " + element.getName());
    }

    protected void logError(IConfigurationElement element, String text) {
        Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName());
        String uniqueID = "";
        if (bundle != null) {
            uniqueID = bundle.getSymbolicName();
        }
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + uniqueID + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        Logger.log(buf.toString());
    }
}

