/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.intenal.links.linkdetectorprovider;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.javaee.taglib.HTMLTaglibDirectiveUtil;
import com.ibm.etools.references.web.javaee.taglib.TaglibDirective;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class TilesLinksDetectorProvider
extends AbstractWebProvider
implements ILinkDetectorProvider {
    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        IDOMModel model;
        if (!(sharedModel.getSharedModel() instanceof IDOMModel)) {
            return Collections.emptyList();
        }
        String tilesPrefix = null;
        ArrayList<ILink> links = new ArrayList<ILink>();
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            model = (IDOMModel)sharedModel.getSharedModel();
            List taglibDirectivesEx = HTMLTaglibDirectiveUtil.getTaglibDirectivesEx((IDOMModel)model);
            for (TaglibDirective taglibDirective : taglibDirectivesEx) {
                if (!"/WEB-INF/struts-tiles.tld".equals(taglibDirective.getURI()) && !"http://jakarta.apache.org/struts/tags-tiles-1.1".equals(taglibDirective.getURI()) && !"http://jakarta.apache.org/struts/tags-tiles".equals(taglibDirective.getURI())) continue;
                tilesPrefix = String.valueOf(taglibDirective.getPrefix()) + ':';
            }
        }
        if (tilesPrefix == null) {
            return Collections.emptyList();
        }
        model = (IDOMModel)sharedModel.getSharedModel();
        IDOMDocument document = model.getDocument();
        NodeIterator iter = ((DocumentTraversal)document).createNodeIterator((Node)document, 1, null, false);
        Node n = iter.nextNode();
        while (n != null) {
            String nodeName = n.getNodeName();
            if (nodeName == null || !nodeName.startsWith(tilesPrefix)) {
                n = iter.nextNode();
                continue;
            }
            if (nodeName != null) {
                IDOMAttr file;
                IDOMAttr page;
                IDOMElement domElement = (IDOMElement)n;
                if ((String.valueOf(tilesPrefix) + "add").equals(nodeName)) {
                    String valueName;
                    IDOMAttr value = (IDOMAttr)domElement.getAttributeNode("value");
                    if (value != null && ((valueName = value.getValue()).endsWith(".jsp") || valueName.endsWith(".jspf") || valueName.endsWith(".jsf"))) {
                        ILink tilesLink = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)domElement, (IDOMAttr)value, (String)"web.nocontextroot", (String)nodeName);
                        links.add(tilesLink);
                        this.addSubParseParam(tilesLink, factory);
                    }
                } else if ((String.valueOf(tilesPrefix) + "put").equals(nodeName)) {
                    ILink tilesLink;
                    String valueName;
                    String typeContent;
                    IDOMAttr content = (IDOMAttr)domElement.getAttributeNode("content");
                    IDOMAttr value = (IDOMAttr)domElement.getAttributeNode("value");
                    IDOMAttr direct = (IDOMAttr)domElement.getAttributeNode("direct");
                    IDOMAttr type = (IDOMAttr)domElement.getAttributeNode("type");
                    boolean directVal = false;
                    if (direct != null) {
                        directVal = Boolean.parseBoolean(direct.getValue());
                    }
                    boolean typeString = false;
                    if (type != null && (typeContent = type.getValue()).equalsIgnoreCase("string")) {
                        typeString = true;
                    }
                    IDOMAttr attrToAdd = null;
                    if (content != null) {
                        attrToAdd = content;
                    }
                    if (value != null) {
                        attrToAdd = value;
                    }
                    if (attrToAdd != null && ((valueName = attrToAdd.getValue()).endsWith(".jsp") || valueName.endsWith(".jspf") || valueName.endsWith(".jsf")) && !directVal && !typeString && (tilesLink = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)domElement, (IDOMAttr)attrToAdd, (String)"web.nocontextroot", (String)nodeName)) != null) {
                        links.add(tilesLink);
                        this.addSubParseParam(tilesLink, factory);
                    }
                } else if ((String.valueOf(tilesPrefix) + "insert").equals(nodeName)) {
                    String valueName;
                    page = (IDOMAttr)domElement.getAttributeNode("page");
                    IDOMAttr component = (IDOMAttr)domElement.getAttributeNode("component");
                    IDOMAttr controllerURL = (IDOMAttr)domElement.getAttributeNode("controllerUrl");
                    IDOMAttr template = (IDOMAttr)domElement.getAttributeNode("template");
                    if (page != null && ((valueName = page.getValue()).endsWith(".jsp") || valueName.endsWith(".jspf") || valueName.endsWith(".jsf"))) {
                        ILink tilesLink = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)domElement, (IDOMAttr)page, (String)"web.nocontextroot", (String)nodeName);
                        links.add(tilesLink);
                        this.addSubParseParam(tilesLink, factory);
                    }
                    if (component != null) {
                        ILink tilesLink = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)domElement, (IDOMAttr)component, (String)"web.nocontextroot", (String)nodeName);
                        links.add(tilesLink);
                        this.addSubParseParam(tilesLink, factory);
                    }
                    if (controllerURL != null) {
                        ILink tilesLink = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)domElement, (IDOMAttr)controllerURL, (String)"web.commonlink", (String)nodeName);
                        links.add(tilesLink);
                        this.addSubParseParam(tilesLink, factory);
                    }
                    if (template != null && ((valueName = template.getValue()).endsWith(".jsp") || valueName.endsWith(".jspf") || valueName.endsWith(".jsf"))) {
                        ILink tilesLink = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)domElement, (IDOMAttr)template, (String)"web.nocontextroot", (String)nodeName);
                        links.add(tilesLink);
                        this.addSubParseParam(tilesLink, factory);
                    }
                } else if ((String.valueOf(tilesPrefix) + "definition").equals(nodeName)) {
                    ILink tilesLink;
                    String valueName;
                    page = (IDOMAttr)domElement.getAttributeNode("page");
                    IDOMAttr template = (IDOMAttr)domElement.getAttributeNode("template");
                    if (page != null && ((valueName = page.getValue()).endsWith(".jsp") || valueName.endsWith(".jspf") || valueName.endsWith(".jsf"))) {
                        tilesLink = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)domElement, (IDOMAttr)page, (String)"web.commonlink", (String)nodeName);
                        links.add(tilesLink);
                        this.addSubParseParam(tilesLink, factory);
                    }
                    if (template != null && ((valueName = template.getValue()).endsWith(".jsp") || valueName.endsWith(".jspf") || valueName.endsWith(".jsf"))) {
                        tilesLink = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)domElement, (IDOMAttr)template, (String)"web.commonlink", (String)nodeName);
                        links.add(tilesLink);
                        this.addSubParseParam(tilesLink, factory);
                    }
                } else if ((String.valueOf(tilesPrefix) + "initComponentDefinitions").equals(nodeName) && (file = (IDOMAttr)domElement.getAttributeNode("file")) != null) {
                    ILink tilesLink = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)domElement, (IDOMAttr)file, (String)"web.commonlink", (String)nodeName);
                    links.add(tilesLink);
                    this.addSubParseParam(tilesLink, factory);
                }
            }
            n = iter.nextNode();
        }
        return links;
    }

    void addSubParseParam(ILink tilesLink, ReferenceElementFactory factory) {
        factory.addParam(tilesLink, "subparse", "true");
    }
}

