/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.tiles.intenal.links.linkdetectorprovider;

import com.ibm.etools.palette.Logger;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.services.providers.ILinkTransformerProvider;
import com.ibm.etools.references.services.providers.ProviderArguments;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.webedit.links.util.ModuleUtil;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ServletLinksTransformer
implements ILinkTransformerProvider {
    public static final String ENCODE_PREFIX = "<%= request.getContextPath()%>";
    public static final String ENCODE_EL_PREFIX = "${pageContext.request.contextPath}";
    private int jspVersion = 0;
    private IProject projectCacheForJspVersion;

    private boolean isJSP(IFile file) {
        boolean isJsp = this.isKind(file, ContentTypeIdForJSP.ContentTypeID_JSP) || this.isKind(file, ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT);
        return isJsp;
    }

    private boolean isTemplate(IFile file) {
        if (file == null) {
            return false;
        }
        String extension = file.getLocation().getFileExtension();
        if (extension == null) {
            return false;
        }
        if (extension.compareToIgnoreCase("htpl") == 0) {
            return true;
        }
        return extension.compareToIgnoreCase("jtpl") == 0;
    }

    private boolean isKind(IFile file, String id) {
        IContentType[] contentTypes;
        IContentType contentTypeToMatch = Platform.getContentTypeManager().getContentType(id);
        IContentType[] iContentTypeArray = contentTypes = Platform.getContentTypeManager().findContentTypesFor(file.getFullPath().lastSegment());
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            if (contentType.isKindOf(contentTypeToMatch)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String contract(ILink link, String prevResult, Set<ProviderArguments> renameArguments) throws ReferenceException {
        return prevResult;
    }

    public String expand(ILink link, String prevResult, Set<ProviderArguments> renameArguments) throws ReferenceException {
        IFile fileContainingLink = (IFile)link.getContainer().getResource();
        if (!this.isJSP(fileContainingLink) && !this.isTemplate(fileContainingLink)) {
            return prevResult;
        }
        String backTransformation = AbstractWebProvider.trimQuotes((String)link.getLinkText());
        if (!backTransformation.startsWith(ENCODE_EL_PREFIX) && !backTransformation.startsWith(ENCODE_PREFIX)) {
            return prevResult;
        }
        Path docRootCompletePath = null;
        String docRootString = null;
        IResource resourceContainingTheLink = link.getContainer().getResource();
        if (resourceContainingTheLink instanceof IFile) {
            String docRootLocation;
            IFile fileContainingTheLink = (IFile)resourceContainingTheLink;
            IProject projectForTheLink = fileContainingTheLink.getParent().getProject();
            docRootString = docRootLocation = ModuleUtil.getDocumentRootLocation((IProject)projectForTheLink);
        }
        URIUtil.ParsedURI uri = URIUtil.parse(docRootString);
        docRootCompletePath = new Path(uri.path);
        if (backTransformation.startsWith(ENCODE_EL_PREFIX)) {
            backTransformation = backTransformation.replace("${pageContext.request.contextPath}/", "");
        } else if (backTransformation.startsWith(ENCODE_PREFIX)) {
            backTransformation = backTransformation.replace("<%= request.getContextPath()%>/", "");
        }
        IPath completePathOfTheLink = docRootCompletePath.append(backTransformation);
        String pathOfTheLink = completePathOfTheLink.makeAbsolute().toString();
        pathOfTheLink = docRootString.concat(backTransformation);
        return "file:///" + pathOfTheLink;
    }

    boolean canExpand(String prevResult) {
        return !prevResult.startsWith(ENCODE_EL_PREFIX) && !prevResult.startsWith(ENCODE_PREFIX);
    }

    protected int getJspVersion(IFile file) {
        IVirtualComponent component;
        String versionName;
        this.projectCacheForJspVersion = file.getProject();
        if (this.jspVersion == 0 && (versionName = ServletLinksTransformer.getJstWebFacetVersion(component = ComponentCore.createComponent((IProject)this.projectCacheForJspVersion))) != null) {
            if ("2.4".equals(versionName)) {
                this.jspVersion = 20;
            } else if ("2.3".equals(versionName)) {
                this.jspVersion = 12;
            } else if ("2.2".equals(versionName)) {
                this.jspVersion = 11;
            }
        }
        return this.jspVersion;
    }

    protected static String getJstWebFacetVersion(IVirtualComponent component) {
        IFacetedProject facetedProject;
        block5: {
            if (component == null) {
                return null;
            }
            facetedProject = ProjectFacetsManager.create((IProject)component.getProject());
            if (facetedProject != null) break block5;
            return null;
        }
        try {
            IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
            if (facetedProject.hasProjectFacet(facet)) {
                IProjectFacetVersion version = facetedProject.getInstalledVersion(facet);
                return version.getVersionString();
            }
        }
        catch (CoreException ce) {
            Logger.logException((Throwable)ce);
        }
        return null;
    }
}

