/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards.wrf;

import com.ibm.etools.model2.base.wizards.IModel2RegionData;
import com.ibm.etools.struts.wizards.wrf.CGMawareMap;
import com.ibm.etools.struts.wizards.wrf.IStrutsRegionData;
import com.ibm.etools.struts.wizards.wrf.WizardUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class CGMtoSuperclassMap
extends CGMawareMap {
    private static final long serialVersionUID = 5241754703009662383L;
    protected static final String EXTENSION_ID = "com.ibm.etools.struts.WebRegionModel_Model2_CGMs_default_superclass";
    protected static final String ELEMENT_NAME = "superclass";
    protected static final String SUPERCLASS_NAME = "type";

    public CGMtoSuperclassMap(IStrutsRegionData isrd) {
        super(isrd);
        this.initialize();
    }

    @Override
    protected void initialize() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = reg.getConfigurationElementsFor(EXTENSION_ID);
        int elen = elems.length;
        if (elen < 1) {
            return;
        }
        this.populateMap(elems);
    }

    protected void populateMap(IConfigurationElement[] elems) {
        int i = 0;
        while (i < elems.length) {
            IConfigurationElement elem = elems[i];
            if (this.isValidElement(elem)) {
                this.configElemToMap(elem);
            }
            ++i;
        }
    }

    protected boolean configElemToMap(IConfigurationElement elem) {
        boolean ret = false;
        String cgmId = this.getCgmId(elem);
        if (this.isValidCgmId(cgmId)) {
            String defSCN = this.getDefSCN(elem);
            if (WizardUtils.isEmpty((String)defSCN)) {
                return false;
            }
            if (WizardUtils.isValidSuperclassName((IModel2RegionData)srd, (String)defSCN)) {
                this.put(cgmId, defSCN);
                return true;
            }
        }
        return ret;
    }

    protected boolean isValidElement(IConfigurationElement elem) {
        if (elem == null) {
            return false;
        }
        String ename = elem.getName();
        if (WizardUtils.isEmpty((String)ename) || !ename.equals(ELEMENT_NAME)) {
            return false;
        }
        String modelAttrib = this.getCgmId(elem);
        if (WizardUtils.isEmpty((String)modelAttrib)) {
            return false;
        }
        String scnAttrib = elem.getAttribute(SUPERCLASS_NAME);
        return !WizardUtils.isEmpty((String)scnAttrib);
    }

    protected String getDefSCN(IConfigurationElement element) {
        return element.getAttribute(SUPERCLASS_NAME);
    }
}

