/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards.wrf;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.base.util.SelectionUtil;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.internal.util.StrutsProjectUtil;
import com.ibm.etools.struts.projnavigator.StrutsProjNavNode;
import com.ibm.etools.struts.projnavigator.StrutsProjNavUtil;
import com.ibm.etools.struts.wizards.wrf.IStrutsRegionData;
import com.ibm.etools.struts.wizards.wrf.WizardUtils;
import com.ibm.etools.webtools.wizards.impl.WebRegionWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public abstract class AbstractStrutsWizard
extends WebRegionWizard {
    protected static final String FQPLUGIN = null;
    private boolean canceled = false;

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getId() {
        return FQPLUGIN;
    }

    public boolean needsPreviousAndNextButtons() {
        return super.needsPreviousAndNextButtons();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        final boolean[] canceledHolder = new boolean[1];
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ReferenceManager.getReferenceManager().waitUntilUptodate(monitor);
                    canceledHolder[0] = monitor == null ? false : monitor.isCanceled();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.canceled = canceledHolder[0];
        if (this.canceled) {
            return;
        }
        if (StrutsProjectUtil.getFirstStrutsProject() != null) {
            Object selected = (selection = SelectionUtil.getStructuredSelection((ISelection)selection)).getFirstElement();
            if (selected instanceof StrutsProjNavNode) {
                IVirtualComponent component = StrutsProjNavUtil.getContainerComponent((StrutsProjNavNode)selected);
                selection = new StructuredSelection((Object)component);
            }
            super.init(workbench, selection);
            IStrutsRegionData srd = this.getStrutsRegionData();
            if (srd != null && srd.getComponent() == null) {
                this.initComponent(srd);
                this.init(srd);
            }
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (this.canceled) {
            IWizardPage[] allThePages = super.getPages();
            int i = 0;
            while (i < allThePages.length) {
                IWizardPage eachPage = allThePages[i];
                ArrayList<Control> list = new ArrayList<Control>();
                list.add(eachPage.getControl());
                while (!list.isEmpty()) {
                    Control c = (Control)list.remove(0);
                    c.setEnabled(false);
                    if (!(c instanceof Composite)) continue;
                    list.addAll(Arrays.asList(((Composite)c).getChildren()));
                }
                ++i;
            }
        }
    }

    public IWizardPage[] getPages() {
        return super.getPages();
    }

    public IWizardPage getStartingPage() {
        return super.getStartingPage();
    }

    protected IStructuredSelection getStructuredSelection(IWorkbench w) {
        assert (w != null);
        StructuredSelection ret = StructuredSelection.EMPTY;
        ISelection selection = w.getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            ret = (IStructuredSelection)selection;
        } else {
            IEditorInput input;
            IWorkbenchPart part = w.getActiveWorkbenchWindow().getPartService().getActivePart();
            if (part instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput) {
                ret = new StructuredSelection((Object)((IFileEditorInput)input).getFile());
            }
        }
        return ret;
    }

    protected void init(IAdaptable adaptable) {
        IStrutsRegionData srd = this.getStrutsRegionData();
        IJavaElement jelem = null;
        IVirtualComponent c = this.initComponent(adaptable, srd);
        if (c != null) {
            srd.setComponent(c);
            this.initContainerFromStrutsComponent(c, srd);
            adaptable = c.getProject();
            if (adaptable != null) {
                jelem = (IJavaElement)adaptable.getAdapter(IJavaElement.class);
            }
        }
        if (jelem != null) {
            this.initJavaPackageFromJavaElement(jelem);
        }
        if (c == null && jelem == null && adaptable instanceof IResource) {
            this.initResource((IResource)adaptable);
        }
        this.init(srd);
    }

    protected abstract void init(IStrutsRegionData var1);

    protected void initClassData(IStrutsRegionData srd, String defaultClassName, String defaultSuperclassName) {
        assert (srd != null);
        assert (defaultClassName != null && defaultClassName.length() > 0);
        assert (defaultSuperclassName != null && defaultSuperclassName.length() > 0);
        WizardUtils.initPrefix(srd, defaultClassName);
        WizardUtils.initSuperclass(srd, defaultSuperclassName);
    }

    protected abstract void initClassData(IStrutsRegionData var1, String var2);

    protected IVirtualComponent initComponent(IStrutsRegionData srd) {
        IProject project = StrutsProjectUtil.getFirstStrutsProject();
        if (project != null) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            srd.setComponent(component);
            return component;
        }
        return null;
    }

    protected IVirtualComponent initComponent(IAdaptable adaptable, IStrutsRegionData regionData) {
        IVirtualComponent component = null;
        if (adaptable instanceof IVirtualComponent) {
            component = (IVirtualComponent)adaptable;
        } else if (adaptable instanceof IResource) {
            component = Model2Util.findComponent((IResource)((IResource)adaptable).getProject());
        }
        if (component != null && StrutsProjectUtil.isStruts((IProject)component.getProject())) {
            return component;
        }
        return this.initComponent(regionData);
    }

    protected void initContainerFromStrutsComponent(IVirtualComponent c, IStrutsRegionData srd) {
        srd.setDestinationFolder((IContainer)Model2Util.getSourceFolder((IVirtualComponent)c));
    }

    protected void initContainerFromJavaElement(IJavaElement elem, IStrutsRegionData srd) {
        if (elem != null) {
            IJavaProject jproject = elem.getJavaProject();
            assert (jproject != null);
            try {
                IResource resource = elem.getCorrespondingResource();
                IVirtualComponent c = ComponentUtilities.findComponent((IResource)resource);
                if (StrutsProjectUtil.isStruts((IProject)c.getProject())) {
                    this.initContainerFromStrutsComponent(c, srd);
                    return;
                }
                srd.setDestinationFolder((IContainer)Model2Util.getSourceFolder((IVirtualComponent)c));
            }
            catch (JavaModelException jme) {
                StrutsPlugin.getLogger().log((Throwable)jme);
                return;
            }
        }
    }

    public boolean performFinish() {
        return super.performFinish();
    }

    protected abstract boolean validateEdit();

    public IStrutsRegionData getStrutsRegionData() {
        return (IStrutsRegionData)this.getRegionData();
    }

    public boolean canFinish() {
        if (this.canceled) {
            return false;
        }
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            IWizardPage page = pages[i];
            if (!page.isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canFollowingPagesFinish() {
        if (this.canceled) {
            return false;
        }
        return super.canFollowingPagesFinish();
    }

    public void dispose() {
        IStrutsRegionData srd = this.getStrutsRegionData();
        if (srd != null) {
            srd.dispose();
        }
        super.dispose();
    }
}

