/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards.module;

import com.ibm.etools.model2.base.util.EnablementGroup;
import com.ibm.etools.model2.base.util.EnablementGroupListener;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.base.util.WidgetUtils;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.facet.ui.ResourceBundleCreationGroup;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.wizards.OverrideDefaultSettingsGroup;
import com.ibm.etools.struts.wizards.StrutsProjectSelectionDialog;
import com.ibm.etools.struts.wizards.module.AbstractModuleConfiguration;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public abstract class AbstractStrutsModuleWizardPage
extends WizardPage {
    protected Text projectNameText;
    protected Text moduleNameText;
    protected Label moduleNameDefaultLabel;
    protected OverrideDefaultSettingsGroup settingsGroup;
    protected Button createModuleFolderButton;
    protected Label moduleFolderNameLabel;
    protected Text strutsConfigFileNameText;
    protected ResourceBundleCreationGroup resourceBundleGroup;
    protected Text resourceBundlePackageText;
    protected Text resourceBundleNameText;
    protected Label resourceBundlePackageDefaultLabel;
    protected Button resourceBundlePackageBrowseButton;

    public AbstractStrutsModuleWizardPage(String pageName) {
        super(pageName);
        this.setTitle(ResourceHandler.strutsModuleWizard_pageTitle);
        this.setDescription(ResourceHandler.strutsModuleWizard_description);
    }

    protected abstract AbstractModuleConfiguration getConfiguration();

    protected abstract String getHelpContextId();

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getHelpContextId());
        this.createMainControls(composite);
        this.createSettingsGroup(composite);
        this.setControl((Control)composite);
        this.validatePage();
    }

    protected void createMainControls(Composite parent) {
        this.createProjectNameComposite(parent);
        this.createModuleNameControl(parent);
    }

    protected void createProjectNameComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 16384);
        label.setText(ResourceHandler.strutsModuleWizard_label_projectName);
        this.projectNameText = new Text(composite, 2056);
        this.projectNameText.setLayoutData((Object)new GridData(768));
        if (this.getConfiguration().getComponent() != null && this.getConfiguration().getComponent().getProject() != null) {
            this.projectNameText.setText(this.getConfiguration().getComponent().getProject().getName());
        }
        Button button = WidgetUtils.createPushButton((Composite)composite, (String)ResourceHandler.Browse__UI_);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractStrutsModuleWizardPage.this.handleProjectBrowseButtonSelected();
            }
        });
    }

    protected void createModuleNameControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 16384);
        label.setText(ResourceHandler.strutsModuleWizard_label_moduleName);
        this.moduleNameText = new Text(composite, 2048);
        this.moduleNameText.setLayoutData((Object)new GridData(768));
        this.moduleNameText.setText(this.getConfiguration().getModuleName());
        this.moduleNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AbstractStrutsModuleWizardPage.this.handleModuleNameTextModified();
            }
        });
        this.moduleNameDefaultLabel = new Label(composite, 131072);
        this.moduleNameDefaultLabel.setText(ResourceHandler.strutsModuleWizard_label_default);
        this.moduleNameDefaultLabel.setVisible(this.getConfiguration().getModuleName().length() == 0);
    }

    protected void createSettingsGroup(Composite parent) {
        this.settingsGroup = new OverrideDefaultSettingsGroup(parent, 0);
        this.settingsGroup.addEnablementListener(new EnablementGroupListener(){

            public void handleEnablement(EnablementGroup group) {
                AbstractStrutsModuleWizardPage.this.handleSettingsGroupEnablement();
            }
        });
        this.createSettingsGroupContents((Composite)this.settingsGroup.getGroup());
        this.settingsGroup.setSelection(false);
        this.settingsGroup.setEnabled(this.getConfiguration().getComponent() != null);
    }

    protected void createSettingsGroupContents(Composite parent) {
        this.createModuleFolderComposite(parent);
        this.createStrutsConfigFileGroup(parent);
        this.createResourceBundleGroup(parent);
    }

    protected void createModuleFolderComposite(Composite parent) {
        Composite composite = WidgetUtils.createComposite((Composite)parent, (int)2);
        this.createModuleFolderButton = WidgetUtils.createCheckBox((Composite)composite, (String)ResourceHandler.strutsModuleWizard_label_createModuleDirectory);
        this.createModuleFolderButton.setSelection(this.getConfiguration().isCreateModuleDirectory());
        this.createModuleFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractStrutsModuleWizardPage.this.handleCreateModuleFolderButtonSelected();
            }
        });
        this.moduleFolderNameLabel = WidgetUtils.createLabel((Composite)composite, (String)this.getModuleFolderName(), (int)16384, (int)768);
    }

    protected void createStrutsConfigFileGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setText(ResourceHandler.strutsModuleWizard_label_strutsConfigFileGroup);
        this.createStrutsConfigFileNameComposite((Composite)group);
    }

    protected void createStrutsConfigFileNameComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 16384);
        label.setText(ResourceHandler.strutsModuleWizard_label_name);
        this.strutsConfigFileNameText = new Text(composite, 2048);
        this.strutsConfigFileNameText.setLayoutData((Object)new GridData(768));
        this.strutsConfigFileNameText.setText(this.getConfiguration().getStrutsConfigFileName());
        this.strutsConfigFileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AbstractStrutsModuleWizardPage.this.handleStrutsConfigFileNameTextModified();
            }
        });
    }

    protected void createResourceBundleGroup(Composite parent) {
        this.resourceBundleGroup = new ResourceBundleCreationGroup(parent, 0);
        this.resourceBundleGroup.setSelection(this.getConfiguration().isCreateResourceBundle());
        this.resourceBundleGroup.addEnablementListener(new EnablementGroupListener(){

            public void handleEnablement(EnablementGroup group) {
                AbstractStrutsModuleWizardPage.this.handleResourceBundleGroupEnablement();
            }
        });
        Group group = this.resourceBundleGroup.getGroup();
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        this.createResourceBundlePackageComposite((Composite)group);
        this.createResourceBundleNameComposite((Composite)group);
    }

    protected void createResourceBundlePackageComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(768));
        Label packageLabel = new Label(composite, 16384);
        packageLabel.setText(ResourceHandler.strutsModuleWizard_label_package);
        this.resourceBundlePackageText = new Text(composite, 2048);
        this.resourceBundlePackageText.setLayoutData((Object)new GridData(768));
        this.resourceBundlePackageText.setText(this.getConfiguration().getResourceBundlePackage());
        this.resourceBundlePackageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AbstractStrutsModuleWizardPage.this.handleResourceBundlePackageTextModified();
            }
        });
        this.resourceBundlePackageDefaultLabel = new Label(composite, 16384);
        this.resourceBundlePackageDefaultLabel.setText(ResourceHandler.strutsModuleWizard_label_default);
        this.resourceBundlePackageBrowseButton = WidgetUtils.createPushButton((Composite)composite, (String)ResourceHandler.Browse__UI_);
        this.resourceBundlePackageBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractStrutsModuleWizardPage.this.handleResourceBundlePackageBrowseButtonSelected();
            }
        });
    }

    protected void createResourceBundleNameComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(ResourceHandler.strutsModuleWizard_label_name);
        this.resourceBundleNameText = new Text(composite, 2048);
        this.resourceBundleNameText.setLayoutData((Object)new GridData(768));
        this.resourceBundleNameText.setText(this.getConfiguration().getResourceBundleName());
        this.resourceBundleNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AbstractStrutsModuleWizardPage.this.handleResourceBundleNameTextModified();
            }
        });
    }

    protected void handleProjectBrowseButtonSelected() {
        StrutsProjectSelectionDialog dialog = new StrutsProjectSelectionDialog(this.getShell(), 1);
        if (dialog.open() == 0) {
            boolean wasDefaultResourceBundlePackage = this.getConfiguration().isDefaultResourceBundlePackage();
            this.getConfiguration().setComponent(Model2Util.findComponent((IResource)dialog.getProject()));
            this.projectNameText.setText(this.getConfiguration().getComponentName());
            if (!this.settingsGroup.isEnabled()) {
                this.settingsGroup.setEnabled(true);
            }
            this.updateModuleFolderName();
            this.updateResourceBundlePackage(wasDefaultResourceBundlePackage);
            this.validatePage();
        }
    }

    protected void handleModuleNameTextModified() {
        String moduleName = this.moduleNameText.getText();
        boolean wasDefaultStrutsConfigFileName = this.getConfiguration().isDefaultStrutsConfigFileName();
        boolean wasDefaultResourceBundlePackage = this.getConfiguration().isDefaultResourceBundlePackage();
        this.getConfiguration().setModuleName(moduleName);
        if (wasDefaultStrutsConfigFileName) {
            this.getConfiguration().setStrutsConfigFileName(null);
            this.strutsConfigFileNameText.setText(this.getConfiguration().getStrutsConfigFileName());
        }
        this.updateResourceBundlePackage(wasDefaultResourceBundlePackage);
        this.moduleNameDefaultLabel.setVisible(moduleName.length() == 0);
        this.updateModuleFolderName();
        this.validatePage();
    }

    private String getModuleFolderName() {
        IFolder moduleFolder = this.getConfiguration().getModuleFolder();
        return moduleFolder == null ? "" : moduleFolder.getFullPath().toString();
    }

    protected void updateModuleFolderName() {
        this.moduleFolderNameLabel.setText(this.getModuleFolderName());
    }

    protected void updateResourceBundlePackage(boolean wasDefault) {
        if (wasDefault) {
            this.getConfiguration().setResourceBundlePackage(null);
            this.resourceBundlePackageText.setText(this.getConfiguration().getResourceBundlePackage());
        }
    }

    protected void handleCreateModuleFolderButtonSelected() {
        boolean isChecked = this.createModuleFolderButton.getSelection();
        this.getConfiguration().setCreateModuleDirectory(isChecked);
        this.validatePage();
    }

    protected void handleStrutsConfigFileNameTextModified() {
        String name = this.strutsConfigFileNameText.getText();
        this.getConfiguration().setStrutsConfigFileName(name);
        this.validatePage();
    }

    protected void handleResourceBundleGroupEnablement() {
        boolean createResourceBundle = this.resourceBundleGroup.getSelection();
        this.getConfiguration().setCreateResourceBundle(createResourceBundle);
        this.validatePage();
    }

    protected void handleResourceBundlePackageTextModified() {
        String packageName = this.resourceBundlePackageText.getText();
        this.getConfiguration().setResourceBundlePackage(packageName);
        this.resourceBundlePackageDefaultLabel.setVisible(packageName.length() == 0);
        this.validatePage();
    }

    protected void handleResourceBundleNameTextModified() {
        String resourceBundleName = this.resourceBundleNameText.getText();
        this.getConfiguration().setResourceBundleName(resourceBundleName);
        this.validatePage();
    }

    protected void handleResourceBundlePackageBrowseButtonSelected() {
        String packageName = this.promptResourceBundlePackageName();
        if (packageName == null) {
            return;
        }
        this.resourceBundlePackageText.setText(packageName);
        this.getConfiguration().setResourceBundlePackage(packageName);
        this.validatePage();
    }

    private String promptResourceBundlePackageName() {
        IPackageFragmentRoot packageFragmentRoot = this.getPackageFragmentRoot();
        Object[] packages = null;
        try {
            if (packageFragmentRoot != null) {
                packages = packageFragmentRoot.getChildren();
            }
        }
        catch (JavaModelException javaModelException) {}
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setTitle(ResourceHandler.facet_install_dialog_package_title);
        dialog.setMessage(ResourceHandler.facet_install_dialog_package_message);
        dialog.setEmptyListMessage(ResourceHandler.facet_install_dialog_package_emptyListMessage);
        dialog.setElements(packages);
        if (dialog.open() == 0) {
            IPackageFragment packageFragment = (IPackageFragment)dialog.getFirstResult();
            return packageFragment == null ? "" : packageFragment.getElementName();
        }
        return null;
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        IFolder sourcefolder;
        IJavaProject javaProject;
        IPackageFragmentRoot packageFragmentRoot = null;
        IVirtualComponent component = this.getConfiguration().getComponent();
        if (component != null && (javaProject = JavaCore.create((IProject)component.getProject())) != null && (sourcefolder = Model2Util.getSourceFolder((IVirtualComponent)component)) != null) {
            packageFragmentRoot = javaProject.getPackageFragmentRoot((IResource)sourcefolder);
        }
        return packageFragmentRoot;
    }

    protected void handleSettingsGroupEnablement() {
    }

    protected void validatePage() {
        if (this.validateParts()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    protected boolean validateParts() {
        if (!this.validateComponent()) {
            return false;
        }
        if (!this.validateModuleName()) {
            return false;
        }
        if (!this.validateStrutsConfigFile()) {
            return false;
        }
        return this.validateResourceBundle();
    }

    private boolean validateComponent() {
        if (this.getConfiguration().getComponent() == null) {
            this.setErrorMessage(ResourceHandler.wizard_common_error_noStrutsProjectSelected);
            return false;
        }
        return true;
    }

    private boolean validateModuleName() {
        Set moduleNames;
        String moduleName = this.getConfiguration().getModuleName();
        if (moduleName.length() == 0) {
            this.setErrorMessage(ResourceHandler.strutsModuleWizard_error_noModuleName);
            return false;
        }
        String[] segments = new Path(moduleName).segments();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        int i = 0;
        while (i < segments.length) {
            IStatus status = workspace.validateName(segments[i], 2);
            if (status.getSeverity() != 0) {
                this.setErrorMessage(NLS.bind((String)ResourceHandler.strutsModuleWizard_error_badModuleName, (Object)status.getMessage()));
                return false;
            }
            ++i;
        }
        try {
            moduleNames = StrutsSearchUtil.getModulesForProject((IProject)this.getConfiguration().getComponent().getProject(), null);
        }
        catch (ReferenceException e) {
            e.printStackTrace();
            moduleNames = Collections.emptySet();
        }
        for (String name : moduleNames) {
            if (!name.equals(moduleName)) continue;
            this.setErrorMessage(ResourceHandler.strutsModuleWizard_error_existingModuleName);
            return false;
        }
        return true;
    }

    private boolean validateStrutsConfigFile() {
        String name = this.getConfiguration().getStrutsConfigFileName();
        if (name == null || name.length() == 0) {
            this.setErrorMessage(ResourceHandler.strutsModuleWizard_error_noSCFName);
            return false;
        }
        String[] segments = new Path(name).segments();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        int type = 2;
        int i = 0;
        while (i < segments.length) {
            IStatus status;
            if (i == segments.length - 1) {
                type = 1;
            }
            if ((status = workspace.validateName(segments[i], type)).getSeverity() != 0) {
                this.setErrorMessage(NLS.bind((String)ResourceHandler.strutsModuleWizard_error_badSCFName, (Object)status.getMessage()));
                return false;
            }
            ++i;
        }
        IFile file = this.getConfiguration().getStrutsConfigFile();
        if (file.exists()) {
            this.setErrorMessage(ResourceHandler.strutsModuleWizard_error_existingSCFName);
            return false;
        }
        IContainer folder = file.getParent();
        if (!folder.exists()) {
            this.setErrorMessage(ResourceHandler.strutsModuleWizard_error_nonexistentSCFFolder);
            return false;
        }
        return true;
    }

    private boolean validateResourceBundle() {
        if (!this.getConfiguration().isCreateResourceBundle()) {
            return true;
        }
        String packageName = this.getConfiguration().getResourceBundlePackage();
        IStatus status = Model2Util.validatePackageName((String)packageName);
        if (status.getSeverity() != 0) {
            this.setErrorMessage(NLS.bind((String)ResourceHandler.strutsModuleWizard_error_badBundlePackage, (Object)status.getMessage()));
            return false;
        }
        String bundleName = this.getConfiguration().getResourceBundleName();
        if (bundleName.length() == 0) {
            this.setErrorMessage(ResourceHandler.strutsModuleWizard_error_noBundleName);
            return false;
        }
        if (bundleName.indexOf(46) != -1) {
            this.setErrorMessage(ResourceHandler.strutsModuleWizard_error_qualifiedBundleName);
            return false;
        }
        status = JavaConventions.validateJavaTypeName((String)bundleName);
        if (status.getSeverity() != 0) {
            this.setErrorMessage(NLS.bind((String)ResourceHandler.strutsModuleWizard_error_badBundleName, (Object)status.getMessage()));
            return false;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.getConfiguration().isDefaultModuleName()) {
            this.moduleNameText.selectAll();
            this.moduleNameText.setFocus();
        }
    }
}

