/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards.forms;

import com.ibm.etools.model2.base.util.TableResizeAdapter;
import com.ibm.etools.model2.base.util.WidgetUtils;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.utilities.JDTUtils;
import com.ibm.etools.struts.wizards.forms.Accessor;
import com.ibm.etools.struts.wizards.forms.IActionFormRegionData;
import com.ibm.etools.struts.wizards.forms.MapBackedAccessor;
import com.ibm.etools.struts.wizards.wrf.NonVisualWebRegionWizardPage;
import com.ibm.etools.struts.wizards.wrf.UIComponents;
import com.ibm.etools.struts.wizards.wrf.WizardUtils;
import com.ibm.etools.webtools.flatui.MultiColumnResizer;
import com.ibm.etools.webtools.flatui.SnappyTableViewer;
import com.ibm.etools.webtools.wizards.IRegionAwareWizardPage;
import com.ibm.etools.webtools.wizards.regiondata.DataModelChangedEvent;
import com.ibm.etools.webtools.wizards.regiondata.IDataModelChangedListener;
import com.ibm.etools.webtools.wizards.regiondata.IWTRegionData;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class NewAccessorsPage
extends NonVisualWebRegionWizardPage
implements IDataModelChangedListener,
IRegionAwareWizardPage {
    protected static final boolean IS_RDP = false;
    protected static final String NEW_ACCESSORS_CONTROL_LABEL = ResourceHandler.wizard_form_generic_ui_newaccessors_label;
    protected static final String NEW_ACCESSORS_TABLE_NAME_HEADER = ResourceHandler.wizard_common_name_propercase;
    protected static final String NEW_ACCESSORS_TABLE_TYPE_HEADER = ResourceHandler.wizard_common_type_propercase;
    protected static final String FB_CONTROL_LABEL = ResourceHandler.wizard_common_fbname_label;
    protected static final String ADD = ResourceHandler.Button_Add__UI_;
    protected static final String REMOVE = ResourceHandler.Button_Remove__UI_;
    public static final int NAME_COLUMN = 0;
    public static final int TYPE_COLUMN = 1;
    public static final int N_COLUMNS = 2;
    public static final String DEFAULT_ACCESSOR_NAME = "";
    public static final String DEFAULT_ACCESSOR_TYPE = "String";
    public static final String NAME_PROPERTY = ResourceHandler.wizard_common_name_lowercase;
    public static final String TYPE_PROPERTY = ResourceHandler.wizard_common_type_lowercase;
    public static final int EDITOR_WIDTH = 50;
    protected static final int COLUMN_WEIGHT = 200;
    protected static final int HEIGHT_HINT = 300;
    protected Label newAccessorsLabel = null;
    protected SnappyTableViewer tableViewer = null;
    protected Button addNewAccessorButton = null;
    protected Button removeNewAccessorButton = null;
    protected IStructuredContentProvider newAccessorsContentProvider = null;
    protected ITableLabelProvider newAccessorsLabelProvider = null;

    public boolean canFlipToNextPage() {
        if (this.getActionFormRegionData().isSkipBeanMappingAndConfigurationPages()) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    public NewAccessorsPage(IWTRegionData rd) {
        super(rd);
    }

    public NewAccessorsPage(IWTRegionData rd, String pn) {
        super(rd, pn);
    }

    public NewAccessorsPage(IWTRegionData rd, String pn, String title, ImageDescriptor titleImage) {
        super(rd, pn, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite c0 = UIComponents.createComposite((Composite)parent, (int)1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)c0, "com.ibm.etools.struts.sgaf0000");
        IActionFormRegionData afrd = this.getActionFormRegionData();
        this.createNewAccessorsControl(c0);
        this.initContent(afrd);
        this.setControl((Control)c0);
    }

    protected void createNewAccessorsControl(Composite c0) {
        this.newAccessorsLabel = new Label(c0, 0);
        this.newAccessorsLabel.setText(NEW_ACCESSORS_CONTROL_LABEL);
        GridData gd = new GridData(1, 1, false, false);
        this.newAccessorsLabel.setLayoutData((Object)gd);
        Composite c1 = WidgetUtils.createComposite((Composite)c0, (int)2, (int)1808);
        Composite tableComposite = WidgetUtils.createComposite((Composite)c1, (int)1, (int)1808);
        this.tableViewer = new SnappyTableViewer(tableComposite, 67586);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setText(NEW_ACCESSORS_TABLE_NAME_HEADER);
        column = new TableColumn(table, 4);
        column.setText(NEW_ACCESSORS_TABLE_TYPE_HEADER);
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)this.tableViewer.getTable()), new TextCellEditor((Composite)this.tableViewer.getTable())};
        new TableResizeAdapter(table, true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, true));
        table.setLayout((Layout)layout);
        gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        new MultiColumnResizer(table);
        this.tableViewer.setContentProvider((IContentProvider)new AccessorsContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AccessorsLabelProvider());
        this.tableViewer.setCellEditors(cellEditors);
        this.tableViewer.setCellModifier((ICellModifier)new AccessorsCellModifier());
        this.tableViewer.setColumnProperties(new String[]{NAME_PROPERTY, TYPE_PROPERTY});
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite buttonComposite = WidgetUtils.createComposite((Composite)c1, (int)1, (int)2);
        this.addNewAccessorButton = new Button(buttonComposite, 8);
        this.removeNewAccessorButton = new Button(buttonComposite, 8);
        UIComponents.createAddRemoveButtonSet(this.addNewAccessorButton, true, this, ResourceHandler.wizard_form_ui_accessors_add_tip, this.removeNewAccessorButton, false, this, ResourceHandler.wizard_form_ui_accessors_remove_tip);
    }

    protected void initContent(IActionFormRegionData afrd) {
        this.initAccessorsContents(afrd);
        this.updateView(afrd);
    }

    protected void initAccessorsContents(IActionFormRegionData afrd) {
        this.tableViewer.setInput((Object)afrd);
        this.tableViewer.refresh();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.tableViewer.refresh();
        }
        super.setVisible(visible);
    }

    public void updateButtonStates(IWTRegionData rd) {
        this.removeNewAccessorButton.setEnabled(WizardUtils.hasSelection((Viewer)this.tableViewer));
    }

    public void updateView(IActionFormRegionData afrd) {
        this.updateButtonStates((IWTRegionData)afrd);
        this.setPageComplete(this.validatePage((IWTRegionData)afrd));
    }

    public boolean validatePage(IWTRegionData rd) {
        Table table = this.tableViewer.getTable();
        TableItem[] items = table.getItems();
        int i = 0;
        while (i < items.length) {
            Accessor accessor = (Accessor)((Object)items[i].getData());
            String name = accessor.getName();
            IStatus status = JavaConventions.validateFieldName((String)name);
            if (status.getSeverity() != 0) {
                this.setMessage(status.getMessage(), 3);
                return false;
            }
            String type = accessor.getType();
            if (type == null || type.equals(DEFAULT_ACCESSOR_NAME)) {
                this.setMessage(NLS.bind((String)ResourceHandler.wizard_common_error_empty, (Object)ResourceHandler.wizard_common_type_propercase), 3);
                return false;
            }
            status = JDTUtils.validateTypeName(type, rd.getWebComponent(), true, false);
            if (status.getSeverity() != 0) {
                this.setMessage(status.getMessage(), 3);
                return false;
            }
            ++i;
        }
        this.setMessage(null);
        return true;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.tableViewer) {
            this.updateButtonStates((IWTRegionData)this.getActionFormRegionData());
        }
    }

    public void handleEvent(Event event) {
        IActionFormRegionData afrd = this.getActionFormRegionData();
        Widget source = event.widget;
        if (source == this.addNewAccessorButton) {
            this.handleAddAccessorButton(afrd);
        } else if (source == this.removeNewAccessorButton) {
            this.handleRemoveAccessorButton(afrd);
        }
        this.updateView(afrd);
    }

    public void dataModelChanged(DataModelChangedEvent changedEvent) {
    }

    public void handleRegionDataChanged(IWTRegionData data) {
        assert (false);
    }

    public void handleRegionDataChanged(IWTRegionData data, Collection changed) {
    }

    protected void handleRemoveAccessorButton(IActionFormRegionData afrd) {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Object object = selection.getFirstElement();
        if (object instanceof Accessor) {
            Accessor accessor = (Accessor)((Object)object);
            afrd.removeAccessor(accessor);
            this.tableViewer.remove((Object)accessor);
        }
    }

    protected void handleAddAccessorButton(IActionFormRegionData afrd) {
        Accessor accessor = new Accessor(DEFAULT_ACCESSOR_NAME, DEFAULT_ACCESSOR_TYPE);
        afrd.addAccessor(accessor);
        this.tableViewer.refresh();
        this.tableViewer.editElement((Object)accessor, 0);
    }

    public IActionFormRegionData getActionFormRegionData() {
        return (IActionFormRegionData)this.getRegionData();
    }

    private class AccessorsCellModifier
    implements ICellModifier {
        private AccessorsCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            if (NAME_PROPERTY.equals(property)) {
                return ((Accessor)((Object)element)).getName();
            }
            if (TYPE_PROPERTY.equals(property)) {
                return ((Accessor)((Object)element)).getType();
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            MapBackedAccessor mba = (MapBackedAccessor)((Object)tableItem.getData());
            if (NAME_PROPERTY.equals(property)) {
                mba.setName((String)value);
            } else if (TYPE_PROPERTY.equals(property)) {
                mba.setType((String)value);
            }
            NewAccessorsPage.this.tableViewer.update((Object)mba, new String[]{property});
            NewAccessorsPage.this.setPageComplete(NewAccessorsPage.this.validatePage((IWTRegionData)NewAccessorsPage.this.getActionFormRegionData()));
        }
    }

    private class AccessorsContentProvider
    implements IStructuredContentProvider {
        private AccessorsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IActionFormRegionData) {
                Collection accessors = ((IActionFormRegionData)inputElement).getAccessors();
                ArrayList list = new ArrayList(accessors);
                return list.toArray(new Accessor[list.size()]);
            }
            return new Accessor[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class AccessorsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private AccessorsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Accessor) {
                Accessor accessor = (Accessor)((Object)element);
                switch (columnIndex) {
                    case 0: {
                        return accessor.getName();
                    }
                    case 1: {
                        return accessor.getType();
                    }
                }
            }
            return NewAccessorsPage.DEFAULT_ACCESSOR_NAME;
        }
    }
}

