/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards.forms;

import com.ibm.etools.struts.wizards.forms.FieldValue;
import com.ibm.etools.struts.wizards.forms.InnerValue;
import com.ibm.etools.struts.wizards.forms.MapBackedAccessor;
import com.ibm.etools.struts.wizards.wrf.WizardUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;

public class FieldMap
extends LinkedHashMap {
    private static final long serialVersionUID = 1784722342288616339L;
    protected String name = null;
    protected static final String DEFAULT_NAME = "/";
    protected static final String CLASS_SUFFIX = "Class";

    public FieldMap() {
        this.name = DEFAULT_NAME;
    }

    public FieldMap(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public boolean isRoot() {
        return this.name.equals(DEFAULT_NAME);
    }

    public void putField(String fieldname, String typename) {
        this.put(fieldname, new FieldValue(typename));
    }

    public String getFieldType(String fieldname) {
        Object o = this.get(fieldname);
        if (o == null ? !$assertionsDisabled : (o instanceof InnerValue ? !$assertionsDisabled : !(o instanceof FieldValue) && !$assertionsDisabled)) {
            throw new AssertionError();
        }
        if (o == null) {
            return "";
        }
        return ((FieldValue)o).getTypename();
    }

    public void removeField(String fieldname) {
        this.remove(fieldname);
    }

    public void putInner(String fieldname) {
        this.put(fieldname, new InnerValue(fieldname));
    }

    public static String makeName(String fieldname) {
        assert (fieldname != null && fieldname.length() > 0);
        return new StringBuffer(WizardUtils.ucfc((String)fieldname)).append(CLASS_SUFFIX).toString();
    }

    public String getInnerType(String innername) {
        Object o = this.get(innername);
        if (o == null ? !$assertionsDisabled : (o instanceof FieldValue ? !$assertionsDisabled : !(o instanceof InnerValue) && !$assertionsDisabled)) {
            throw new AssertionError();
        }
        if (o != null) {
            FieldMap f = ((InnerValue)o).getFieldMap();
            assert (f != null);
            String typename = f.getName();
            assert (typename != null && typename.length() > 0);
            return typename;
        }
        return "";
    }

    public FieldMap getAllFields() {
        FieldMap fields = new FieldMap("");
        if (this.size() < 1) {
            return fields;
        }
        ArrayList keys = new ArrayList(this.keySet());
        for (String key : keys) {
            Object val = this.get(key);
            if (val == null) {
                assert (false);
                continue;
            }
            if (val instanceof FieldValue) {
                fields.put(key, val);
                continue;
            }
            if (!(val instanceof InnerValue)) assert (false);
        }
        return fields;
    }

    public FieldMap getAllInners() {
        FieldMap inners = new FieldMap("");
        if (this.size() < 1) {
            return inners;
        }
        ArrayList keys = new ArrayList(this.keySet());
        for (String key : keys) {
            Object val = this.get(key);
            if (val == null) {
                assert (false);
                continue;
            }
            if (val instanceof InnerValue) {
                inners.put(key, val);
                continue;
            }
            if (!(val instanceof FieldValue)) assert (false);
        }
        return inners;
    }

    public Collection getAccessors() {
        if (this.size() < 1) {
            return Collections.EMPTY_LIST;
        }
        ArrayList keys = new ArrayList(this.keySet());
        LinkedHashSet accessors = new LinkedHashSet(this.size());
        for (String key : keys) {
            Object val = this.get(key);
            if (val == null) {
                assert (false);
                continue;
            }
            if (val instanceof InnerValue) {
                InnerValue iv = (InnerValue)val;
                accessors = (LinkedHashSet)iv.addAccessors(accessors);
                accessors.add(new MapBackedAccessor(key, iv.getTypename(), this));
                continue;
            }
            if (val instanceof FieldValue) {
                accessors.add(new MapBackedAccessor(key, ((FieldValue)val).getTypename(), this));
                continue;
            }
            assert (false);
        }
        return accessors;
    }

    public void addNested(List fields, String type, int size) {
        FieldMap context = this;
        int lastIndex = size - 1;
        int i = 0;
        while (i < size) {
            String field = (String)fields.get(i);
            if (WizardUtils.isEmpty((String)field)) {
                assert (false);
            } else {
                if (context.containsKey(field)) {
                    Object val;
                    if (i < lastIndex) {
                        val = context.get(field);
                        if (val == null) {
                            assert (false);
                        } else if (val instanceof FieldValue) {
                            context.putInner(field);
                        } else if (!(val instanceof InnerValue)) assert (false);
                    } else {
                        val = context.get(field);
                        if (val == null) {
                            context.putField(field, type);
                        } else if (!(val instanceof FieldValue) && !(val instanceof InnerValue)) assert (false);
                    }
                } else if (i < lastIndex) {
                    context.putInner(field);
                } else {
                    context.putField(field, type);
                }
                if (i < lastIndex) {
                    InnerValue iv = (InnerValue)context.get(field);
                    context = iv.getFieldMap();
                }
            }
            ++i;
        }
    }

    public void removeNested(List fields, int size) {
        FieldMap context = this;
        int lastIndex = size - 1;
        Object[] found = new Object[size];
        int i = 0;
        while (i < size) {
            String field = (String)fields.get(i);
            if (WizardUtils.isEmpty((String)field)) {
                assert (false);
            } else if (context.containsKey(field)) {
                Object val;
                if (i < lastIndex) {
                    val = context.get(field);
                    if (val == null) {
                        assert (false);
                    } else if (val instanceof FieldValue) {
                        assert (false);
                    } else if (val instanceof InnerValue) {
                        found[i] = val;
                    } else assert (false);
                } else {
                    val = context.get(field);
                    if (val == null) {
                        assert (false);
                    } else {
                        if (val instanceof FieldValue) {
                            context.remove(field);
                            return;
                        }
                        if (val instanceof InnerValue) {
                            return;
                        }
                        assert (false);
                    }
                }
            }
            ++i;
        }
    }
}

