/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards.forms;

import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.emf.strutsconfig.FormBean;
import com.ibm.etools.struts.wizards.forms.Accessor;
import com.ibm.etools.struts.wizards.forms.FieldMap;
import com.ibm.etools.struts.wizards.forms.IActionFormRegionData;
import com.ibm.etools.struts.wizards.forms.InnerValue;
import com.ibm.etools.struts.wizards.wrf.WizardUtils;
import com.ibm.etools.webtools.wizards.basic.JMethod;
import com.ibm.etools.webtools.wizards.basic.MethodStubDataUtil;
import com.ibm.etools.webtools.wizards.basic.TypeWizardUtil;
import java.util.ArrayList;

public class ActionFormUtil
extends WizardUtils {
    public static final String RESET = "reset";
    public static final String RESET_HTTP = "resetHttp";
    public static final String VALIDATE = "validate";
    public static final String VALIDATE_HTTP = "validateHttp";

    public ActionFormUtil(IActionFormRegionData afrd, TypeWizardUtil wu) {
        super(afrd, wu);
    }

    public IActionFormRegionData getActionFormRegionData() {
        return (IActionFormRegionData)this.getRegionData();
    }

    public static FormBean createBlankMapping() {
        return ActionFormUtil.createMapping(NO_NAME, NO_TYPE);
    }

    public static FormBean createMapping() {
        return ActionFormUtil.createFormBeanMapping();
    }

    public static FormBean createMapping(String name) {
        return ActionFormUtil.createFormBeanMapping(name);
    }

    public static FormBean createMapping(String name, String type) {
        return ActionFormUtil.createFormBeanMapping(name, type);
    }

    public void setMethodBody(JMethod jm) {
        String nl = System.getProperties().getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String mn = jm.getMethodName();
        if (mn.equals(RESET)) {
            sb = this.setResetBody(jm, nl, sb);
        } else if (mn.equals(RESET)) {
            sb = this.setResetBody(jm, nl, sb);
        } else if (mn.equals(VALIDATE)) {
            sb = this.setValidateBody(jm, nl, sb);
        } else if (mn.equals(VALIDATE)) {
            sb = this.setValidateBody(jm, nl, sb);
        } else if (jm.isConstructor()) {
            sb = this.setConstructorBody(jm, nl, sb);
        } else {
            StrutsPlugin.getLogger().log("setMethodBody: unknown method: " + mn);
        }
        jm.appendMethodBody(String.valueOf(nl) + sb.toString() + nl);
    }

    public StringBuffer setConstructorBody(JMethod jm, String nl, StringBuffer sb) {
        sb.append("super(").append(new MethodStubDataUtil(jm, this.typeWizardUtil).getParamNamesString()).append(");").append(nl);
        return sb;
    }

    public StringBuffer setResetBody(JMethod jm, String nl, StringBuffer sb) {
        Accessor a2;
        IActionFormRegionData afrd = this.getActionFormRegionData();
        FieldMap context = afrd.getFieldMap();
        FieldMap fields = context.getAllFields();
        FieldMap inners = context.getAllInners();
        ArrayList<Accessor> al = new ArrayList<Accessor>(context.keySet().size());
        for (String key : fields.keySet()) {
            a2 = new Accessor(key, fields.getFieldType(key));
            al.add(a2);
        }
        for (String key : inners.keySet()) {
            a2 = new Accessor(key, inners.getInnerType(key));
            al.add(a2);
        }
        if (ActionFormUtil.isEmpty(al)) {
            sb.append("// Reset field values here." + nl + nl);
        } else {
            sb.append("// Reset values are provided as samples only. Change as appropriate." + nl + nl);
            String rv = null;
            for (Accessor a2 : al) {
                String t = a2.getType();
                rv = t.equals("boolean") ? "false" : (t.equals("byte") ? "0" : (t.equals("char") ? "'\u0000'" : (t.equals("double") ? "0" : (t.equals("float") ? "0" : (t.equals("int") ? "0" : (t.equals("long") ? "0" : (t.equals("short") ? "0" : "null")))))));
                sb.append(String.valueOf(a2.getName()) + " = " + rv + ";\n");
            }
        }
        return sb;
    }

    public StringBuffer setValidateBody(JMethod jm, String nl, StringBuffer sb) {
        String aefqn = new StringBuffer("org.apache.struts.action").append(".ActionError").toString();
        String aesfqn = new StringBuffer("org.apache.struts.action").append(".ActionErrors").toString();
        sb.append(this.returnAndAddImport(aesfqn));
        sb.append(" errors = new ");
        sb.append(this.returnAndAddImport(aesfqn));
        sb.append("();" + nl);
        sb.append("// Validate the fields in your form, adding" + nl);
        sb.append("// adding each error to this.errors as found, e.g." + nl);
        sb.append(nl);
        sb.append("// if ((field == null) || (field.length() == 0)) {" + nl);
        sb.append("//   errors.add(");
        sb.append("\"field\"");
        sb.append(", new ");
        sb.append(aefqn);
        sb.append("(");
        sb.append("\"error.field.required\"");
        sb.append("));" + nl);
        sb.append("// }" + nl);
        sb.append("return errors;" + nl);
        return sb;
    }

    public String getDummy(String typename) {
        return typename.substring(0, 1).toLowerCase();
    }

    public String getGetter(String varname) {
        return "get" + varname.substring(0, 1).toUpperCase() + varname.substring(1);
    }

    public String getSetter(String varname) {
        return "set" + varname.substring(0, 1).toUpperCase() + varname.substring(1);
    }

    public static boolean isBlankMapping(FormBean fb) {
        String n = fb.getName();
        boolean ret = WizardUtils.isEmpty((String)n) || n.equals(NO_NAME) || n.equals(WizardUtils.getDefaultFormBeanName());
        return ret;
    }

    public static boolean areValidAccessorParams(String name, String type) {
        return Accessor.areValidParams((String)name, (String)type);
    }

    public String getInstanceDataDeclarations() {
        return "";
    }

    public String writeBeanyBody(FieldMap context) {
        StringBuffer ret = new StringBuffer();
        FieldMap fields = context.getAllFields();
        FieldMap inners = context.getAllInners();
        ArrayList<Accessor> all = new ArrayList<Accessor>(context.keySet().size());
        int n = fields.size() + inners.size();
        if (n > 0) {
            Accessor a;
            if (!context.isRoot()) {
                ret.append("class ");
                ret.append(context.getName());
                ret.append(" {\n");
            }
            String key2 = null;
            for (String key2 : fields.keySet()) {
                a = new Accessor(key2, context.getFieldType(key2));
                all.add(a);
            }
            for (String key2 : inners.keySet()) {
                a = new Accessor(key2, context.getInnerType(key2));
                all.add(a);
            }
            ret.append(this.writeFields(all));
            ret.append("\n");
            ret.append(this.writeAccessors(all));
            ret.append("\n");
            for (String key2 : inners.keySet()) {
                assert (key2 != null && key2.length() > 0);
                Object val = inners.get(key2);
                assert (val != null);
                if (!(val instanceof InnerValue)) assert (false);
                context = ((InnerValue)val).getFieldMap();
                ret.append(this.writeBeanyBody(context));
                if (context.isRoot()) continue;
                ret.append("} // end class ");
                ret.append(context.getName());
                ret.append("\n\n");
            }
        }
        return ret.toString();
    }

    public String writeFields(ArrayList al) {
        StringBuffer ret = new StringBuffer();
        if (al.size() > 0) {
            String name = null;
            String type = null;
            for (Accessor a : al) {
                assert (a != null);
                name = a.getName();
                assert (name != null && name.length() > 0);
                type = a.getType();
                assert (type != null && type.length() > 0);
                ret.append("private ").append(type).append(" ").append(name);
                if (WizardUtils.isPrimitive((String)type)) {
                    ret.append(";\n");
                    continue;
                }
                ret.append(" = null;\n");
            }
        }
        return ret.toString();
    }

    public String writeAccessors(ArrayList al) {
        StringBuffer ret = new StringBuffer();
        if (al.size() > 0) {
            String name = null;
            String type = null;
            String dummy = null;
            String getter = null;
            String setter = null;
            for (Accessor a : al) {
                assert (a != null);
                name = a.getName();
                assert (name != null && name.length() > 0);
                dummy = this.getDummy(name);
                type = a.getType();
                assert (type != null && type.length() > 0);
                this.returnAndAddImport(type);
                getter = this.getGetter(name);
                setter = this.getSetter(name);
                ret.append("/**\n");
                ret.append(" * Get ").append(name).append("\n");
                ret.append(" * @return ").append(type).append("\n");
                ret.append(" */\n");
                ret.append("public ").append(type).append(" ").append(getter).append("() {\n");
                ret.append("\treturn ").append(name).append(";\n");
                ret.append("}\n");
                ret.append("\n");
                ret.append("/**\n");
                ret.append(" * Set ").append(name).append("\n");
                ret.append(" * @param <code>").append(type).append("</code>\n");
                ret.append(" */\n");
                ret.append("public void ").append(setter).append("(").append(type).append(" ").append(dummy).append(") {\n");
                ret.append("\tthis.").append(name).append(" = ").append(dummy).append(";\n");
                ret.append("}\n");
                ret.append("\n");
            }
        }
        return ret.toString();
    }

    public static String getDefaultSuperclassName(IActionFormRegionData srd) {
        return "org.apache.struts.action.ActionForm";
    }
}

