/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards.exception;

import com.ibm.etools.model2.base.util.CommonDialogManager;
import com.ibm.etools.model2.base.util.JavaResourceFinder;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.base.util.WidgetUtils;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.Images;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.util.StrutsUtil;
import com.ibm.etools.struts.utilities.JDTUtils;
import com.ibm.etools.struts.wizards.StrutsProjectSelectionDialog;
import com.ibm.etools.struts.wizards.exception.StrutsExceptionConfiguration;
import com.ibm.etools.struts.wizards.exception.StrutsExceptionWizard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class StrutsExceptionWizardPage
extends WizardPage {
    private FormToolkit formToolKit;
    private static final String CREATION_SUPERCLASS = "java.lang.Exception";
    private Hyperlink typeHyperlink;
    private Hyperlink handlerHyperlink;
    private Text projectText;
    private Combo strutsConfigFileCombo;
    private Combo extendsCombo;
    private Text typeText;
    private Button typeBrowseButton;
    private Text pathText;
    private Text handlerText;
    private Button handlerBrowseButton;
    private Group contextGroup;
    private Button globalButton;
    private Combo actionMappingCombo;
    private Combo resourceBundleCombo;
    private Text keyText;
    private Combo scopeCombo;
    private static final String DEFAULT = ResourceHandler.Provider_Default_label;

    public StrutsExceptionWizardPage(String pageName) {
        super(pageName, ResourceHandler.strutsExceptionWizard_pageTitle, Images.getExceptionWizardDescriptor());
        this.setDescription(ResourceHandler.strutsExceptionWizard_description);
        this.formToolKit = new FormToolkit(Display.getDefault());
    }

    private void createContextControl(Composite composite) {
        this.contextGroup = WidgetUtils.createGroup((Composite)composite, (int)2, (String)ResourceHandler.strutsExceptionWizard_context);
        this.globalButton = WidgetUtils.createRadioButton((Composite)this.contextGroup, (String)ResourceHandler.strutsExceptionWizard_global);
        WidgetUtils.createLabel((Composite)this.contextGroup, (String)"");
        Button localButton = WidgetUtils.createRadioButton((Composite)this.contextGroup, (String)ResourceHandler.strutsExceptionWizard_local);
        this.globalButton.setSelection(this.getConfiguration().isContextGlobal());
        if (this.getConfiguration().isContextGlobal()) {
            this.globalButton.setSelection(true);
        } else {
            localButton.setSelection(true);
        }
        this.globalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StrutsExceptionWizardPage.this.handleContextChanged(((Button)e.widget).getSelection());
            }
        });
        this.actionMappingCombo = WidgetUtils.createCombo((Composite)this.contextGroup, (int)12, (int)768);
        this.actionMappingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StrutsExceptionWizardPage.this.handleActionMappingComboSelected();
            }
        });
        WidgetUtils.setAccessibility((Control)this.actionMappingCombo, (String)ResourceHandler.strutsExceptionWizard_local);
        this.actionMappingCombo.setEnabled(!this.getConfiguration().isContextGlobal());
        this.globalButton.setSelection(this.getConfiguration().isContextGlobal());
        this.updateContext();
    }

    public void createControl(Composite parent) {
        this.formToolKit.setBackground(parent.getBackground());
        Composite composite = WidgetUtils.createComposite((Composite)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.struts.xcpt0001");
        Composite basics = WidgetUtils.createComposite((Composite)composite, (int)2);
        this.createProjectControl(basics);
        this.createStrutsConfigFileControl(basics);
        this.createTypeControl(basics);
        this.createPathControl(basics);
        this.createHandlerControl(basics);
        this.createExtendsControl(basics);
        this.createContextControl(composite);
        this.createErrorMessageControl(composite);
        this.setControl((Control)composite);
        this.validatePage();
    }

    private void createErrorMessageControl(Composite composite) {
        Group group = WidgetUtils.createGroup((Composite)composite, (int)2, (String)ResourceHandler.strutsExceptionWizard_error_message);
        WidgetUtils.createLabel((Composite)group, (String)ResourceHandler.key_colon__UI_);
        this.keyText = WidgetUtils.createText((Composite)group);
        this.keyText.setText(this.getConfiguration().getKey());
        this.keyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StrutsExceptionWizardPage.this.handleKeyTextModified();
            }
        });
        WidgetUtils.createLabel((Composite)group, (String)ResourceHandler.facet_install_page_label_bundleLabel);
        this.resourceBundleCombo = WidgetUtils.createCombo((Composite)group, (int)12, (int)768);
        this.updateResourceBundleCombo();
        this.resourceBundleCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StrutsExceptionWizardPage.this.handleResourceBundleTextModified();
            }
        });
        WidgetUtils.createLabel((Composite)group, (String)ResourceHandler.Scope_colon__UI_);
        this.scopeCombo = WidgetUtils.createCombo((Composite)group, (int)12, (int)768);
        this.scopeCombo.setItems(new String[]{DEFAULT, "request", "session"});
        this.updateScopeCombo();
        this.scopeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StrutsExceptionWizardPage.this.handleScopeComboModified();
            }
        });
        this.updateKeyText();
    }

    private void createExtendsControl(Composite parent) {
        WidgetUtils.createLabel((Composite)parent, (String)NLS.bind((String)ResourceHandler.wizard_common_extends_label, (Object)ResourceHandler.wizard_common_extends_exception));
        Composite composite = WidgetUtils.createSkinnyComposite((Composite)parent);
        this.extendsCombo = WidgetUtils.createCombo((Composite)composite, (int)12, (int)768);
        this.extendsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StrutsExceptionWizardPage.this.handleExtendsComboSelected();
            }
        });
        WidgetUtils.setAccessibility((Control)this.extendsCombo, (String)NLS.bind((String)ResourceHandler.wizard_common_extends_label, (Object)ResourceHandler.wizard_common_extends_exception));
        WidgetUtils.setToolTipText((Control)this.extendsCombo, (String)NLS.bind((String)ResourceHandler.wizard_common_extends_tool_tip, (Object)ResourceHandler.wizard_common_extends_exception));
        this.updateExtendsCombo();
    }

    private void createHandlerControl(Composite parent) {
        this.handlerHyperlink = this.formToolKit.createHyperlink(parent, ResourceHandler.handler_colon__UI_, 0);
        this.handlerHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                StrutsExceptionWizardPage.this.doHandlerHyperlinkClickAction();
            }

            public void linkEntered(HyperlinkEvent e) {
                StrutsExceptionWizardPage.this.updateHandlerHyperlinkState();
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        Composite composite = WidgetUtils.createSkinnyComposite((Composite)parent, (int)2);
        this.handlerText = WidgetUtils.createText((Composite)composite);
        if (this.getConfiguration().getHandler() != null) {
            this.handlerText.setText(this.getConfiguration().getHandler().getFullyQualifiedName());
        }
        this.handlerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StrutsExceptionWizardPage.this.handleHandlerTextModified();
            }
        });
        WidgetUtils.setAccessibility((Control)this.handlerText, (String)ResourceHandler.handler_colon__UI_);
        this.handlerBrowseButton = WidgetUtils.createPushButton((Composite)composite, (String)ResourceHandler.Browse__UI_);
        this.handlerBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StrutsExceptionWizardPage.this.handleHandlerBrowseButtonSelected();
            }
        });
        this.updateHandlerControl();
        this.updateHandlerHyperlinkState();
    }

    private void createPathControl(Composite parent) {
        WidgetUtils.createLabel((Composite)parent, (String)ResourceHandler.Path_colon__UI_);
        Composite composite = WidgetUtils.createSkinnyComposite((Composite)parent);
        this.pathText = WidgetUtils.createText((Composite)composite);
        if (this.getConfiguration().getPath() != null) {
            this.pathText.setText(this.getConfiguration().getPath());
        }
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StrutsExceptionWizardPage.this.handlePathTextModified();
            }
        });
        WidgetUtils.setAccessibility((Control)this.pathText, (String)ResourceHandler.Path_colon__UI_);
        this.updatePathText();
    }

    private void createProjectControl(Composite parent) {
        WidgetUtils.createLabel((Composite)parent, (String)ResourceHandler.strutsExceptionWizard_project_label);
        Composite composite = WidgetUtils.createSkinnyComposite((Composite)parent, (int)2);
        this.projectText = WidgetUtils.createText((Composite)composite, (int)2056);
        this.projectText.setText(this.getConfiguration().getComponentName());
        WidgetUtils.setAccessibility((Control)this.projectText, (String)ResourceHandler.strutsExceptionWizard_project_label);
        Button button = WidgetUtils.createPushButton((Composite)composite, (String)ResourceHandler.Browse__UI_);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StrutsExceptionWizardPage.this.handleProjectBrowseButtonSelected();
            }
        });
    }

    private void createStrutsConfigFileControl(Composite parent) {
        WidgetUtils.createLabel((Composite)parent, (String)ResourceHandler.strutsExceptionWizard_scf_label);
        Composite composite = WidgetUtils.createSkinnyComposite((Composite)parent);
        this.strutsConfigFileCombo = WidgetUtils.createCombo((Composite)composite, (int)12, (int)768);
        this.strutsConfigFileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StrutsExceptionWizardPage.this.handleStrutsConfigFileComboSelected();
            }
        });
        WidgetUtils.setAccessibility((Control)this.strutsConfigFileCombo, (String)ResourceHandler.strutsExceptionWizard_scf_label);
        this.updateStrutsConfigFileCombo();
    }

    private void createTypeControl(Composite parent) {
        this.typeHyperlink = this.formToolKit.createHyperlink(parent, ResourceHandler.Type_colon__UI_, 0);
        this.typeHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                StrutsExceptionWizardPage.this.doTypeHyperlinkClickAction();
            }

            public void linkEntered(HyperlinkEvent e) {
                StrutsExceptionWizardPage.this.updateTypeHyperlinkState();
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        Composite composite = WidgetUtils.createSkinnyComposite((Composite)parent, (int)2);
        this.typeText = WidgetUtils.createText((Composite)composite);
        if (this.getConfiguration().getType() != null) {
            this.typeText.setText(this.getConfiguration().getType().getFullyQualifiedName());
        }
        this.typeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StrutsExceptionWizardPage.this.handleTypeTextModified();
            }
        });
        WidgetUtils.setAccessibility((Control)this.typeText, (String)ResourceHandler.Type_colon__UI_);
        this.typeBrowseButton = WidgetUtils.createPushButton((Composite)composite, (String)ResourceHandler.Browse__UI_);
        this.typeBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StrutsExceptionWizardPage.this.handleTypeBrowseButtonSelected();
            }
        });
        this.updateTypeControl();
        this.updateTypeHyperlinkState();
    }

    private void doHandlerHyperlinkClickAction() {
        if (this.getConfiguration().getStrutsConfigFile() != null) {
            String createdClassName = this.handlerText.getText();
            JavaResourceFinder finder = new JavaResourceFinder(this.getConfiguration().getStrutsConfigFile().getFullPath());
            if ((createdClassName = CommonDialogManager.openJavaWizard((String)createdClassName, (JavaResourceFinder)finder, (String)"org.apache.struts.action.ExceptionHandler", null)) != null) {
                this.handlerText.setText(createdClassName);
                this.handlerText.setFocus();
            }
        }
    }

    private void doTypeHyperlinkClickAction() {
        if (this.getConfiguration().getStrutsConfigFile() != null) {
            String createdClassName = this.typeText.getText();
            JavaResourceFinder finder = new JavaResourceFinder(this.getConfiguration().getStrutsConfigFile().getFullPath());
            if ((createdClassName = CommonDialogManager.openJavaWizard((String)createdClassName, (JavaResourceFinder)finder, (String)CREATION_SUPERCLASS, null)) != null) {
                this.typeText.setText(createdClassName);
                this.typeText.setFocus();
            }
        }
    }

    private StrutsExceptionConfiguration getConfiguration() {
        return ((StrutsExceptionWizard)this.getWizard()).getConfiguration();
    }

    private String getPossibleMatchingPath(Collection<String> list, String path) {
        if (list.isEmpty()) {
            return path;
        }
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            if (!path.equals(iter.next())) continue;
            return path;
        }
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return new String("/" + path);
    }

    private IType getType(String name) {
        IVirtualComponent component = this.getConfiguration().getComponent();
        if (component != null) {
            return Model2Util.getType((IProject)component.getProject(), (String)name);
        }
        return null;
    }

    private void handleActionMappingComboSelected() {
        this.getConfiguration().setActionMapping(this.actionMappingCombo.getText());
        this.updateExtendsCombo();
        this.validatePage();
    }

    private void handleContextChanged(boolean isContextGlobal) {
        this.getConfiguration().setContextGlobal(isContextGlobal);
        if (isContextGlobal) {
            this.getConfiguration().setActionMapping(null);
        } else {
            this.getConfiguration().setActionMapping(this.actionMappingCombo.getText());
        }
        this.actionMappingCombo.setEnabled(!isContextGlobal);
        this.updateExtendsCombo();
        this.validatePage();
    }

    private void handleExtendsComboSelected() {
        this.getConfiguration().setExtends(this.extendsCombo.getText());
        this.validatePage();
    }

    private void handleHandlerBrowseButtonSelected() {
        String handler;
        IVirtualComponent component = this.getConfiguration().getComponent();
        if (component != null && (handler = CommonDialogManager.openClassBrowser((IVirtualComponent)component, (String)"org.apache.struts.action.ExceptionHandler")) != null) {
            this.handlerText.setText(handler);
        }
    }

    private void handleHandlerTextModified() {
        this.getConfiguration().setHandler(this.getType(this.handlerText.getText()));
        this.updateHandlerHyperlinkState();
        this.validatePage();
    }

    private void handleKeyTextModified() {
        this.getConfiguration().setKey(this.keyText.getText());
        this.validatePage();
    }

    private void handlePathTextModified() {
        this.getConfiguration().setPath(this.pathText.getText());
        this.validatePage();
    }

    private void handleProjectBrowseButtonSelected() {
        StrutsProjectSelectionDialog dialog = new StrutsProjectSelectionDialog(this.getShell(), 1);
        if (dialog.open() == 0) {
            IProject project = dialog.getProject();
            IVirtualComponent component = Model2Util.findComponent((IResource)project);
            this.getConfiguration().setComponent(component);
            this.projectText.setText(this.getConfiguration().getComponentName());
            this.updateTypeControl();
            this.updateHandlerControl();
            this.updateStrutsConfigFileCombo();
            this.updateContext();
            this.updateResourceBundleCombo();
            this.updateHandlerHyperlinkState();
            this.updateTypeHyperlinkState();
            this.updateScopeCombo();
            this.updatePathText();
            this.updateKeyText();
            this.validatePage();
        }
    }

    private void handleResourceBundleTextModified() {
        String bundle = this.resourceBundleCombo.getText();
        this.getConfiguration().setResourceBundle(bundle.equals(DEFAULT) ? "" : bundle);
        this.validatePage();
    }

    private void handleScopeComboModified() {
        String scope = this.scopeCombo.getText();
        this.getConfiguration().setScope(scope.equals(DEFAULT) ? null : scope);
        this.validatePage();
    }

    private void handleStrutsConfigFileComboSelected() {
        this.getConfiguration().setStrutsConfigPath((IPath)new Path(this.strutsConfigFileCombo.getText()));
        this.updateContext();
        this.validatePage();
    }

    private void handleTypeBrowseButtonSelected() {
        String type;
        IVirtualComponent component = this.getConfiguration().getComponent();
        if (component != null && (type = CommonDialogManager.openClassBrowser((IVirtualComponent)component, (String)CREATION_SUPERCLASS)) != null) {
            this.typeText.setText(type);
        }
    }

    private void handleTypeTextModified() {
        this.getConfiguration().setType(this.getType(this.typeText.getText()));
        this.updateTypeHyperlinkState();
        this.validatePage();
    }

    public void setMessage(String message, int type) {
        super.setMessage(message, type);
        this.setPageComplete(type != 3);
    }

    private void updateContext() {
        IFile file = this.getConfiguration().getStrutsConfigFile();
        if (file != null) {
            Set mappings = null;
            try {
                mappings = StrutsSearchUtil.getAllActionMappingsInStrutsConfigFile((IResource)file, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ReferenceException e) {
                e.printStackTrace();
            }
            if (mappings != null && mappings.size() > 0) {
                ArrayList<String> items = new ArrayList<String>();
                for (ILink link : mappings) {
                    items.add(link.getName());
                }
                this.actionMappingCombo.setItems(items.toArray(new String[items.size()]));
            }
        } else {
            this.actionMappingCombo.setItems(new String[0]);
        }
        boolean enabled = file != null;
        WidgetUtils.setEnabled((Control)this.contextGroup, (boolean)enabled);
        this.actionMappingCombo.setEnabled(enabled && !this.globalButton.getSelection());
        this.updateExtendsCombo();
    }

    private void updateExtendsCombo() {
        if (this.getConfiguration().getComponent() != null && StrutsProjectCoreUtil.isStruts1_3((IProject)this.getConfiguration().getComponent().getProject())) {
            StrutsExceptionConfiguration strutsExceptionConfig = this.getConfiguration();
            List<String> handlers = StrutsUtil.getAllExtendsValues(strutsExceptionConfig.getStrutsConfigFile(), StrutsUtil.ElementType.EXCEPTION, strutsExceptionConfig.getActionMapping());
            this.extendsCombo.setEnabled(true);
            this.extendsCombo.removeAll();
            this.extendsCombo.add("");
            for (String handler : handlers) {
                this.extendsCombo.add(handler);
            }
            this.extendsCombo.setText("");
        } else {
            this.extendsCombo.removeAll();
            this.extendsCombo.setEnabled(false);
        }
    }

    private void updateHandlerControl() {
        boolean enabled;
        boolean bl = enabled = this.getConfiguration().getComponent() != null;
        if (this.handlerBrowseButton.isEnabled() != enabled) {
            this.handlerText.setEnabled(enabled);
            this.handlerBrowseButton.setEnabled(enabled);
        }
    }

    private void updateHandlerHyperlinkState() {
        if (this.handlerText != null) {
            String typeName = this.handlerText.getText();
            if (typeName == null) {
                typeName = "";
                this.handlerText.setText(typeName);
            }
            if (this.getConfiguration().getStrutsConfigFile() != null) {
                IJavaProject jp = JavaCore.create((IProject)this.getConfiguration().getStrutsConfigFile().getProject());
                IType type = null;
                boolean typeExists = false;
                try {
                    type = jp.findType(typeName);
                    if (type != null) {
                        typeExists = true;
                    }
                }
                catch (JavaModelException e1) {
                    StrutsPlugin.getLogger().log((Throwable)e1);
                }
                if (typeExists) {
                    this.handlerHyperlink.setEnabled(false);
                    this.handlerHyperlink.setUnderlined(false);
                } else {
                    this.handlerHyperlink.setEnabled(true);
                    this.handlerHyperlink.setUnderlined(true);
                }
            } else {
                this.handlerHyperlink.setEnabled(false);
                this.handlerHyperlink.setUnderlined(false);
            }
        }
    }

    private void updateKeyText() {
        boolean enabled;
        boolean bl = enabled = this.getConfiguration().getComponent() != null;
        if (this.keyText.isEnabled() != enabled) {
            this.keyText.setEnabled(enabled);
        }
    }

    private void updatePathText() {
        boolean enabled;
        boolean bl = enabled = this.getConfiguration().getComponent() != null;
        if (this.pathText.isEnabled() != enabled) {
            this.pathText.setEnabled(enabled);
        }
    }

    private void updateResourceBundleCombo() {
        IJavaProject javaProject;
        String[] bundles;
        IVirtualComponent component = this.getConfiguration().getComponent();
        if (component != null && (bundles = JDTUtils.getResourceBundleNames(javaProject = JavaCore.create((IProject)component.getProject()))).length > 0) {
            int i;
            String[] items = new String[bundles.length + 1];
            items[0] = DEFAULT;
            System.arraycopy(bundles, 0, items, 1, bundles.length);
            this.resourceBundleCombo.setItems(items);
            String item = this.getConfiguration().getResourceBundle();
            if (item == null) {
                item = DEFAULT;
            }
            this.resourceBundleCombo.select((i = this.resourceBundleCombo.indexOf(item)) == -1 ? 0 : i);
            this.resourceBundleCombo.setEnabled(true);
            return;
        }
        this.resourceBundleCombo.setItems(new String[]{DEFAULT});
        this.resourceBundleCombo.select(0);
        this.resourceBundleCombo.setEnabled(false);
    }

    private void updateScopeCombo() {
        boolean enabled;
        boolean bl = enabled = this.getConfiguration().getComponent() != null;
        if (enabled) {
            int i;
            this.scopeCombo.setEnabled(true);
            String item = this.getConfiguration().getScope();
            if (item == null) {
                item = DEFAULT;
            }
            this.scopeCombo.select((i = this.scopeCombo.indexOf(item)) == -1 ? 0 : i);
        } else {
            this.scopeCombo.setText("");
            this.scopeCombo.setEnabled(false);
        }
    }

    private void updateStrutsConfigFileCombo() {
        IVirtualComponent component = this.getConfiguration().getComponent();
        if (component != null) {
            Set scLinks;
            try {
                scLinks = StrutsSearchUtil.getStrutsConfigFileLinks((IProject)component.getProject(), null);
            }
            catch (ReferenceException e) {
                e.printStackTrace();
                scLinks = Collections.emptySet();
            }
            Collection list = StrutsSearchUtil.convertPathsToStrings((Collection)StrutsSearchUtil.convertFilesToDocRootRelativePaths((Collection)StrutsSearchUtil.convertLinksToFiles(scLinks)));
            if (!list.isEmpty()) {
                if (this.strutsConfigFileCombo != null && !this.strutsConfigFileCombo.isEnabled()) {
                    this.strutsConfigFileCombo.setEnabled(true);
                }
                this.strutsConfigFileCombo.setItems(list.toArray(new String[list.size()]));
                IPath path = this.getConfiguration().getStrutsConfigPath();
                if (path != null) {
                    String possibleMatchingPath = this.getPossibleMatchingPath(list, path.toString());
                    int i = this.strutsConfigFileCombo.indexOf(possibleMatchingPath);
                    if (i != -1) {
                        this.strutsConfigFileCombo.select(i);
                    } else {
                        this.strutsConfigFileCombo.deselectAll();
                    }
                } else {
                    this.getConfiguration().setStrutsConfigPath((IPath)new Path((String)list.iterator().next()));
                    this.strutsConfigFileCombo.select(0);
                    this.strutsConfigFileCombo.setEnabled(true);
                }
                return;
            }
            this.getConfiguration().setStrutsConfigPath(null);
            if (this.strutsConfigFileCombo != null && this.strutsConfigFileCombo.isEnabled()) {
                this.strutsConfigFileCombo.setEnabled(false);
            }
        }
        this.strutsConfigFileCombo.removeAll();
        this.strutsConfigFileCombo.setEnabled(false);
    }

    private void updateTypeControl() {
        boolean enabled;
        boolean bl = enabled = this.getConfiguration().getComponent() != null;
        if (this.typeBrowseButton.isEnabled() != enabled) {
            this.typeText.setEnabled(enabled);
            this.typeBrowseButton.setEnabled(enabled);
        }
    }

    private void updateTypeHyperlinkState() {
        if (this.typeText != null) {
            String typeName = this.typeText.getText();
            if (typeName == null) {
                typeName = "";
                this.typeText.setText(typeName);
            }
            if (this.getConfiguration().getStrutsConfigFile() != null) {
                IJavaProject jp = JavaCore.create((IProject)this.getConfiguration().getStrutsConfigFile().getProject());
                IType type = null;
                boolean typeExists = false;
                try {
                    type = jp.findType(typeName);
                    if (type != null) {
                        typeExists = true;
                    }
                }
                catch (JavaModelException e1) {
                    StrutsPlugin.getLogger().log((Throwable)e1);
                }
                if (typeExists) {
                    this.typeHyperlink.setEnabled(false);
                    this.typeHyperlink.setUnderlined(false);
                } else {
                    this.typeHyperlink.setEnabled(true);
                    this.typeHyperlink.setUnderlined(true);
                }
            } else {
                this.typeHyperlink.setEnabled(false);
                this.typeHyperlink.setUnderlined(false);
            }
        }
    }

    private void validatePage() {
        if (this.getConfiguration().getComponent() == null) {
            this.setMessage(ResourceHandler.strutsExceptionWizard_error_noProject, 3);
            return;
        }
        IProject project = this.getConfiguration().getComponent().getProject();
        if (this.getConfiguration().getStrutsConfigFile() == null) {
            this.setMessage(ResourceHandler.wizard_common_mapping_error_noSCF, 3);
            return;
        }
        if (this.getConfiguration().getStrutsConfigPath() == null) {
            this.setMessage(ResourceHandler.strutsExceptionWizard_error_noSCF, 3);
            return;
        }
        if (this.getConfiguration().getType() == null) {
            String typeName = this.typeText.getText();
            if (typeName.length() == 0) {
                this.setMessage(ResourceHandler.strutsExceptionWizard_error_noType, 3);
                return;
            }
            IStatus status = JavaConventions.validateJavaTypeName((String)typeName, (String)StrutsProjectCoreUtil.getJavaVersion((IProject)project), (String)StrutsProjectCoreUtil.getJavaVersion((IProject)project));
            if (status.getSeverity() == 4) {
                this.setMessage(NLS.bind((String)ResourceHandler.strutsExceptionWizard_error_badType, (Object)status.getMessage()), 3);
                return;
            }
            this.setMessage(ResourceHandler.strutsExceptionWizard_error_awolType, 3);
            return;
        }
        if (!Model2Util.isExtenderOf((IType)this.getConfiguration().getType(), (String)CREATION_SUPERCLASS)) {
            this.setMessage(ResourceHandler.strutsExceptionWizard_error_wrongType, 3);
            return;
        }
        String handlerName = this.handlerText.getText();
        if (handlerName.length() > 0) {
            if (this.getConfiguration().getHandler() == null) {
                IStatus status = JavaConventions.validateJavaTypeName((String)handlerName, (String)StrutsProjectCoreUtil.getJavaVersion((IProject)project), (String)StrutsProjectCoreUtil.getJavaVersion((IProject)project));
                if (status.getSeverity() == 4) {
                    this.setMessage(NLS.bind((String)ResourceHandler.strutsExceptionWizard_error_badHandler, (Object)status.getMessage()), 3);
                    return;
                }
                this.setMessage(ResourceHandler.strutsExceptionWizard_error_awolHandler, 3);
                return;
            }
            if (!Model2Util.isExtenderOf((IType)this.getConfiguration().getHandler(), (String)"org.apache.struts.action.ExceptionHandler")) {
                this.setMessage(ResourceHandler.strutsExceptionWizard_error_wrongHandler, 3);
                return;
            }
            if (handlerName.equals(this.extendsCombo.getText())) {
                this.setMessage(ResourceHandler.strutsExceptionWizard_error_wrongExtends, 3);
                return;
            }
        }
        if (!this.getConfiguration().isContextGlobal() && this.getConfiguration().getActionMapping().length() == 0) {
            this.setMessage(ResourceHandler.strutsExceptionWizard_error_noAction, 3);
            return;
        }
        if (this.getConfiguration().getKey().length() == 0 && !StrutsProjectCoreUtil.isStruts1_3((IProject)project)) {
            this.setMessage(ResourceHandler.strutsExceptionWizard_error_noKey, 3);
            return;
        }
        this.setMessage(null, 0);
    }
}

