/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards.exception;

import com.ibm.etools.model2.base.util.CommonDialogManager;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.emf.strutsconfig.Exception0;
import com.ibm.etools.struts.emf.strutsconfig.RequestScope;
import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigPackage;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.util.StrutsArtifactEdit;
import com.ibm.etools.struts.wizards.exception.StrutsExceptionConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;

public class StrutsExceptionOperation
extends WorkspaceModifyOperation {
    private StrutsExceptionConfiguration configuration;
    private IProgressMonitor progressMonitor;

    StrutsExceptionOperation(StrutsExceptionConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void execute(IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.progressMonitor = progressMonitor;
        try {
            IStatus status;
            IFile strutsConfigFile = this.configuration.getStrutsConfigFile();
            if (strutsConfigFile != null && (status = Model2Util.validateEdit((IFile)strutsConfigFile, (Shell)CommonDialogManager.getShell())).getSeverity() != 0) {
                throw new InvocationTargetException(new CoreException(status));
            }
            this.updateStrutsConfigFile(this.configuration.getStrutsConfigFile());
        }
        finally {
            progressMonitor.done();
        }
    }

    private void updateStrutsConfigFile(IFile strutsConfigFile) {
        StrutsArtifactEdit strutsArtifactEdit = StrutsArtifactEdit.getStrutsArtifactEditForWrite(strutsConfigFile);
        try {
            try {
                StrutsConfig strutsConfig;
                IStructuredTextUndoManager undoManager = strutsArtifactEdit.getIDOMModel().getUndoManager();
                if (undoManager != null) {
                    undoManager.beginRecording((Object)this, ResourceHandler.strutsExceptionOperation_undo, ResourceHandler.strutsExceptionOperation_undo);
                }
                if ((strutsConfig = strutsArtifactEdit.getStrutsConfig()) != null) {
                    this.updateStrutsConfig(strutsConfig);
                }
                if (undoManager != null) {
                    undoManager.endRecording((Object)this);
                }
            }
            catch (Exception exception) {
                StrutsPlugin.getLogger().log("Exception during update of web.xml", (Throwable)exception);
                strutsArtifactEdit.saveIfNecessary(this.progressMonitor);
                strutsArtifactEdit.dispose();
            }
        }
        finally {
            strutsArtifactEdit.saveIfNecessary(this.progressMonitor);
            strutsArtifactEdit.dispose();
        }
    }

    private void updateStrutsConfig(StrutsConfig strutsConfig) {
        EList<Exception0> exceptions = null;
        if (this.configuration.isContextGlobal()) {
            exceptions = strutsConfig.getGlobalExceptions();
        } else {
            String mappingPath = this.configuration.getActionMapping();
            EList<ActionMapping> mappings = strutsConfig.getActionMappings();
            Iterator iterator = mappings.iterator();
            ActionMapping mapping = null;
            while (iterator.hasNext()) {
                ActionMapping tmpMapping = (ActionMapping)iterator.next();
                if (!mappingPath.equals(tmpMapping.getPath())) continue;
                mapping = tmpMapping;
                break;
            }
            if (mapping == null) {
                return;
            }
            exceptions = mapping.getExceptions();
        }
        Exception0 exception = StrutsconfigPackage.eINSTANCE.getStrutsconfigFactory().createException0();
        if (this.configuration.getResourceBundle().length() > 0) {
            exception.setBundle(this.configuration.getResourceBundle());
        }
        if (this.configuration.getHandler() != null) {
            exception.setHandler(this.configuration.getHandler().getFullyQualifiedName());
        }
        if (this.configuration.getKey().length() > 0) {
            exception.setKey(this.configuration.getKey());
        }
        if (this.configuration.getPath().length() > 0) {
            exception.setPath(this.configuration.getPath());
        }
        if (this.configuration.getScope() != null) {
            exception.setScope(RequestScope.get(this.configuration.getScope()));
        }
        if (this.configuration.getExtends() != null && !this.configuration.getExtends().equals("")) {
            exception.setExtends0(this.configuration.getExtends());
        }
        exception.setType(this.configuration.getType().getFullyQualifiedName());
        exceptions.add((Object)exception);
    }
}

