/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards.exception;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.base.util.SelectionUtil;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.internal.util.StrutsProjectUtil;
import com.ibm.etools.struts.util.StrutsConfigFileUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class StrutsExceptionConfiguration {
    private IVirtualComponent component;
    private IPath strutsConfigPath;
    private IType type;
    private IType handler;
    private String path;
    private String extends0;
    private boolean isContextGlobal = true;
    private String actionMapping;
    private String resourceBundle;
    private String key;
    private String scope;

    public IPath getStrutsConfigPath() {
        if (this.strutsConfigPath == null) {
            this.strutsConfigPath = this.guessStrutsConfigPath();
            if (this.strutsConfigPath == null) {
                this.strutsConfigPath = Path.EMPTY;
            }
        }
        return this.strutsConfigPath.isEmpty() ? null : this.strutsConfigPath;
    }

    private IPath guessStrutsConfigPath() {
        if (this.getComponent() != null) {
            Set scLinks;
            try {
                scLinks = StrutsSearchUtil.getStrutsConfigFileLinks((IProject)this.component.getProject(), null);
            }
            catch (ReferenceException e) {
                e.printStackTrace();
                scLinks = Collections.emptySet();
            }
            Collection paths = StrutsSearchUtil.convertFilesToDocRootRelativePaths((Collection)StrutsSearchUtil.convertLinksToFiles(scLinks));
            if (!paths.isEmpty()) {
                return (IPath)paths.iterator().next();
            }
        }
        return null;
    }

    public void setStrutsConfigPath(IPath path) {
        this.strutsConfigPath = path;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IResource resource = this.getSelectedResource(selection = SelectionUtil.getStructuredSelection((ISelection)selection));
        if (resource != null) {
            IFile file;
            IVirtualComponent component = Model2Util.findComponent((IResource)resource.getProject());
            if (component != null && StrutsProjectUtil.getStrutsVersion((IProject)component.getProject()) >= 1) {
                this.setComponent(component);
            }
            if (resource instanceof IFile && StrutsConfigFileUtil.isStrutsConfigFile(file = (IFile)resource)) {
                this.setStrutsConfigPath(file.getProjectRelativePath().removeFirstSegments(1));
            }
        }
    }

    private IResource getSelectedResource(IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            IResource resource = (IResource)adaptable.getAdapter(IFile.class);
            if (resource != null) {
                return resource;
            }
            resource = (IResource)adaptable.getAdapter(IProject.class);
            if (resource != null) {
                return resource;
            }
            return (IResource)adaptable.getAdapter(IResource.class);
        }
        return null;
    }

    public IVirtualComponent getComponent() {
        return this.component;
    }

    public void setComponent(IVirtualComponent component) {
        this.component = component;
    }

    public String getComponentName() {
        return this.getComponent() == null ? "" : this.getComponent().getName();
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType type) {
        this.type = type;
    }

    public boolean isContextGlobal() {
        return this.isContextGlobal;
    }

    public void setContextGlobal(boolean b) {
        this.isContextGlobal = b;
    }

    public String getActionMapping() {
        if (this.actionMapping == null) {
            this.actionMapping = "";
        }
        return this.actionMapping;
    }

    public void setActionMapping(String string) {
        this.actionMapping = string;
    }

    public IFile getStrutsConfigFile() {
        IPath webModulePath;
        if (this.getComponent() != null && (webModulePath = Model2Util.getProjectRelativeDocRootPath((IVirtualComponent)this.getComponent())) != null && this.getStrutsConfigPath() != null) {
            return this.component.getProject().getFile(webModulePath.append(this.getStrutsConfigPath()));
        }
        return null;
    }

    public String getKey() {
        if (this.key == null) {
            this.key = "";
        }
        return this.key;
    }

    public String getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = "";
        }
        return this.resourceBundle;
    }

    public String getScope() {
        return this.scope;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public void setResourceBundle(String string) {
        this.resourceBundle = string;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    public IType getHandler() {
        return this.handler;
    }

    public void setHandler(IType type) {
        this.handler = type;
    }

    public String getExtends() {
        return this.extends0;
    }

    public void setExtends(String ext) {
        this.extends0 = ext;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = "";
        }
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }
}

