/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.version.validation;

import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.internal.util.StrutsProjectUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.version.validation.StrutsVersionHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class StrutsVersionValidator
implements IValidatorJob {
    public void cleanup(IReporter reporter) {
    }

    public IStatus validateInJob(IValidationContext context, IReporter reporter) throws ValidationException {
        this.validate(context, reporter);
        return OK_STATUS;
    }

    public void validate(IValidationContext context, IReporter reporter) throws ValidationException {
        StrutsVersionHelper helper;
        IProject project;
        if (context instanceof StrutsVersionHelper && reporter != null && (project = (helper = (StrutsVersionHelper)context).getProject()) != null) {
            reporter.removeAllMessages((IValidator)this, (Object)project);
            int version = StrutsProjectUtil.getStrutsVersionFromActionClass(project);
            if (version == -1) {
                version = StrutsProjectUtil.getStrutsVersion((IProject)project);
            }
            if (version != -1 && version <= 1) {
                reporter.addMessage((IValidator)this, this.getMessage(project));
                if (StrutsPlugin.getDefault().getStrutsPreferences().getSecurityWarning()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialogWithToggle dialog = StrutsVersionValidator.this.openWarning(project.getName());
                            if (dialog.getReturnCode() == 0) {
                                StrutsPlugin.getDefault().getStrutsPreferences().setSecurityWarning(!dialog.getToggleState());
                            }
                        }
                    });
                }
            }
        }
    }

    private IMessage getMessage(IProject project) {
        return new Message("com.ibm.etools.struts.nls.struts", 3, "Properties_project_UnsecureStrutsVersion", new String[]{project.getName()}, (Object)project);
    }

    private MessageDialogWithToggle openWarning(String projectName) {
        return MessageDialogWithToggle.openWarning((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)ResourceHandler.Message_dialog_error_title, (String)NLS.bind((String)ResourceHandler.Properties_project_UnsecureStrutsDialogWarningMessage, (Object)projectName), (String)ResourceHandler.Properties_project_UnsecureStrutsDialogWarningCheckBox, (boolean)false, null, null);
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }
}

