/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.utilities;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.nls.ResourceHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class JDTUtils {
    public static String[] getResourceBundleNames(IJavaProject javaProject) {
        IClasspathEntry[] entries = JDTUtils.getResolvedClasspath(javaProject, true);
        ArrayList names = new ArrayList();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 3) {
                IPackageFragmentRoot[] roots = javaProject.findPackageFragmentRoots(entry);
                int j = 0;
                while (j < roots.length) {
                    IPackageFragmentRoot root = roots[j];
                    if (JDTUtils.getKind(root) == 1) {
                        names.addAll(JDTUtils.getResourceBundleNames("", JDTUtils.getNonJavaResources(root)));
                        IPackageFragment[] fragments = JDTUtils.getChildren(root);
                        int k = 0;
                        while (k < fragments.length) {
                            IPackageFragment fragment = fragments[k];
                            names.addAll(JDTUtils.getResourceBundleNames(fragment.getElementName(), JDTUtils.getNonJavaResources(fragment)));
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return names.toArray(new String[names.size()]);
    }

    private static List getResourceBundleNames(String packageName, Object[] resources) {
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < resources.length) {
            IFile file;
            if (resources[i] instanceof IFile && (file = (IFile)resources[i]).getName().endsWith(".properties")) {
                String name = file.getName();
                name = name.substring(0, name.lastIndexOf(46));
                if (packageName.length() > 0) {
                    name = String.valueOf(packageName) + '.' + name;
                }
                names.add(name);
            }
            ++i;
        }
        return names;
    }

    public static IClasspathEntry[] getResolvedClasspath(IJavaProject javaProject, boolean ignoreUnresolvedEntry) {
        try {
            return javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            return new IClasspathEntry[0];
        }
    }

    public static int getKind(IPackageFragmentRoot root) {
        try {
            return root.getKind();
        }
        catch (JavaModelException javaModelException) {
            return 3;
        }
    }

    public static Object[] getNonJavaResources(IPackageFragmentRoot root) {
        try {
            return root.getNonJavaResources();
        }
        catch (JavaModelException javaModelException) {
            return new Object[0];
        }
    }

    public static Object[] getNonJavaResources(IPackageFragment fragment) {
        try {
            return fragment.getNonJavaResources();
        }
        catch (JavaModelException javaModelException) {
            return new Object[0];
        }
    }

    public static IPackageFragment[] getChildren(IPackageFragmentRoot root) {
        try {
            IJavaElement[] children = root.getChildren();
            IPackageFragment[] fragments = new IPackageFragment[children.length];
            System.arraycopy(children, 0, fragments, 0, children.length);
            return fragments;
        }
        catch (JavaModelException javaModelException) {
            return new IPackageFragment[0];
        }
    }

    public static IStatus validateTypeName(String typeName, IVirtualComponent component, boolean isResolved, boolean allowVoid) {
        String signature = Signature.createTypeSignature((String)typeName, (boolean)isResolved);
        if ((signature = Signature.getElementType((String)signature)).length() > 0) {
            char c = signature.charAt(0);
            switch (c) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    return Status.OK_STATUS;
                }
                case 'V': {
                    if (allowVoid) {
                        return Status.OK_STATUS;
                    }
                    return new Status(4, StrutsPlugin.getPluginId(), 4, ResourceHandler.wizard_common_void_not_allowed, null);
                }
            }
        }
        String type = Signature.toString((String)signature);
        if (!isResolved) {
            return JavaConventions.validateJavaTypeName((String)type);
        }
        IType javaType = Model2Util.getType((IProject)component.getProject(), (String)type);
        if (javaType == null) {
            return new Status(4, StrutsPlugin.getPluginId(), 4, NLS.bind((String)ResourceHandler.wizard_common_type_not_visible, (Object)type), null);
        }
        return Status.OK_STATUS;
    }
}

