/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.util;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.internal.util.StrutsProjectUtil;
import com.ibm.etools.struts.util.StrutsUtil;
import com.ibm.etools.struts.utilities.StrutsSelectorDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class StrutsConfigUtilities {
    public static IFile getConfigFileWithUserInput(IVirtualComponent component, String moduleName, boolean allConfiguredFiles) {
        String selectedConfig;
        List configNames = StrutsConfigUtilities.getSortedConfigFileList(component, moduleName, allConfiguredFiles);
        if (configNames == null || configNames.isEmpty()) {
            return null;
        }
        String string = selectedConfig = configNames.size() > 1 ? StrutsConfigUtilities.getConfigFileSelectionFromUser(configNames, component) : (String)configNames.get(0);
        if (!selectedConfig.equals("")) {
            return Model2Util.fileFor((IVirtualComponent)component, (String)selectedConfig);
        }
        return null;
    }

    public static List getSortedConfigFileList(IVirtualComponent component, String moduleName, boolean allConfiguredFiles) {
        List configNames = StrutsConfigUtilities.getConfigNames(component, moduleName, allConfiguredFiles);
        if (configNames == null || configNames.isEmpty() || configNames.size() == 1) {
            return configNames;
        }
        Object[] names = configNames.toArray();
        Arrays.sort(names);
        configNames.clear();
        int i = 0;
        while (i < names.length) {
            configNames.add(names[i]);
            ++i;
        }
        return configNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List getConfigNames(IVirtualComponent component, String moduleName, boolean allConfiguredFiles) {
        try {
            String module;
            if (component == null) {
                return null;
            }
            String string = module = moduleName == null ? "" : moduleName;
            if (StrutsProjectUtil.getStrutsVersion((IProject)component.getProject()) >= 1 && allConfiguredFiles) {
                Set files = StrutsSearchUtil.getStrutsConfigFileLinks((IProject)component.getProject(), (IProgressMonitor)new NullProgressMonitor());
                if (files == null) {
                    return null;
                }
                return StrutsConfigUtilities.getWebModuleRelativeConfigFileNames(files, component);
            }
            Set files = StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)component.getProject(), (String)module, (IProgressMonitor)new NullProgressMonitor());
            if (files == null) {
                return null;
            }
            return StrutsConfigUtilities.getWebModuleRelativeConfigFileNames(files, component);
        }
        catch (ReferenceException e) {
            StrutsPlugin.getLogger().log((Throwable)e);
            return null;
        }
    }

    private static String getConfigFileSelectionFromUser(List names, IVirtualComponent component) {
        StrutsSelectorDialog dialog = StrutsUtil.createStrutsConfigSelectionDialog(component);
        if (dialog != null) {
            dialog.setData(names);
            dialog.open();
            if (dialog.getReturnCode() == 0 && !dialog.getSelection().equals("")) {
                return dialog.getSelection();
            }
        }
        return "";
    }

    private static ArrayList getWebModuleRelativeConfigFileNames(Set<ILink> files, IVirtualComponent component) {
        if (files == null) {
            return null;
        }
        ArrayList<String> configFileNames = new ArrayList<String>();
        IPath path = Model2Util.getWorkspaceRelativeDocRootPath((IVirtualComponent)component);
        int pathLength = path.toString().length();
        for (ILink file : files) {
            String configPath;
            if (file == null || (configPath = file.getContainer().getResource().getFullPath().toString()).length() <= 0 || configPath.length() <= pathLength) continue;
            configFileNames.add(configPath.substring(path.toString().length()));
        }
        return configFileNames;
    }
}

