/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.util;

import com.ibm.etools.struts.util.BeanProperty;
import com.ibm.etools.struts.util.IndexSpecialBeanProperty;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.jem.internal.beaninfo.BeaninfoFactory;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoNature;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;

public final class StrutsConfigUtil {
    private static int PREFIX_LENGTH = 3;

    private StrutsConfigUtil() {
    }

    public static EList allLocalFeatures(JavaClass aClass) {
        BasicEList r = new BasicEList(aClass.getAllProperties().size());
        r.addAll((Collection)aClass.getAllProperties());
        return r;
    }

    public static void loadNature(IProject project) throws CoreException {
        BeaninfoNature.getRuntime((IProject)project);
    }

    public static List getProperties(JavaClass jc) {
        ArrayList<BeanProperty> beanProperties = new ArrayList<BeanProperty>();
        EList allLocalFeatures = StrutsConfigUtil.allLocalFeatures(jc);
        Iterator itr = Utilities.getPropertiesIterator((EList)allLocalFeatures);
        ArrayList<String> beanPropertiesNames = new ArrayList<String>();
        while (itr.hasNext()) {
            BeanProperty bp = new BeanProperty((PropertyDecorator)itr.next());
            beanProperties.add(bp);
            beanPropertiesNames.add(bp.getName());
        }
        beanProperties.addAll(StrutsConfigUtil.getIndexSpecialBeanProperties(jc, beanPropertiesNames));
        return beanProperties;
    }

    public static List getIndexSpecialBeanProperties(JavaClass jc, List beanPropertiesNames) {
        ArrayList<IndexSpecialBeanProperty> specialList = new ArrayList<IndexSpecialBeanProperty>();
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        List fList = jc.getFieldsExtended();
        for (Field field : fList) {
            fieldMap.put(field.getName(), field);
            if (!field.isArray() || beanPropertiesNames.contains(field.getName())) continue;
            String fieldType = ((ArrayType)field.getEType()).getComponentTypeAsHelper().getJavaName();
            Method getMethod = StrutsConfigUtil.findGetter(field.getName(), fieldType, jc.getPublicMethodsExtended());
            Method setMethod = StrutsConfigUtil.findSetter(field.getName(), fieldType, jc.getPublicMethodsExtended());
            if (getMethod == null && setMethod == null) continue;
            PropertyDecorator pd = BeaninfoFactory.eINSTANCE.createPropertyDecorator();
            pd.setEModelElement((EModelElement)field.getEType());
            ENamedElement ne = (ENamedElement)pd.getEModelElement();
            ne.setName(field.getName());
            pd.setEModelElement((EModelElement)ne);
            if (getMethod != null) {
                pd.setReadMethod(getMethod);
            }
            if (setMethod != null) {
                pd.setWriteMethod(setMethod);
            }
            specialList.add(new IndexSpecialBeanProperty(pd, field));
        }
        return specialList;
    }

    private static String getFieldName(String name) {
        return Introspector.decapitalize(name.substring(PREFIX_LENGTH));
    }

    private static Method findGetter(String fieldName, String fieldType, List methodList) {
        for (Method method : methodList) {
            String methodReturnType;
            String decapitalizedMethodName;
            EList methodParameters = method.getParameters();
            if (!method.getName().startsWith("get") || !(decapitalizedMethodName = StrutsConfigUtil.getFieldName(method.getName())).equals(fieldName) || methodParameters.size() != 1 || !((JavaParameter)methodParameters.get(0)).getJavaType().getJavaName().equals("int") || !fieldType.equals(methodReturnType = method.getReturnType().getName())) continue;
            return method;
        }
        return null;
    }

    private static Method findSetter(String fieldName, String fieldType, List methodList) {
        for (Method method : methodList) {
            String methodReturnType;
            String decapitalizedMethodName;
            EList methodParameters = method.getParameters();
            if (!method.getName().startsWith("set") || !(decapitalizedMethodName = StrutsConfigUtil.getFieldName(method.getName())).equals(fieldName) || methodParameters.size() != 2 || !((JavaParameter)methodParameters.get(0)).getJavaType().getJavaName().equals("int") || !((JavaParameter)methodParameters.get(1)).getJavaType().getJavaName().equals(fieldType) || !(methodReturnType = method.getReturnType().getName()).equals("void")) continue;
            return method;
        }
        return null;
    }
}

