/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.util;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.internal.util.StrutsProjectUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class StrutsConfigFileUtil {
    public static final String STRUTS_CONFIG_CONTENT_TYPE_ID = "com.ibm.etools.struts.strutsConfigFile";
    public static final int REQUIRE_NOTHING = 0;
    public static final int REQUIRE_STRUTS_COMPONENT = 1;
    public static final int REQUIRE_CONFIGURED = 2;

    public static boolean isStrutsConfigFile(IFile file) {
        return StrutsConfigFileUtil.isStrutsConfigFile(file, 1);
    }

    public static boolean isStrutsConfigFile(IFile file, int require) {
        if (!"xml".equalsIgnoreCase(file.getFileExtension())) {
            return false;
        }
        if (require >= 1) {
            IVirtualComponent component = Model2Util.findComponent((IResource)file);
            if (component == null) {
                return false;
            }
            if (!StrutsProjectUtil.isStruts((IProject)component.getProject())) {
                return false;
            }
            if (require == 2) {
                Set configLinks;
                try {
                    configLinks = StrutsSearchUtil.getStrutsConfigFileLinks((IProject)component.getProject(), null);
                }
                catch (ReferenceException e) {
                    e.printStackTrace();
                    configLinks = Collections.emptySet();
                }
                Iterator it = configLinks.iterator();
                while (it.hasNext()) {
                    IFile cf = (IFile)Platform.getAdapterManager().getAdapter((Object)((ILink)it.next()).getContainer().getResource(), IFile.class);
                    if (!cf.getFullPath().equals((Object)file.getFullPath())) continue;
                    return true;
                }
                return false;
            }
        }
        try {
            IContentType contentType;
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription != null && (contentType = contentDescription.getContentType()) != null) {
                return STRUTS_CONFIG_CONTENT_TYPE_ID.equals(contentType.getId());
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

