/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.util;

import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import com.ibm.etools.struts.util.StrutsArtifactEdit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;

public abstract class StrutsChangeCommand
extends ChangeCommand {
    protected boolean shouldForceSave = true;
    private IFile strutsConfigFile;
    private StrutsArtifactEdit edit;

    public StrutsChangeCommand(StrutsArtifactEdit edit) {
        super((Notifier)edit.getStrutsConfig());
        this.edit = edit;
        this.strutsConfigFile = edit.getFile();
    }

    public StrutsChangeCommand(EObject object) {
        this(StrutsChangeCommand.getStrutsConfigTypeInHeirarchy(object));
    }

    public StrutsChangeCommand(StrutsConfig strutsConfig) {
        super((Notifier)strutsConfig);
        Assert.isNotNull((Object)strutsConfig);
        this.strutsConfigFile = WorkspaceSynchronizer.getFile((Resource)strutsConfig.eResource());
        Assert.isNotNull((Object)this.strutsConfigFile);
        this.edit = StrutsArtifactEdit.getStrutsArtifactEditForWrite(this.strutsConfigFile);
        Assert.isNotNull((Object)((Object)this.edit));
        Assert.isTrue((strutsConfig == this.edit.getStrutsConfig() ? 1 : 0) != 0, (String)"StrutsConfig does not equal the edit model's StrutsConfig");
    }

    public static StrutsConfig getStrutsConfigTypeInHeirarchy(EObject object) {
        Assert.isNotNull((Object)object);
        Assert.isLegal((object.eResource() != null ? 1 : 0) != 0, (String)"EObject for struts config file is not within a file");
        EObject parent = object;
        while (parent != null) {
            if (parent instanceof StrutsConfig) {
                return (StrutsConfig)parent;
            }
            parent = parent.eContainer();
        }
        return null;
    }

    protected final void doExecute() {
        boolean succeeded = false;
        if (this.edit != null && (succeeded = this.doStrutsChanges(this.edit.getStrutsConfig()))) {
            if (this.shouldForceSave) {
                this.edit.save(null);
            } else {
                this.edit.saveIfNecessary(null);
            }
        }
    }

    public void undo() {
        super.undo();
        if (this.shouldForceSave) {
            this.edit.save(null);
        } else {
            this.edit.saveIfNecessary(null);
        }
    }

    public void redo() {
        super.redo();
        if (this.shouldForceSave) {
            this.edit.save(null);
        } else {
            this.edit.saveIfNecessary(null);
        }
    }

    public void dispose() {
        super.dispose();
        this.edit.dispose();
    }

    protected abstract boolean doStrutsChanges(StrutsConfig var1);
}

