/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.util;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import com.ibm.etools.struts.emf.strutsconfig.xml.StrutsConfigResource;
import com.ibm.etools.struts.emf.strutsconfig.xml.StrutsConfigResourceFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateInputProvider;
import org.eclipse.wst.xml.core.internal.emf2xml.EMF2DOMSSERenderer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class StrutsArtifactEdit
extends ArtifactEdit {
    private static URIPairCache cache = new URIPairCache();
    private IFile file;
    private StrutsConfigResource resource;

    public static StrutsArtifactEdit getStrutsArtifactEditForRead(IFile file) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("STRUTS_CONFIG_FILE_NAME", file.getFullPath().toString());
        return new StrutsArtifactEdit(file, true, params);
    }

    public static StrutsArtifactEdit getStrutsArtifactEditForWrite(IFile file) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("STRUTS_CONFIG_FILE_NAME", file.getFullPath().toString());
        return new StrutsArtifactEdit(file, false, params);
    }

    private StrutsArtifactEdit(IFile file, boolean toAccessAsReadOnly, Map params) {
        super(file.getProject(), toAccessAsReadOnly, false, "struts", params);
        this.file = file;
    }

    public void dispose() {
        this.resource = null;
        this.file = null;
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StrutsConfig getStrutsConfig() {
        StrutsConfigResource resource = this.getStrutsConfigResource();
        if (resource != null) {
            Object rootObject;
            EList contents;
            if (!resource.isLoaded()) {
                try {
                    Object object = resource.getLock();
                    synchronized (object) {
                        resource.load(resource.getLastLoadOptions());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if ((contents = resource.getContents()).size() > 0 && (rootObject = contents.get(0)) instanceof StrutsConfig) {
                return (StrutsConfig)contents.get(0);
            }
        }
        return null;
    }

    public StrutsConfigResource getStrutsConfigResource() {
        ArtifactEditModel editModel;
        if (this.resource == null && (editModel = this.getArtifactEditModel()) != null) {
            ResourceSet resourceSet = editModel.getResourceSet();
            URIPair uris = (URIPair)cache.get(this.file);
            Resource tempResource = resourceSet.getResource(uris.platformURI, false);
            if (tempResource == null) {
                tempResource = StrutsConfigResourceFactory.INSTANCE.createResource(uris.platformURI);
                resourceSet.getResources().add((Object)tempResource);
            }
            this.resource = (StrutsConfigResource)editModel.getResource(uris.simpleURI);
        }
        return this.resource;
    }

    public IDOMModel getIDOMModel() {
        StrutsConfigResource scfResource = this.getStrutsConfigResource();
        if (scfResource != null) {
            EMF2DOMSSERenderer renderer = (EMF2DOMSSERenderer)scfResource.getRenderer();
            return renderer.getXMLModel();
        }
        return null;
    }

    public IFile getFile() {
        return this.file;
    }

    public ResourceStateInputProvider getResourceStateInputProvider() {
        return this.getArtifactEditModel();
    }

    public void removeListener(EditModelListener listener) {
        ArtifactEditModel editModel = this.getArtifactEditModel();
        if (editModel != null && !editModel.isDisposed()) {
            super.removeListener(listener);
        }
    }

    private static class URIPair {
        public final URI simpleURI;
        public final URI platformURI;

        public URIPair(IFile file) {
            this.simpleURI = URI.createURI((String)Model2Util.getDocRootRelativePath((IFile)file).toString());
            this.platformURI = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        }
    }

    private static class URIPairCache
    extends LinkedHashMap {
        private static final long serialVersionUID = -8299748582213789083L;

        public URIPairCache() {
            super(16, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry arg0) {
            return this.size() > 16;
        }

        @Override
        public Object get(Object key) {
            Object value = super.get(key);
            if (value == null) {
                value = new URIPair((IFile)key);
                this.put(key, value);
            }
            return value;
        }
    }
}

