/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.ui.overlay;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.emf.strutsconfig.Controller;
import com.ibm.etools.struts.emf.strutsconfig.DataSource;
import com.ibm.etools.struts.emf.strutsconfig.Exception0;
import com.ibm.etools.struts.emf.strutsconfig.FormBean;
import com.ibm.etools.struts.emf.strutsconfig.FormProperty;
import com.ibm.etools.struts.emf.strutsconfig.Forward;
import com.ibm.etools.struts.emf.strutsconfig.MessageResources;
import com.ibm.etools.struts.emf.strutsconfig.Plugin0;
import com.ibm.etools.struts.emf.strutsconfig.SetProperty;
import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import com.ibm.etools.struts.ui.overlay.StrutsCompositeImageDescriptor;
import com.ibm.etools.struts.ui.overlay.StrutsImageInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class StrutsImageWithOverlaysProvider {
    private static final char DELIMITOR = ':';
    private static ImageRegistry imageRegistry = null;
    private static StrutsImageWithOverlaysProvider strutsImageProvider = null;

    private StrutsImageWithOverlaysProvider() {
        imageRegistry = StrutsPlugin.getDefault().getImageRegistry();
    }

    public static final StrutsImageWithOverlaysProvider newInstance() {
        if (strutsImageProvider == null) {
            strutsImageProvider = new StrutsImageWithOverlaysProvider();
        }
        return strutsImageProvider;
    }

    private ImageDescriptor createImageDescriptor(StrutsImageInfo info) {
        return new StrutsCompositeImageDescriptor(info);
    }

    public Image getImage(Object object) {
        String key;
        Image image = null;
        StrutsImageInfo info = null;
        if (object instanceof EObject) {
            info = this.getStrutsImageInfo((EObject)object);
        } else if (object instanceof ILink) {
            info = this.getStrutsImageInfo((ILink)object);
        }
        if (info != null && (image = imageRegistry.get(key = this.getImageKey(info))) == null) {
            imageRegistry.put(key, this.createImageDescriptor(info));
            image = imageRegistry.get(key);
        }
        return image;
    }

    private String getImageKey(StrutsImageInfo info) {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)info.getType());
        builder.append(':');
        builder.append(info.hasExtends());
        builder.append(':');
        builder.append(info.getStatus());
        return builder.toString();
    }

    private StrutsImageInfo getStrutsImageInfo(EObject eo) {
        StrutsCompositeImageDescriptor.StrutsImageType type = null;
        boolean showExtends = false;
        int status = 0;
        IProject project = WorkspaceSynchronizer.getFile((Resource)eo.eResource()).getProject();
        if (eo instanceof ActionMapping) {
            type = new ActionMappingWildcardUtil(project, ((ActionMapping)eo).getPath()).actionHasWildcards() && StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)project) ? StrutsCompositeImageDescriptor.StrutsImageType.WILDCARD_ACTIONMAPPING : StrutsCompositeImageDescriptor.StrutsImageType.ACTIONMAPPING;
            ActionMapping am = (ActionMapping)eo;
            showExtends = am.isSetExtends0() && !"".equals(am.getExtends0());
        } else if (eo instanceof Controller) {
            type = StrutsCompositeImageDescriptor.StrutsImageType.CONTROLLER;
        } else if (eo instanceof DataSource) {
            type = StrutsCompositeImageDescriptor.StrutsImageType.DATASOURCE;
        } else if (eo instanceof Exception0) {
            type = StrutsCompositeImageDescriptor.StrutsImageType.EXCEPTION;
            Exception0 ex = (Exception0)eo;
            showExtends = ex.isSetExtends0() && !"".equals(ex.getExtends0());
        } else if (eo instanceof FormBean) {
            type = StrutsCompositeImageDescriptor.StrutsImageType.FORMBEAN;
            FormBean fb = (FormBean)eo;
            showExtends = fb.isSetExtends0() && !"".equals(fb.getExtends0());
        } else if (eo instanceof FormProperty) {
            type = StrutsCompositeImageDescriptor.StrutsImageType.FORMPROPERTY;
        } else if (eo instanceof Forward) {
            type = StrutsCompositeImageDescriptor.StrutsImageType.FORWARD;
            Forward fd = (Forward)eo;
            showExtends = fd.isSetExtends0() && !"".equals(fd.getExtends0());
        } else {
            type = eo instanceof MessageResources ? StrutsCompositeImageDescriptor.StrutsImageType.MESSAGE : (eo instanceof Plugin0 ? StrutsCompositeImageDescriptor.StrutsImageType.PLUGIN : (eo instanceof SetProperty ? StrutsCompositeImageDescriptor.StrutsImageType.SETPROPERTY : (eo instanceof StrutsConfig ? StrutsCompositeImageDescriptor.StrutsImageType.STRUTSCONFIG : StrutsCompositeImageDescriptor.StrutsImageType.UNKNOWN)));
        }
        if (!StrutsProjectCoreUtil.isStruts1_3((IProject)project)) {
            showExtends = false;
        }
        return new StrutsImageInfo(type, showExtends, status);
    }

    private StrutsImageInfo getStrutsImageInfo(ILink link) {
        StrutsCompositeImageDescriptor.StrutsImageType type = StrutsCompositeImageDescriptor.StrutsImageType.UNKNOWN;
        boolean showExtends = false;
        int status = 0;
        if (link == null) {
            return new StrutsImageInfo(type, showExtends, status);
        }
        IProject project = link.getContainer().getResource().getProject();
        String typeID = link.getSpecializedType().getId();
        if (typeID.equals("struts.action.link")) {
            type = new ActionMappingWildcardUtil(project, link.getName()).actionHasWildcards() && StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)project) ? StrutsCompositeImageDescriptor.StrutsImageType.WILDCARD_ACTIONMAPPING : StrutsCompositeImageDescriptor.StrutsImageType.ACTIONMAPPING;
            ILink extendsLink = StrutsSearchUtil.getActionExtendsLinkForAction((ILink)link);
            if (extendsLink != null) {
                showExtends = (extendsLink = StrutsSearchUtil.getActionTargetForActionExtendsLink((ILink)extendsLink)) != null && !"".equals(extendsLink.getName());
            }
        } else if (typeID.equals("struts.exception.link")) {
            type = StrutsCompositeImageDescriptor.StrutsImageType.EXCEPTION;
            ILink extendsLink = StrutsSearchUtil.getExceptionExtendsLinkForException((ILink)link);
            showExtends = false;
            if (extendsLink != null) {
                showExtends = (extendsLink = StrutsSearchUtil.getJavaTarget((ILink)extendsLink)) != null && !"".equals(extendsLink.getName());
            }
        } else if (typeID.equals("struts.formbean.link") || typeID.equals("struts.actionformbean.link")) {
            ILink extendsLink;
            type = StrutsCompositeImageDescriptor.StrutsImageType.FORMBEAN;
            ILink formBeanLink = link;
            if (typeID.equals("struts.actionformbean.link")) {
                formBeanLink = StrutsSearchUtil.getFormBeanTargetForFormBeanLink((ILink)formBeanLink);
            }
            showExtends = false;
            if (formBeanLink != null && (extendsLink = StrutsSearchUtil.getFormBeanExtendsLinkForFormBean((ILink)formBeanLink)) != null) {
                showExtends = (extendsLink = StrutsSearchUtil.getFormBeanTargetForFormBeanLink((ILink)extendsLink)) != null && !"".equals(extendsLink.getName());
            }
        } else if (typeID.equals("struts.forward.link")) {
            type = StrutsCompositeImageDescriptor.StrutsImageType.FORWARD;
            ILink extendsLink = StrutsSearchUtil.getForwardExtendsLinkForForward((ILink)link);
            if (extendsLink != null) {
                showExtends = (extendsLink = StrutsSearchUtil.getForwardTargetForForwardExtendsLink((ILink)extendsLink)) != null && !"".equals(extendsLink.getName());
            }
        } else {
            type = StrutsCompositeImageDescriptor.StrutsImageType.UNKNOWN;
        }
        if (!StrutsProjectCoreUtil.isStruts1_3((IProject)project)) {
            showExtends = false;
        }
        return new StrutsImageInfo(type, showExtends, status);
    }
}

