/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.treeviewer;

import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.internal.util.StrutsProjectUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.treeviewer.AbstractAction;
import com.ibm.etools.struts.wizards.module.StrutsModuleWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class OpenNewModuleWizardAction
extends AbstractAction {
    private Shell shell;
    private String moduleResult;

    public OpenNewModuleWizardAction(String text, Shell shell) {
        super(text);
        this.shell = shell;
    }

    public OpenNewModuleWizardAction() {
    }

    @Override
    public void run() {
        if (this.component == null) {
            return;
        }
        StrutsModuleWizard wizard = new StrutsModuleWizard();
        IProject project = this.component.getProject();
        if (project == null) {
            return;
        }
        wizard.init(StrutsPlugin.getDefault().getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)project));
        if (this.shell == null) {
            this.shell = Display.getCurrent().getActiveShell();
        }
        WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
        dialog.create();
        dialog.open();
        this.moduleResult = wizard.getConfiguration().getModuleName();
        if (this.moduleResult != null && this.moduleResult.length() > 0 && !this.moduleResult.startsWith("/")) {
            this.moduleResult = "/" + this.moduleResult;
        }
    }

    @Override
    public boolean canActionBeAdded() {
        return this.component != null && this.component.getProject() != null && StrutsProjectUtil.getStrutsVersion((IProject)this.component.getProject()) >= 1;
    }

    @Override
    public String getDefaultActionLabel() {
        return ResourceHandler.WebStructure_action_AddModule;
    }

    public String getResult() {
        return this.moduleResult;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }
}

