/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.treeviewer;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.internal.util.StrutsProjectUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.treeviewer.AbstractAction;
import com.ibm.etools.struts.wizards.exception.StrutsExceptionConfiguration;
import com.ibm.etools.struts.wizards.exception.StrutsExceptionWizard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AddGlobalExceptionAction
extends AbstractAction {
    public AddGlobalExceptionAction(String text, boolean allConfiguredFiles) {
        super(text);
        this.allConfigFiles = allConfiguredFiles;
    }

    public AddGlobalExceptionAction() {
        this.allConfigFiles = false;
    }

    @Override
    public void run() {
        StrutsExceptionWizard wizard = new StrutsExceptionWizard();
        ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        IFile file = this.getStrutsConfigFile(sel);
        StructuredSelection ss = file != null ? new StructuredSelection((Object)file) : this.getInitSelection();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)ss);
        StrutsExceptionConfiguration configs = wizard.getConfiguration();
        configs.setContextGlobal(true);
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private IFile getStrutsConfigFile(ISelection sel) {
        Object obj = null;
        if (sel instanceof TreeSelection) {
            obj = ((TreeSelection)sel).getFirstElement();
            IFile file = (IFile)Platform.getAdapterManager().getAdapter(obj, IFile.class);
            if (file != null) {
                LinkNode files = ReferenceManager.getReferenceManager().getLinkNode(file);
                try {
                    Collection links = files.getLinks(ReferenceManager.getReferenceManager().getLinkType("struts.config.nodeid"), SpecializedType.Depth.ZERO, null);
                    if (!links.isEmpty()) {
                        return file;
                    }
                }
                catch (ReferenceException referenceException) {
                    return null;
                }
            }
        }
        return null;
    }

    private StructuredSelection getInitSelection() {
        ArrayList<IFile> files = new ArrayList<IFile>();
        Set configFiles = new HashSet();
        try {
            configFiles = StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)this.component.getProject(), (String)this.module, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ReferenceException e) {
            StrutsPlugin.getLogger().log((Throwable)e);
        }
        for (ILink cf : configFiles) {
            files.add((IFile)Platform.getAdapterManager().getAdapter((Object)cf.getContainer().getResource(), IFile.class));
        }
        if (files.size() > 0) {
            return new StructuredSelection(files.get(0));
        }
        return new StructuredSelection((Object)this.component.getProject());
    }

    @Override
    public boolean canActionBeAdded() {
        return this.component != null && this.component.getProject() != null && StrutsProjectUtil.isStruts1_1OrHigher((IProject)this.component.getProject());
    }

    @Override
    public String getDefaultActionLabel() {
        return ResourceHandler.WebStructure_action_AddGlobalException;
    }

    public boolean isEnabled() {
        return this.component != null;
    }
}

