/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.treeviewer;

import com.ibm.etools.struts.treeviewer.ILinkAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public abstract class AbstractActionGroup
extends ActionGroup {
    protected ILinkAction[] actions;
    private boolean inited;

    public void fillContextMenu(IMenuManager menu) {
        this.init();
        this.initActionContext();
        IContributionItem item = menu.find("additions");
        boolean nullItem = item == null;
        int i = 0;
        while (i < this.getNumActions()) {
            if (this.actions[i].canActionBeAdded()) {
                if (nullItem) {
                    menu.add((IAction)this.actions[i]);
                } else {
                    menu.insertBefore("additions", (IAction)this.actions[i]);
                }
            }
            ++i;
        }
    }

    private void init() {
        if (!this.inited) {
            this.actions = this.initActions();
            if (this.actions == null) {
                this.actions = new ILinkAction[0];
            }
            this.inited = true;
        }
    }

    private void initActionContext() {
        String moduleName = (String)this.getContext().getInput();
        this.setModuleForAction(moduleName);
    }

    private void setModuleForAction(String module) {
        if (module == null) {
            return;
        }
        int i = 0;
        while (i < this.getNumActions()) {
            this.actions[i].setModule(module);
            ++i;
        }
    }

    public void setComponent(IVirtualComponent component) {
        if (component == null) {
            return;
        }
        this.init();
        int i = 0;
        while (i < this.getNumActions()) {
            if (this.actions[i] != null) {
                this.actions[i].setComponent(component);
            }
            ++i;
        }
    }

    protected abstract ILinkAction[] initActions();

    protected abstract int getNumActions();
}

