/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.validator;

import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.emf.strutsconfig.Controller;
import com.ibm.etools.struts.emf.strutsconfig.DataSource;
import com.ibm.etools.struts.emf.strutsconfig.Exception0;
import com.ibm.etools.struts.emf.strutsconfig.FormBean;
import com.ibm.etools.struts.emf.strutsconfig.Forward;
import com.ibm.etools.struts.emf.strutsconfig.MessageResources;
import com.ibm.etools.struts.emf.strutsconfig.Plugin0;
import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import com.ibm.etools.struts.strutsconfig.validator.StrutsConfigPartsComparator;
import com.ibm.etools.struts.strutsconfig.validator.StrutsConfigPartsUtil;
import com.ibm.etools.struts.util.StrutsArtifactEdit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ModelReaderForStrutsConfigValidation {
    private EObject[] currentSearchContext;
    private EObject[] formBeans;
    private EObject[] actionMappings;
    private EObject[] dataSources;
    private EObject[] globalForwards;
    private EObject[] defaultActionMappings;
    private EObject[] controllers;
    private EObject[] exceptions;
    private EObject[] messageResources;
    private EObject[] plugins;
    private IFile[] scFiles;
    private HashMap fileToModelMap;

    public ModelReaderForStrutsConfigValidation(IFile[] files) {
        this.scFiles = files;
        this.fileToModelMap = null;
    }

    private void initModelToFileMap() {
        this.fileToModelMap = new HashMap();
        if (this.scFiles == null || this.scFiles.length == 0) {
            return;
        }
        int i = 0;
        while (i < this.scFiles.length) {
            Object oldFile;
            IFile file = this.scFiles[i];
            if (file != null && (oldFile = this.fileToModelMap.get(file)) == null) {
                StrutsArtifactEdit strutsArtifactEdit = StrutsArtifactEdit.getStrutsArtifactEditForRead(file);
                this.fileToModelMap.put(file, strutsArtifactEdit);
            }
            ++i;
        }
    }

    private void clearHashedInformation() {
        this.currentSearchContext = null;
        this.formBeans = null;
        this.actionMappings = null;
        this.dataSources = null;
        this.globalForwards = null;
        this.defaultActionMappings = null;
        this.controllers = null;
        this.exceptions = null;
        this.messageResources = null;
        this.plugins = null;
    }

    public void releaseAllModels() {
        if (this.fileToModelMap == null || this.fileToModelMap.keySet() == null) {
            return;
        }
        this.clearHashedInformation();
        for (StrutsArtifactEdit strutsArtifactEdit : this.fileToModelMap.values()) {
            if (strutsArtifactEdit == null) continue;
            strutsArtifactEdit.dispose();
        }
        this.fileToModelMap.clear();
        this.fileToModelMap = null;
    }

    public boolean hasDuplicateActionMapping(EObject actionMapping) {
        if (StrutsConfigPartsUtil.getUniqueNameForActionMapping((ActionMapping)actionMapping) == null) {
            return false;
        }
        this.setCurrentSearchContext(this.getActionMappings());
        return this.hasDuplicateNamedEntry(actionMapping, 0);
    }

    public boolean hasDuplicateDataSource(EObject dataSource) {
        if (StrutsConfigPartsUtil.getUniqueNameForDataSource((DataSource)dataSource) == null) {
            return false;
        }
        this.setCurrentSearchContext(this.getDataSources());
        return this.hasDuplicateNamedEntry(dataSource, 2);
    }

    public boolean hasDuplicateFormBean(EObject bean) {
        if (StrutsConfigPartsUtil.getUniqueNameForFormBean((FormBean)bean) == null) {
            return false;
        }
        this.setCurrentSearchContext(this.getFormBeans());
        return this.hasDuplicateNamedEntry(bean, 4);
    }

    public boolean hasDuplicateGlobalForward(EObject forward) {
        if (StrutsConfigPartsUtil.getUniqueNameForForward((Forward)forward) == null) {
            return false;
        }
        this.setCurrentSearchContext(this.getGlobalForwards());
        return this.hasDuplicateNamedEntry(forward, 5);
    }

    public boolean hasDuplicateDefaultActionMapping() {
        return this.getDefaultActionMappings().length > 1;
    }

    public boolean hasDuplicateController(EObject controller) {
        if (StrutsConfigPartsUtil.getUniqueNameForController((Controller)controller) == null) {
            return false;
        }
        this.setCurrentSearchContext(this.getControllers());
        return this.hasDuplicateNamedEntry(controller, 10);
    }

    public boolean hasDuplicateException(EObject exception) {
        if (StrutsConfigPartsUtil.getUniqueNameForException((Exception0)exception) == null) {
            return false;
        }
        this.setCurrentSearchContext(this.getExceptions());
        return this.hasDuplicateNamedEntry(exception, 8);
    }

    public boolean hasDuplicateMessageResource(EObject messageResource) {
        if (StrutsConfigPartsUtil.getUniqueNameForMessageResources((MessageResources)messageResource) == null) {
            return false;
        }
        this.setCurrentSearchContext(this.getMessageResources());
        return this.hasDuplicateNamedEntry(messageResource, 11);
    }

    public boolean hasDuplicatePlugin(EObject plugin) {
        if (StrutsConfigPartsUtil.getUniqueNameForPlugin((Plugin0)plugin) == null) {
            return false;
        }
        this.setCurrentSearchContext(this.getPlugins());
        return this.hasDuplicateNamedEntry(plugin, 12);
    }

    public boolean isFormBeanInImage(String beanName) {
        this.setCurrentSearchContext(this.getFormBeans());
        return this.isNamedRefObjectInContext(beanName);
    }

    private boolean isNamedRefObjectInContext(String key) {
        Comparator comparator = StrutsConfigPartsComparator.getStringObjectNameComparator();
        EObject[] searchList = this.getCurrentSearchContext();
        int i = Arrays.binarySearch(searchList, key, comparator);
        return i >= 0;
    }

    private boolean hasDuplicateNamedEntry(EObject key, int type) {
        Comparator comparator = StrutsConfigPartsComparator.getComparatorForType(type);
        EObject[] searchList = this.getCurrentSearchContext();
        int i = Arrays.binarySearch(searchList, key, comparator);
        if (i >= 0) {
            int index = i + 1;
            if (index < searchList.length && comparator.compare(key, searchList[index]) == 0) {
                return true;
            }
            index = i - 1;
            if (index >= 0 && comparator.compare(key, searchList[index]) == 0) {
                return true;
            }
        }
        return false;
    }

    private void setCurrentSearchContext(EObject[] set) {
        this.currentSearchContext = set;
    }

    private EObject[] getCurrentSearchContext() {
        return this.currentSearchContext;
    }

    private EObject[] getFormBeans() {
        if (this.formBeans == null) {
            this.formBeans = this.getSortedRefObjectsFor(4);
        }
        return this.formBeans;
    }

    private EObject[] getActionMappings() {
        if (this.actionMappings == null) {
            this.actionMappings = this.getSortedRefObjectsFor(0);
        }
        return this.actionMappings;
    }

    private EObject[] getDataSources() {
        if (this.dataSources == null) {
            this.dataSources = this.getSortedRefObjectsFor(2);
        }
        return this.dataSources;
    }

    private EObject[] getGlobalForwards() {
        if (this.globalForwards == null) {
            this.globalForwards = this.getSortedRefObjectsFor(5);
        }
        return this.globalForwards;
    }

    private EObject[] getControllers() {
        if (this.controllers == null) {
            this.controllers = this.getSortedRefObjectsFor(10);
        }
        return this.controllers;
    }

    private EObject[] getExceptions() {
        if (this.exceptions == null) {
            this.exceptions = this.getSortedRefObjectsFor(8);
        }
        return this.exceptions;
    }

    private EObject[] getMessageResources() {
        if (this.messageResources == null) {
            this.messageResources = this.getSortedRefObjectsFor(11);
        }
        return this.messageResources;
    }

    private EObject[] getPlugins() {
        if (this.plugins == null) {
            this.plugins = this.getSortedRefObjectsFor(12);
        }
        return this.plugins;
    }

    private EObject[] getSortedRefObjectsFor(int type) {
        ArrayList list = this.getRefObjectsFor(type);
        EObject[] arrayList = list.toArray(new EObject[list.size()]);
        Comparator comparator = StrutsConfigPartsComparator.getComparatorForType(type);
        Arrays.sort(arrayList, comparator);
        return arrayList;
    }

    private ArrayList getRefObjectsFor(int type) {
        if (this.fileToModelMap == null) {
            this.initModelToFileMap();
        }
        if (10 == type) {
            return this.getControllerList(this.fileToModelMap);
        }
        ArrayList list = new ArrayList();
        for (StrutsArtifactEdit model : this.fileToModelMap.values()) {
            EList elist = this.getList(type, model.getStrutsConfig());
            if (elist == null) continue;
            list.addAll(elist);
        }
        return list;
    }

    private ArrayList getControllerList(HashMap fileToModelMap) {
        ArrayList<Controller> list = new ArrayList<Controller>();
        Iterator iter = fileToModelMap.values().iterator();
        while (iter.hasNext()) {
            Controller controller;
            StrutsConfig config = ((StrutsArtifactEdit)((Object)iter.next())).getStrutsConfig();
            if (config == null || (controller = config.getController()) == null) continue;
            list.add(controller);
        }
        return list;
    }

    private EList getList(int type, StrutsConfig model) {
        if (model != null) {
            switch (type) {
                case 0: {
                    return model.getActionMappings();
                }
                case 4: {
                    return model.getFormBeans();
                }
                case 5: {
                    return model.getGlobalForwards();
                }
                case 2: {
                    return model.getDataSources();
                }
                case 8: {
                    return model.getGlobalExceptions();
                }
                case 11: {
                    return model.getMessageResources();
                }
                case 12: {
                    return model.getPlugins();
                }
            }
        }
        return null;
    }

    private EObject[] getDefaultActionMappings() {
        if (this.defaultActionMappings != null) {
            return this.defaultActionMappings;
        }
        EObject[] list = this.getActionMappings();
        if (list != null && list.length > 0) {
            ArrayList<ActionMapping> matchedList = new ArrayList<ActionMapping>();
            int i = 0;
            while (i < list.length) {
                ActionMapping action = (ActionMapping)list[i];
                if (action.isSetDefault() && action.isDefault()) {
                    matchedList.add(action);
                }
                ++i;
            }
            this.defaultActionMappings = matchedList.isEmpty() ? new ActionMapping[]{} : matchedList.toArray(new ActionMapping[matchedList.size()]);
        } else {
            this.defaultActionMappings = new ActionMapping[0];
        }
        return this.defaultActionMappings;
    }

    public ArrayList<ActionMapping> getDefaultActionMappingsForFile(IFile file) {
        EObject[] defaultMappings = this.getDefaultActionMappings();
        if (defaultMappings.length == 0) {
            return null;
        }
        StrutsArtifactEdit model = this.getEditModelFromFile(file);
        StrutsConfig modelMof = model.getStrutsConfig();
        if (modelMof == null) {
            return null;
        }
        EList<ActionMapping> actionMappings = model.getStrutsConfig().getActionMappings();
        if (actionMappings == null || actionMappings.size() == 0) {
            return null;
        }
        ArrayList<ActionMapping> matchedList = new ArrayList<ActionMapping>();
        int i = 0;
        while (i < defaultMappings.length) {
            if (actionMappings.contains((Object)defaultMappings[i])) {
                matchedList.add((ActionMapping)defaultMappings[i]);
            }
            ++i;
        }
        return matchedList.isEmpty() ? null : matchedList;
    }

    private StrutsArtifactEdit getEditModelFromFile(IFile file) {
        if (file == null) {
            return null;
        }
        if (this.fileToModelMap == null) {
            this.initModelToFileMap();
        }
        return (StrutsArtifactEdit)((Object)this.fileToModelMap.get(file));
    }
}

