/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.validator;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.struts.cache.SubClassLookupCache;
import com.ibm.etools.struts.configFile.id.contributions.ConfigFileIdentifierQuizMaster;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.emf.strutsconfig.Forward;
import com.ibm.etools.struts.emf.strutsconfig.SetProperty;
import com.ibm.etools.struts.strutsconfig.validator.DisplayableSetPropertyValidator;
import com.ibm.etools.struts.strutsconfig.validator.ModelReaderForStrutsConfigValidation;
import com.ibm.etools.struts.strutsconfig.validator.SetPropertyValidator;
import com.ibm.etools.struts.strutsconfig.validator.StrutsConfigPartsUtil;
import com.ibm.etools.struts.strutsconfig.validator.ValidateMessageCollector;
import com.ibm.etools.struts.strutsconfig.validator.ValidateMessageItem;
import com.ibm.etools.struts.strutsconfig.validator.ValidateUtil;
import com.ibm.etools.struts.strutsconfig.validator.WildcardSetPropertyValidator;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ForwardValidator
extends DisplayableSetPropertyValidator {
    private static final String CATALOG = "catalog";
    private static final String CLASS_NAME = "className";
    private static final String COMMAND = "command";
    public static String DFT_FORWARD_CLSNAME = "org.apache.struts.action.ActionForward";
    private static final String MODULE = "module";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private Forward currentForward;
    private WildcardSetPropertyValidator wcSetPropertyValidator;
    private ActionMappingWildcardUtil wildCardValidatorUtil = null;

    public ForwardValidator(IFile file, ModelReaderForStrutsConfigValidation reader, SubClassLookupCache cache) {
        super(file, reader, cache);
        this.wcSetPropertyValidator = new WildcardSetPropertyValidator(file, reader, cache);
    }

    @Override
    protected String getUniqueKeyString(EObject refObject) {
        return StrutsConfigPartsUtil.getUniqueNameForForward((Forward)refObject);
    }

    @Override
    public boolean hasDuplicateInImage(EObject strutsMofPart) {
        return this.getReader().hasDuplicateGlobalForward(strutsMofPart);
    }

    public boolean isLocalForward(EObject forward) {
        if (forward == null) {
            return false;
        }
        return forward.eContainer() instanceof ActionMapping;
    }

    private void validateAttributeTokens(String attributeName, String attributeValue, Forward forward, ValidateMessageCollector problemCollector) {
        if (StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)this.project) && this.isLocalForward(forward) && this.wildCardValidatorUtil.isNumberOfWildcardsValid()) {
            if (!this.wildCardValidatorUtil.actionHasWildcards() && this.wildCardValidatorUtil.attributeHasTokens(attributeValue)) {
                this.addProblems(problemCollector, ValidateMessageItem.getAttributeTokenUseInAMWithNoWildcardsMessageItem(forward, attributeName, attributeValue));
            } else if (this.wildCardValidatorUtil.actionHasWildcards() && !this.wildCardValidatorUtil.isAttributeTokenUseValid(attributeValue)) {
                this.addProblems(problemCollector, ValidateMessageItem.getInvalidParameterTokenInAMAttributeMessageItem(forward, attributeName, attributeValue, String.valueOf(this.wildCardValidatorUtil.getNumberWildcards())));
            }
        }
    }

    private void validateCatalog(Forward forward, ValidateMessageCollector problemCollector) {
        if (forward.isSetCatalog() && StrutsProjectCoreUtil.isStruts1_3((IProject)this.project)) {
            this.validateAttributeTokens(CATALOG, forward.getCatalog(), forward, problemCollector);
        }
    }

    private void validateClassNames(SubClassLookupCache cache, Forward forward, NamedNodeMap map, ValidateMessageCollector problemCollector) {
        String className;
        if (forward.isSetClassName() && !ForwardValidator.isValidSubclass(cache, className = ForwardValidator.getRawData(map, CLASS_NAME, forward.getClassName()), DFT_FORWARD_CLSNAME)) {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidSubClassTypeMessageItem(forward, CLASS_NAME, className, DFT_FORWARD_CLSNAME));
        }
    }

    private void validateCommand(Forward forward, ValidateMessageCollector problemCollector) {
        if (forward.isSetCommand() && StrutsProjectCoreUtil.isStruts1_3((IProject)this.project)) {
            this.validateAttributeTokens(COMMAND, forward.getPath(), forward, problemCollector);
        }
    }

    public void validateDuplicateForLocalForwards(EList localForwards, ValidateMessageCollector collector) {
        this.validateDuplicatefromList(localForwards, collector);
        SetPropertyValidator validator = this.getSetPropertyValidator();
        for (Forward localForward : localForwards) {
            validator.validateDuplicate(localForward.getSetProperties(), collector);
        }
    }

    public void validateField(EList mofList, ValidateMessageCollector collector, ActionMappingWildcardUtil wcValidator) {
        if (mofList == null || mofList.isEmpty() || collector == null) {
            return;
        }
        Iterator mofIter = mofList.iterator();
        while (mofIter.hasNext()) {
            this.validateField((EObject)mofIter.next(), collector, wcValidator);
        }
    }

    @Override
    public void validateField(EObject strutsMofPart, ValidateMessageCollector problemCollector) {
        super.validateField(strutsMofPart, problemCollector);
        Forward forward = (Forward)strutsMofPart;
        Node forwardNode = ForwardValidator.getNode((Notifier)forward);
        NamedNodeMap map = forwardNode == null ? null : forwardNode.getAttributes();
        this.validateName(forward, map, problemCollector);
        this.validateClassNames(this.getCache(), forward, map, problemCollector);
        if (StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)this.project)) {
            this.validateModule(forward, problemCollector);
        }
        if (StrutsProjectCoreUtil.isStruts1_3((IProject)this.project)) {
            super.validateExtendsAttribute(forward, problemCollector);
            this.validateCatalog(forward, problemCollector);
            this.validateCommand(forward, problemCollector);
        }
    }

    public void validateField(EObject strutsMofPart, ValidateMessageCollector problemCollector, ActionMappingWildcardUtil wcValidator) {
        if (this.isLocalForward(strutsMofPart)) {
            ActionMapping currentAction = (ActionMapping)((Forward)strutsMofPart).eContainer();
            this.wildCardValidatorUtil = wcValidator;
            this.wcSetPropertyValidator.setAction(currentAction);
            this.wcSetPropertyValidator.setWildcardUtil(this.wildCardValidatorUtil);
            this.currentForward = (Forward)strutsMofPart;
        }
        this.validateField(strutsMofPart, problemCollector);
        if (StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)this.project)) {
            this.validatePath((Forward)strutsMofPart, problemCollector, wcValidator);
        }
    }

    private void validateModule(Forward forward, ValidateMessageCollector problemCollector) {
        String module = forward.getModule();
        boolean contextRelative = forward.isContextRelative();
        if (StrutsProjectCoreUtil.isStruts1_2((IProject)this.getFile().getProject()) && module != null && module.trim().length() > 0 && contextRelative) {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidContextRelativeWithModuleMessageItem(forward));
        }
        String[] moduleNames = ConfigFileIdentifierQuizMaster.getAllConfiguredStrutsModuleNamesForComponent(Model2Util.findComponent((IResource)this.getFile().getProject()));
        if (module != null && module.trim().length() > 0) {
            boolean moduleExists = false;
            String[] stringArray = moduleNames;
            int n = moduleNames.length;
            int n2 = 0;
            while (n2 < n) {
                String currentModule = stringArray[n2];
                if (currentModule.equals(module)) {
                    moduleExists = true;
                    break;
                }
                ++n2;
            }
            if (!moduleExists) {
                this.addProblems(problemCollector, ValidateMessageItem.getModuleDoesNotExistMessageItem(forward, MODULE, module));
            }
            if (!ValidateUtil.isBeginsWithSlash(module)) {
                this.addProblems(problemCollector, ValidateMessageItem.getModuleDoesNotBeginWithSlashMessageItem(forward, MODULE, module));
            }
        }
    }

    private void validateName(Forward forward, NamedNodeMap map, ValidateMessageCollector problemCollector) {
        String name;
        if (forward.isSetName() && ValidateUtil.isStringContainWhiteSpace(name = ForwardValidator.getRawData(map, NAME, forward.getName()))) {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidForwardPathMessageItem(forward, NAME, name));
        }
    }

    private void validatePath(Forward forward, ValidateMessageCollector problemCollector, ActionMappingWildcardUtil wcValidator) {
        if (forward.isSetPath()) {
            this.validateAttributeTokens(PATH, forward.getPath(), forward, problemCollector);
        }
    }

    @Override
    protected void validateProperties(EList<SetProperty> properties, ValidateMessageCollector problemCollector) {
        if (properties != null && !properties.isEmpty()) {
            if (StrutsProjectCoreUtil.isStruts1_3((IProject)this.project) && this.isLocalForward(this.currentForward) && this.wcSetPropertyValidator != null && this.wildCardValidatorUtil != null) {
                for (SetProperty p : properties) {
                    this.wcSetPropertyValidator.validateField(p, problemCollector);
                }
            } else {
                super.validateProperties(properties, problemCollector);
            }
        }
    }

    private void addProblems(ValidateMessageCollector problemCollector, ValidateMessageItem msg) {
        msg.setAttribute("TargetResource", this.getFile());
        problemCollector.addItem(msg);
    }
}

