/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.validator;

import com.ibm.etools.struts.cache.SubClassLookupCache;
import com.ibm.etools.struts.emf.strutsconfig.FormBean;
import com.ibm.etools.struts.emf.strutsconfig.FormProperty;
import com.ibm.etools.struts.internal.util.StrutsProjectUtil;
import com.ibm.etools.struts.strutsconfig.validator.DisplayableSetPropertyValidator;
import com.ibm.etools.struts.strutsconfig.validator.FormPropertyValidator;
import com.ibm.etools.struts.strutsconfig.validator.ModelReaderForStrutsConfigValidation;
import com.ibm.etools.struts.strutsconfig.validator.StrutsConfigPartsUtil;
import com.ibm.etools.struts.strutsconfig.validator.ValidateMessageCollector;
import com.ibm.etools.struts.strutsconfig.validator.ValidateMessageItem;
import com.ibm.etools.struts.strutsconfig.validator.ValidateUtil;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FormBeanValidator
extends DisplayableSetPropertyValidator {
    public static final String CLASS_NAME = "className";
    public static final String DFT_FB_CLSNAME = "org.apache.struts.action.ActionFormBean";
    public static final String DFT_FB_CLSNAME_1_1 = "org.apache.struts.config.FormBeanConfig";
    public static final String DFT_FB_TYPE = "org.apache.struts.action.ActionForm";
    private static final String DYNA_ACTIONFORM = "org.apache.struts.action.DynaActionForm";
    public static final String DYNAMIC = "dynamic";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    private FormPropertyValidator localFormPropertyValidator;

    public FormBeanValidator(IFile file, ModelReaderForStrutsConfigValidation reader, SubClassLookupCache cache) {
        super(file, reader, cache);
        if (StrutsProjectUtil.isStruts1_1OrHigher((IProject)this.project)) {
            this.localFormPropertyValidator = this.createFormPropertyValidator(file, reader, cache);
        }
    }

    public static boolean isDynaForm(SubClassLookupCache cache, String class1) {
        return FormBeanValidator.isValidSubclass(cache, class1, DYNA_ACTIONFORM);
    }

    private void validateName(FormBean bean, NamedNodeMap map, ValidateMessageCollector problemCollector) {
        String name;
        if (bean.isSetName() && !ValidateUtil.isValidBeanName(name = FormBeanValidator.getRawData(map, NAME, bean.getName()))) {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidBeanNameMessageItem(bean, NAME, name));
        }
    }

    protected FormPropertyValidator createFormPropertyValidator(IFile file, ModelReaderForStrutsConfigValidation reader, SubClassLookupCache cache) {
        return new FormPropertyValidator(file, reader, cache);
    }

    public String getRequiredSubClass(String attrib) {
        if (attrib == null || attrib.length() == 0) {
            return null;
        }
        if (attrib.equals(TYPE)) {
            return DFT_FB_TYPE;
        }
        if (attrib.equals(CLASS_NAME)) {
            if (StrutsProjectUtil.isStruts1_1OrHigher((IProject)this.project)) {
                return DFT_FB_CLSNAME_1_1;
            }
            return DFT_FB_CLSNAME;
        }
        return null;
    }

    @Override
    protected String getUniqueKeyString(EObject refObject) {
        return StrutsConfigPartsUtil.getUniqueNameForFormBean((FormBean)refObject);
    }

    @Override
    public boolean hasDuplicateInImage(EObject strutsMofPart) {
        return this.getReader().hasDuplicateFormBean(strutsMofPart);
    }

    @Override
    public void validateDuplicate(EList formBeans, ValidateMessageCollector problemCollector) {
        super.validateDuplicate(formBeans, problemCollector);
        if (StrutsProjectUtil.isStruts1_1OrHigher((IProject)this.project)) {
            Iterator iter = formBeans.iterator();
            while (iter.hasNext()) {
                EList<FormProperty> list = ((FormBean)iter.next()).getFormProperties();
                if (list == null || list.isEmpty()) continue;
                this.localFormPropertyValidator.validateDuplicateForLocalFormProperties(list, problemCollector);
            }
        }
    }

    @Override
    public void validateDuplicate(EObject refObject, ValidateMessageCollector problemCollector) {
        super.validateDuplicate(refObject, problemCollector);
        if (StrutsProjectUtil.isStruts1_1OrHigher((IProject)this.project)) {
            EList<FormProperty> list = ((FormBean)refObject).getFormProperties();
            if (list == null || list.isEmpty()) {
                return;
            }
            this.localFormPropertyValidator.validateDuplicateForLocalFormProperties(list, problemCollector);
        }
    }

    private void validateDynamicFormProperties(SubClassLookupCache cache, FormBean bean, NamedNodeMap map, ValidateMessageCollector problemCollector) {
        EList<FormProperty> list = bean.getFormProperties();
        if (list == null || list.isEmpty()) {
            return;
        }
        if (bean.isSetType()) {
            String className = FormBeanValidator.getRawData(map, TYPE, bean.getType());
            if (!FormBeanValidator.isDynaForm(cache, className)) {
                this.addProblems(problemCollector, ValidateMessageItem.getInvalidFormPropertyMessageItem(bean, TYPE, className));
            }
        } else {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidFormPropertyMessageItem(bean, TYPE, ""));
        }
        this.localFormPropertyValidator.validateField(list, problemCollector);
    }

    @Override
    public void validateField(EObject container, ValidateMessageCollector problemCollector) {
        super.validateField(container, problemCollector);
        FormBean bean = (FormBean)container;
        Node beanNode = FormBeanValidator.getNode((Notifier)bean);
        NamedNodeMap map = beanNode == null ? null : beanNode.getAttributes();
        this.validateName(bean, map, problemCollector);
        this.validateSubClass(this.getCache(), bean, map, problemCollector);
        if (StrutsProjectUtil.isStruts1_1OrHigher((IProject)this.project)) {
            this.validateDynamicFormProperties(this.getCache(), bean, map, problemCollector);
        }
        if (StrutsProjectUtil.isStruts1_3((IProject)this.project)) {
            super.validateExtendsAttribute(bean, problemCollector);
        }
    }

    @Override
    public void validateReferences(EObject strutsMofPart, ValidateMessageCollector problemCollector) {
        super.validateReferences(strutsMofPart, problemCollector);
    }

    @Override
    public void validateRequirement(EObject container, ValidateMessageCollector problemCollector) {
        super.validateRequirement(container, problemCollector);
    }

    private void validateSubClass(SubClassLookupCache cache, FormBean bean, NamedNodeMap map, ValidateMessageCollector problemCollector) {
        String className;
        if (bean.isSetClassName() && !FormBeanValidator.isValidSubclass(cache, className = FormBeanValidator.getRawData(map, CLASS_NAME, bean.getClassName()), this.getRequiredSubClass(CLASS_NAME))) {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidSubClassTypeMessageItem(bean, CLASS_NAME, className, this.getRequiredSubClass(CLASS_NAME)));
        }
        if (bean.isSetType() && !FormBeanValidator.isValidSubclass(cache, className = FormBeanValidator.getRawData(map, TYPE, bean.getType()), this.getRequiredSubClass(TYPE))) {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidSubClassTypeMessageItem(bean, TYPE, className, this.getRequiredSubClass(TYPE)));
        }
    }

    private void addProblems(ValidateMessageCollector problemCollector, ValidateMessageItem msg) {
        msg.setAttribute("TargetResource", this.getFile());
        problemCollector.addItem(msg);
    }
}

