/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.validator;

import com.ibm.etools.struts.cache.SubClassLookupCache;
import com.ibm.etools.struts.strutsconfig.validator.ModelReaderForStrutsConfigValidation;
import com.ibm.etools.struts.strutsconfig.validator.ValidateMessage;
import com.ibm.etools.struts.strutsconfig.validator.ValidateMessageCollector;
import com.ibm.etools.struts.strutsconfig.validator.ValidateMessageItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractStrutsConfigValidator {
    protected IProject project;
    private SubClassLookupCache cache;
    private ModelReaderForStrutsConfigValidation reader;
    private IFile validatingFile;

    public AbstractStrutsConfigValidator(IFile file, ModelReaderForStrutsConfigValidation reader, SubClassLookupCache cache) {
        this.validatingFile = file;
        this.project = this.validatingFile.getProject();
        this.reader = reader;
        this.cache = cache;
    }

    public static void addArrayList(ArrayList source, ArrayList addition) {
        if (addition != null) {
            source.addAll(addition);
        }
    }

    public static Node getNode(Notifier notifier) {
        EMF2DOMAdapter domAdapter;
        if (notifier != null && (domAdapter = (EMF2DOMAdapter)EcoreUtil.getAdapter((List)notifier.eAdapters(), (Object)EMF2DOMAdapter.ADAPTER_CLASS)) != null) {
            return domAdapter.getNode();
        }
        return null;
    }

    public static String getRawData(NamedNodeMap map, String attrib, String defaultReturn) {
        Node node;
        if (map != null && (node = map.getNamedItem(attrib)) != null) {
            return node.getNodeValue();
        }
        return defaultReturn;
    }

    public static boolean isValidSubclass(SubClassLookupCache cache, String subclass, String parentClass) {
        return cache.isSubclass(subclass, parentClass);
    }

    public ArrayList buildDuplicateProblemListForParts(ArrayList partList, ValidateMessage message) {
        String attribute = "";
        String attributeValue = "";
        return this.buildDuplicateProblemListForParts(partList, message, attribute, attributeValue);
    }

    public ArrayList buildDuplicateProblemListForParts(ArrayList partList, ValidateMessage message, String attribute, String attributeValue) {
        ArrayList<ValidateMessageItem> problemList = new ArrayList<ValidateMessageItem>();
        int i = 0;
        while (i < partList.size()) {
            ValidateMessageItem msg = new ValidateMessageItem(message, (EObject)partList.get(i), attribute, attributeValue);
            msg.setAttribute("TargetResource", this.getFile());
            problemList.add(msg);
            ++i;
        }
        return problemList;
    }

    public SubClassLookupCache getCache() {
        return this.cache;
    }

    public IFile getFile() {
        return this.validatingFile;
    }

    public ModelReaderForStrutsConfigValidation getReader() {
        return this.reader;
    }

    public abstract boolean hasDuplicateInImage(EObject var1);

    public void validate(int startLevel, EList mofList, ValidateMessageCollector collector) {
        if (mofList == null || mofList.isEmpty()) {
            return;
        }
        switch (startLevel) {
            case 0: {
                this.validateField(mofList, collector);
            }
            case 1: {
                this.validateRequirement(mofList, collector);
            }
            case 2: {
                this.validateDuplicate(mofList, collector);
            }
        }
    }

    public void validate(int startLevel, EObject mof, ValidateMessageCollector collector) {
        if (mof == null) {
            return;
        }
        switch (startLevel) {
            case 0: {
                this.validateField(mof, collector);
            }
            case 1: {
                this.validateRequirement(mof, collector);
            }
            case 2: {
                this.validateDuplicate(mof, collector);
            }
        }
    }

    public abstract void validateDuplicate(EList var1, ValidateMessageCollector var2);

    public abstract void validateDuplicate(EObject var1, ValidateMessageCollector var2);

    public void validateDuplicatefromList(EList list, ValidateMessageCollector collector) {
        ArrayList duplicateObjectList = this.findDuplicateObjects(list);
        if (duplicateObjectList.size() > 0) {
            collector.addItems(this.buildDuplicateProblemListForParts(duplicateObjectList, ValidateMessage.DUPLICATE));
        }
    }

    public void validateField(EList mofList, ValidateMessageCollector collector) {
        if (mofList == null || mofList.isEmpty() || collector == null) {
            return;
        }
        Iterator mofIter = mofList.iterator();
        while (mofIter.hasNext()) {
            this.validateField((EObject)mofIter.next(), collector);
        }
    }

    public abstract void validateField(EObject var1, ValidateMessageCollector var2);

    public void validateReferences(EList mofList, ValidateMessageCollector collector) {
        if (mofList == null || mofList.isEmpty() || collector == null) {
            return;
        }
        Iterator mofIter = mofList.iterator();
        while (mofIter.hasNext()) {
            this.validateReferences((EObject)mofIter.next(), collector);
        }
    }

    public abstract void validateReferences(EObject var1, ValidateMessageCollector var2);

    public void validateRequirement(EList mofList, ValidateMessageCollector collector) {
        if (mofList == null || mofList.isEmpty() || collector == null) {
            return;
        }
        Iterator mofIter = mofList.iterator();
        while (mofIter.hasNext()) {
            this.validateRequirement((EObject)mofIter.next(), collector);
        }
    }

    public abstract void validateRequirement(EObject var1, ValidateMessageCollector var2);

    protected final ArrayList findDuplicateObjects(EList refObjects) {
        if (refObjects == null) {
            return null;
        }
        HashMap<String, Vector<EObject>> duplicateSet = new HashMap<String, Vector<EObject>>();
        for (EObject refObject : refObjects) {
            String key = this.getUniqueKeyString(refObject);
            if (key == null) continue;
            Vector list = (Vector)duplicateSet.get(key);
            if (list == null) {
                list = new Vector();
                duplicateSet.put(key, list);
            }
            list.add(refObject);
        }
        ArrayList<EObject> duplicateList = new ArrayList<EObject>();
        for (Vector list : duplicateSet.values()) {
            if (list.size() <= 1) continue;
            duplicateList.addAll(list);
        }
        return duplicateList;
    }

    protected abstract String getUniqueKeyString(EObject var1);
}

