/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.presentation.vieweradapters;

import com.ibm.etools.emf.workbench.ui.listeners.IValidateEditListener;
import com.ibm.etools.struts.strutsconfig.presentation.vieweradapters.AbstractViewerAdapter;
import com.ibm.etools.struts.strutsconfig.presentation.vieweradapters.IAbstractValidator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jst.j2ee.internal.common.StructuredTextEditingDomain;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class IntegerViewerAdapter
extends AbstractViewerAdapter {
    public IntegerViewerAdapter(Text text, StructuredTextEditingDomain editingDomain, EAttribute feature, IValidateEditListener editValidator) {
        super((Control)text, editingDomain, feature, editValidator);
    }

    public IntegerViewerAdapter(Text text, StructuredTextEditingDomain editingDomain, EAttribute feature, IAbstractValidator validator, IValidateEditListener editValidator) {
        super((Control)text, editingDomain, feature, validator, editValidator);
    }

    public IntegerViewerAdapter(Text text, StructuredTextEditingDomain editingDomain, String xmiName, IValidateEditListener editValidator) {
        super((Control)text, editingDomain, xmiName, editValidator);
    }

    public IntegerViewerAdapter(Text text, StructuredTextEditingDomain editingDomain, String xmiName, IAbstractValidator validator, IValidateEditListener editValidator) {
        super((Control)text, editingDomain, xmiName, validator, editValidator);
    }

    @Override
    protected void hookControl(Control control) {
        super.hookControl(control);
        ((Text)control).addVerifyListener((VerifyListener)new IntegerTextVerifyListener());
    }

    public Text getText() {
        return (Text)this.getControl();
    }

    @Override
    protected Object getValueFromWidget() {
        String value;
        Integer result = null;
        Text text = this.getText();
        if (!text.isDisposed() && (value = text.getText()) != null && value.trim().length() > 0) {
            try {
                result = new Integer(value);
            }
            catch (Throwable throwable) {
                this.getText().setText("");
                result = null;
            }
        }
        return result;
    }

    @Override
    protected void setValueToWidget(Object value) {
        Text text = this.getText();
        if (value == null) {
            text.setText("");
        } else {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("Value must be String");
            }
            if (text.getText() == "" || text.getText() == null) {
                if ((Integer)value != 0) {
                    text.setText(((Integer)value).toString());
                }
            } else {
                Integer oldValue = null;
                try {
                    oldValue = new Integer(text.getText());
                }
                catch (Throwable throwable) {}
                if (oldValue == null) {
                    oldValue = new Integer(0);
                }
                if (oldValue.intValue() != ((Integer)value).intValue()) {
                    text.setText(((Integer)value).toString());
                }
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        try {
            String newText = this.getText().getText();
            if (newText != null && newText != "") {
                new Integer(newText);
            }
        }
        catch (Throwable throwable) {
            this.getText().setText("");
            return;
        }
        super.focusLost(e);
    }

    @Override
    public Command getMOFCommand() {
        Object obj = this.getUpdateValue();
        if (obj != null) {
            return SetCommand.create((EditingDomain)this.editingDomain, (Object)this.owner, (Object)this.getFeature(), (Object)obj);
        }
        return SetCommand.create((EditingDomain)this.editingDomain, (Object)this.owner, (Object)this.getFeature(), (Object)SetCommand.UNSET_VALUE);
    }

    private static class IntegerTextVerifyListener
    implements VerifyListener {
        private IntegerTextVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            Text text = (Text)e.widget;
            StringBuffer buffer = new StringBuffer(text.getText());
            buffer.replace(e.start, e.end, e.text);
            String digits = buffer.toString();
            if (digits.equals("")) {
                digits = "0";
            }
            try {
                Integer.parseInt(digits);
            }
            catch (NumberFormatException numberFormatException) {
                e.doit = false;
                return;
            }
        }
    }
}

