/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.presentation.vieweradapters;

import com.ibm.etools.emf.workbench.ui.listeners.IValidateEditListener;
import com.ibm.etools.struts.strutsconfig.presentation.vieweradapters.AbstractViewerAdapter;
import com.ibm.etools.struts.strutsconfig.presentation.vieweradapters.IAbstractValidator;
import com.ibm.etools.struts.util.StrutsUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.internal.common.StructuredTextEditingDomain;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class IconViewerAdapter
extends AbstractViewerAdapter {
    private IVirtualComponent fComponent;
    private Label fIconPreview;
    private IContainer fRoot;

    public IconViewerAdapter(Text text, StructuredTextEditingDomain editingDomain, EAttribute feature, IContainer root, IVirtualComponent component, Label iconPreview, IValidateEditListener editValidator) {
        super((Control)text, editingDomain, feature, editValidator);
        this.setRoot(root);
        this.setComponent(component);
        this.setIconPreview(iconPreview);
    }

    public IconViewerAdapter(Text text, StructuredTextEditingDomain editingDomain, EAttribute feature, IAbstractValidator validator, IValidateEditListener editValidator) {
        super((Control)text, editingDomain, feature, validator, editValidator);
    }

    public IconViewerAdapter(Text text, StructuredTextEditingDomain editingDomain, String xmiName, IValidateEditListener editValidator) {
        super((Control)text, editingDomain, xmiName, editValidator);
    }

    public IconViewerAdapter(Text text, StructuredTextEditingDomain editingDomain, String xmiName, IAbstractValidator validator, IValidateEditListener editValidator) {
        super((Control)text, editingDomain, xmiName, validator, editValidator);
    }

    public Text getText() {
        return (Text)this.getControl();
    }

    @Override
    protected Object getValueFromWidget() {
        Text text = this.getText();
        if (text.isDisposed()) {
            return null;
        }
        String value = text.getText();
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return value;
    }

    @Override
    protected void setValueToWidget(Object value) {
        Text text = this.getText();
        if (value == null) {
            text.setText("");
        } else {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("Value must be String");
            }
            if (!text.getText().trim().equals(((String)value).trim()) || text.getText().length() > ((String)value).length()) {
                text.setText((String)value);
                this.updateIconView((String)value);
            }
        }
    }

    private void updateIconView(String path) {
        Label iconPreview = this.getIconPreview();
        if (iconPreview != null && !iconPreview.isDisposed()) {
            iconPreview.setImage(this.getImageFromFileName(path));
        }
    }

    @Override
    public boolean updateMOF() {
        boolean valid = true;
        if (this.getInput() == null) {
            return valid;
        }
        Object newValue = this.getUpdateValue();
        if (this.oldValue != null && this.oldValue.equals(newValue)) {
            return valid;
        }
        if (this.oldValue == null && newValue == null) {
            return valid;
        }
        valid = this.isValid(newValue);
        if (!valid) {
            return valid;
        }
        IStatus status = this.editValidator.validateState();
        if (status == null || status.getSeverity() == 0) {
            this.preExecute();
            Command command = this.getMOFCommand();
            this.editingDomain.getCommandStack().execute(command);
            this.updateIconView((String)this.getValueFromWidget());
            this.postExecute();
            this.oldValue = newValue;
        } else {
            this.setValueToWidget(this.oldValue);
        }
        return valid;
    }

    protected Image getImageFromFileName(String fileName) {
        Image image = null;
        if (this.fComponent != null && fileName != null && !fileName.equals("")) {
            IContainer root = StrutsUtil.getModuleServerRoot(this.fComponent);
            IFile current = null;
            File file = null;
            Path currentPath = new Path(fileName);
            try {
                current = root.getFile((IPath)currentPath);
                file = current.getLocation().toFile();
            }
            catch (Throwable throwable) {
                current = null;
                file = null;
            }
            if (current != null && current.exists() && file != null) {
                try {
                    image = ImageDescriptor.createFromURL((URL)file.toURL()).createImage();
                }
                catch (MalformedURLException malformedURLException) {
                    image = null;
                }
                catch (SWTException sWTException) {
                    image = null;
                }
            }
        }
        return image;
    }

    public IVirtualComponent getComponent() {
        return this.fComponent;
    }

    public Label getIconPreview() {
        return this.fIconPreview;
    }

    public IContainer getRoot() {
        return this.fRoot;
    }

    public void setComponent(IVirtualComponent fComponent) {
        this.fComponent = fComponent;
    }

    public void setIconPreview(Label iconPreview) {
        this.fIconPreview = iconPreview;
    }

    public void setRoot(IContainer root) {
        this.fRoot = root;
    }

    @Override
    public void setInput(Object input) {
        super.setInput(input);
        if (input != null) {
            this.updateIconView((String)this.getValueFromWidget());
        } else {
            this.updateIconView("");
        }
    }
}

