/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.presentation.vieweradapters;

import com.ibm.etools.emf.workbench.ui.listeners.IValidateEditListener;
import com.ibm.etools.struts.strutsconfig.presentation.vieweradapters.AbstractViewerAdapterListener;
import com.ibm.etools.struts.strutsconfig.presentation.vieweradapters.AbstractViewerFocusListener;
import com.ibm.etools.struts.strutsconfig.presentation.vieweradapters.FeatureViewerAdapterScout;
import com.ibm.etools.struts.strutsconfig.presentation.vieweradapters.IAbstractValidator;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.internal.common.StructuredTextEditingDomain;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractViewerAdapter
extends Viewer
implements FocusListener,
DisposeListener,
INotifyChangedListener {
    protected static final int DEFAULT_FOCUS_TIMER_DELAY = 500;
    private boolean disposed;
    protected StructuredTextEditingDomain editingDomain;
    protected IValidateEditListener editValidator;
    protected EAttribute feature;
    private TimedFocusListener fFocusListener = null;
    protected boolean fInFocusLost = false;
    protected IValidateEditListener fValidateEditListener;
    protected Object oldValue;
    protected EObject owner;
    private LinkedHashSet updateListeners;
    private IAbstractValidator validator;
    protected Control widget;
    protected String xmiName;

    public AbstractViewerAdapter(Control widget, StructuredTextEditingDomain editingDomain, EAttribute feature, IAbstractValidator validator, IValidateEditListener editValidator) {
        this.editValidator = editValidator;
        this.widget = widget;
        this.editingDomain = editingDomain;
        this.feature = feature;
        this.validator = validator;
        this.hookControl(widget);
    }

    public AbstractViewerAdapter(Control widget, StructuredTextEditingDomain editingDomain, EAttribute feature, IValidateEditListener editValidator) {
        this.editValidator = editValidator;
        this.widget = widget;
        this.editingDomain = editingDomain;
        this.feature = feature;
        this.hookControl(widget);
    }

    public AbstractViewerAdapter(Control widget, StructuredTextEditingDomain editingDomain, String xmiName, IAbstractValidator validator, IValidateEditListener editValidator) {
        this.editValidator = editValidator;
        this.widget = widget;
        this.editingDomain = editingDomain;
        this.xmiName = xmiName;
        this.validator = validator;
        this.hookControl(widget);
    }

    public AbstractViewerAdapter(Control widget, StructuredTextEditingDomain editingDomain, String xmiName, IValidateEditListener editValidator) {
        this.editValidator = editValidator;
        this.widget = widget;
        this.editingDomain = editingDomain;
        this.xmiName = xmiName;
        this.hookControl(widget);
    }

    protected void addFocusListener(Control textField) {
        if (this.fFocusListener == null) {
            this.fFocusListener = new TimedFocusListener(500);
        }
        textField.addFocusListener((FocusListener)this.fFocusListener);
    }

    public void addListener(AbstractViewerAdapterListener listener) {
        if (this.updateListeners == null) {
            this.updateListeners = new LinkedHashSet();
        }
        this.updateListeners.add(listener);
    }

    protected void attachScout(Notifier target) {
        FeatureViewerAdapterScout scout = new FeatureViewerAdapterScout(this, (EStructuralFeature)this.getFeature());
        scout.setTarget(target);
        target.eAdapters().add((Object)scout);
    }

    protected void detachScout(Notifier target) {
        FeatureViewerAdapterScout scout = (FeatureViewerAdapterScout)EcoreUtil.getExistingAdapter((Notifier)target, (Object)this.getFeature());
        target.eAdapters().remove((Object)scout);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (!this.fInFocusLost) {
            this.fInFocusLost = true;
            if (this.getInput() != null) {
                this.updateMOF();
            }
            this.fInFocusLost = false;
        }
    }

    public Control getControl() {
        return this.widget;
    }

    protected EAttribute getFeature() {
        if (this.feature != null) {
            return this.feature;
        }
        if (this.owner == null) {
            return null;
        }
        return (EAttribute)this.owner.eClass().getEStructuralFeature(this.xmiName);
    }

    public TimedFocusListener getFFocusListener() {
        return this.fFocusListener;
    }

    public Object getInput() {
        return this.owner;
    }

    public Command getMOFCommand() {
        Object updateValue = this.getUpdateValue();
        if (updateValue == null || "".equals(updateValue)) {
            return SetCommand.create((EditingDomain)this.editingDomain, (Object)this.owner, (Object)this.getFeature(), (Object)SetCommand.UNSET_VALUE);
        }
        return SetCommand.create((EditingDomain)this.editingDomain, (Object)this.owner, (Object)this.getFeature(), (Object)this.getUpdateValue());
    }

    public ISelection getSelection() {
        return null;
    }

    protected Object getUpdateValue() {
        return this.getValueFromWidget();
    }

    protected abstract Object getValueFromWidget();

    protected void handleFocusGained(FocusEvent e) {
    }

    protected void handleFocusLost(FocusEvent e) {
        this.focusLost(e);
    }

    protected void hookControl(Control control) {
        control.addFocusListener((FocusListener)this);
        control.addDisposeListener((DisposeListener)this);
        this.addFocusListener(control);
    }

    protected boolean isValid(Object newValue) {
        if (this.validator != null) {
            return this.validator.isValid(newValue, this.getControl());
        }
        return true;
    }

    public void notifyChanged(Notification notification) {
        if (notification.getFeature().equals(this.getFeature())) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractViewerAdapter.this.refresh();
                }
            });
        }
    }

    protected void postExecute() {
        if (this.updateListeners != null) {
            ArrayList copy = new ArrayList(this.updateListeners);
            for (AbstractViewerAdapterListener listener : copy) {
                listener.postExecute(this.widget);
            }
        }
    }

    protected void preExecute() {
        if (this.updateListeners != null) {
            ArrayList copy = new ArrayList(this.updateListeners);
            for (AbstractViewerAdapterListener listener : copy) {
                listener.preExecute(this.widget);
            }
        }
    }

    public void refresh() {
        Object value = this.owner == null ? null : this.owner.eGet((EStructuralFeature)this.getFeature());
        this.setValueToWidget(value);
        this.oldValue = this.getValueFromWidget();
    }

    public void refresh(Object value) {
        this.setValueToWidget(value);
        this.oldValue = this.getValueFromWidget();
    }

    public void removeListener(AbstractViewerAdapterListener listener) {
        if (this.updateListeners == null) {
            this.updateListeners = new LinkedHashSet();
        }
        this.updateListeners.remove(listener);
    }

    public void setInput(Object input) {
        if (this.owner != null) {
            this.detachScout((Notifier)this.owner);
        }
        this.owner = (EObject)input;
        if (this.owner != null) {
            this.attachScout((Notifier)this.owner);
        }
        if (!this.disposed) {
            this.refresh();
        }
        if (this.owner != null) {
            this.oldValue = this.getValueFromWidget();
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    protected abstract void setValueToWidget(Object var1);

    public boolean updateMOF() {
        boolean valid = true;
        if (this.getInput() == null) {
            return valid;
        }
        Object newValue = this.getUpdateValue();
        if (this.oldValue == null && newValue == null) {
            return valid;
        }
        if (this.oldValue != null && this.oldValue.equals(newValue)) {
            return valid;
        }
        valid = this.isValid(newValue);
        if (!valid) {
            return valid;
        }
        IStatus status = this.editValidator.validateState();
        if (status == null || status.getSeverity() == 0) {
            this.preExecute();
            Command command = this.getMOFCommand();
            this.editingDomain.getCommandStack().execute(command);
            this.postExecute();
            this.oldValue = newValue;
        } else {
            this.setValueToWidget(this.oldValue);
        }
        return valid;
    }

    public void widgetDisposed(DisposeEvent e) {
        this.disposed = true;
        ((Control)e.getSource()).removeFocusListener((FocusListener)this.getFFocusListener());
        if (this.updateListeners != null) {
            this.updateListeners.clear();
        }
        this.setInput(null);
    }

    public class TimedFocusListener
    extends AbstractViewerFocusListener {
        private ArrayList listeners;

        public TimedFocusListener(int timeLimit) {
            super(timeLimit);
            this.listeners = new ArrayList();
        }

        @Override
        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            AbstractViewerAdapter.this.handleFocusGained(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            AbstractViewerAdapter.this.handleFocusLost(e);
            for (FocusListener element : this.listeners) {
                element.focusLost(e);
            }
        }

        public void registenerListener(FocusListener listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }
}

