/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.presentation.pages;

import com.ibm.etools.struts.emf.strutsconfig.DataSource;
import com.ibm.etools.struts.emf.strutsconfig.SetProperty;
import com.ibm.etools.struts.emf.strutsconfig.SetPropertyContainer;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.strutsconfig.presentation.IStrutsconfigEditorData;
import com.ibm.etools.struts.strutsconfig.presentation.sections.DataSourceAttributeSection;
import com.ibm.etools.struts.strutsconfig.presentation.sections.DataSourceEntrySection;
import com.ibm.etools.struts.strutsconfig.presentation.sections.DataSourceKeyValueTableSection;
import com.ibm.etools.webtools.flatui.FlatEditor;
import com.ibm.etools.webtools.flatui.FlatPage;
import com.ibm.etools.webtools.flatui.FlatPageSection;
import com.ibm.etools.webtools.flatui.FlatPageWithRHSFixedAndLHSScrolled;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DataSourcePage
extends FlatPageWithRHSFixedAndLHSScrolled {
    private DataSourceEntrySection fDataSourceSection;
    private DataSourceAttributeSection fDataSourceAttributeSection;
    private DataSourceKeyValueTableSection fDataSourceKeyValueTableSection;
    private FlatEditor fParentEditor;
    private IStrutsconfigEditorData fData;

    public DataSourcePage(IStrutsconfigEditorData data) {
        super(data.getWidgetFactory());
        this.setTabText(ResourceHandler.data_source_page_title);
        this.setHeadingText(ResourceHandler.data_source_page_title);
        this.setScrollable(false);
        this.fData = data;
        this.createSections(data);
    }

    protected void createSectionControls(Composite parent) {
        super.createSectionControls(parent);
        this.getSashForm().SASH_WIDTH = 7;
        Control secCon1 = this.fDataSourceSection.createControl(this.getLHSListComposite());
        this.fDataSourceSection.setGridData(secCon1);
        int i = 1;
        while (i < this.fSections.size()) {
            FlatPageSection fps = (FlatPageSection)this.fSections.elementAt(i);
            Control secCon = fps.createControl(this.getRHSScrollableDetailsComposite());
            fps.setGridData(secCon);
            ++i;
        }
        this.getFlatScrolledComposite().init(1);
        Point rootCompSize = this.getRHSScrollableDetailsComposite().computeSize(-1, -1);
        this.setFlatScrollableSectionDimensions(rootCompSize);
        this.fDataSourceSection.setListeners((FlatPage)this);
        this.getSashForm().setWeights(new int[]{40, 60});
    }

    protected void createSections(IStrutsconfigEditorData data) {
        this.fDataSourceSection = new DataSourceEntrySection(data);
        this.registerSection(this.fDataSourceSection);
        this.fDataSourceAttributeSection = new DataSourceAttributeSection(data);
        this.registerSection(this.fDataSourceAttributeSection);
        this.fDataSourceKeyValueTableSection = new DataSourceKeyValueTableSection(data);
        this.registerSection(this.fDataSourceKeyValueTableSection);
    }

    public void refreshEditModel(IStrutsconfigEditorData data) {
        this.fDataSourceSection.refreshEditModel(data);
        this.fDataSourceAttributeSection.refreshEditModel(data);
        this.fDataSourceKeyValueTableSection.refreshEditModel(data);
    }

    public final void setEditor(FlatEditor fe) {
        this.fParentEditor = fe;
    }

    public final FlatEditor getEditor() {
        return this.fParentEditor;
    }

    public void setActivated(boolean isActivated) {
        super.setActivated(isActivated);
        this.fDataSourceSection.initializeSelection();
    }

    public void setOutlineSelection(IStructuredSelection sel) {
        if (sel == null || sel.isEmpty()) {
            this.fDataSourceSection.setSelection(null, false);
        } else {
            Object selectedObject = sel.getFirstElement();
            this.focusOn(selectedObject);
        }
    }

    private Object focusOn(Object target) {
        Object result = null;
        if (target instanceof DataSource) {
            DataSource trueTarget = this.findDataSource((DataSource)target);
            this.fDataSourceSection.setSelection((ISelection)new StructuredSelection(new Object[]{trueTarget}), true);
            result = trueTarget;
        } else {
            EObject parent = ((EObject)target).eContainer();
            Object trueParent = this.focusOn(parent);
            if (target instanceof SetProperty) {
                SetProperty trueTarget = this.findSetProperty((SetPropertyContainer)trueParent, (SetProperty)target);
                this.fDataSourceKeyValueTableSection.setSelection((ISelection)new StructuredSelection(new Object[]{trueTarget}), true);
                result = trueTarget;
            }
        }
        return result;
    }

    private DataSource findDataSource(DataSource source) {
        DataSource target = null;
        EList<DataSource> elist = this.fData.getStrutsArtifactEdit().getStrutsConfig().getDataSources();
        for (DataSource element : elist) {
            if (element.getKey() == null) {
                if (source.getKey() != null) continue;
                target = element;
                continue;
            }
            if (!element.getKey().equals(source.getKey())) continue;
            target = element;
        }
        return target;
    }

    private SetProperty findSetProperty(SetPropertyContainer parent, SetProperty source) {
        SetProperty target = null;
        EList<SetProperty> elist = parent.getSetProperties();
        for (SetProperty element : elist) {
            if (element.getProperty() == null) {
                if (source.getProperty() != null) continue;
                target = element;
                continue;
            }
            if (!element.getProperty().equals(source.getProperty())) continue;
            target = element;
        }
        return target;
    }
}

