/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.presentation;

import java.util.Collections;
import java.util.Vector;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class StrutsconfigContentOutlinePage
extends Page
implements IContentOutlinePage,
ISelectionChangedListener {
    protected EditingDomain editingDomain = null;
    protected AdapterFactoryLabelProvider labelProvider;
    protected AdapterFactoryContentProvider tableTreeContentProvider;
    protected ISelection deferredSelection = null;
    protected Object input;
    protected MenuManager contextMenu = null;
    protected IWorkbenchPartSite site = null;
    private ListenerList selectionChangedListeners = new ListenerList();
    private TreeViewer treeViewer;

    public StrutsconfigContentOutlinePage(AdapterFactoryContentProvider contentProvider, AdapterFactoryLabelProvider labelProvider) {
        this.tableTreeContentProvider = contentProvider;
        this.labelProvider = labelProvider;
    }

    public StrutsconfigContentOutlinePage(AdapterFactoryContentProvider contentProvider, AdapterFactoryLabelProvider labelProvider, EditingDomain newEditingDomain, IWorkbenchPartSite newSite) {
        this.tableTreeContentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.editingDomain = newEditingDomain;
        this.site = newSite;
    }

    public void createControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 768);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.tableTreeContentProvider != null) {
            this.treeViewer.setContentProvider((IContentProvider)this.tableTreeContentProvider);
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.contextMenu != null) {
                Menu menu = this.contextMenu.createContextMenu(this.treeViewer.getControl());
                this.treeViewer.getControl().setMenu(menu);
            }
            if (this.editingDomain != null) {
                int dndOperations = 7;
                Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
                this.treeViewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)this.treeViewer));
                this.treeViewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter(this.editingDomain, (Viewer)this.treeViewer));
            }
            this.update();
        }
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setInput(Object webApp) {
        this.input = webApp;
        this.update();
    }

    public void setMenuManger(MenuManager menuManager) {
        this.contextMenu = menuManager;
    }

    public void update() {
        if (this.getTreeViewer() != null) {
            if (this.input != null) {
                this.getTreeViewer().setInput((Object)new ItemProvider(Collections.singleton(this.input)));
                if (this.deferredSelection == null || this.deferredSelection.isEmpty()) {
                    Vector<Object> selection = new Vector<Object>();
                    selection.addElement(this.input);
                    this.getTreeViewer().setSelection((ISelection)new StructuredSelection(selection.toArray()), true);
                } else {
                    this.getTreeViewer().setSelection(this.deferredSelection);
                    this.deferredSelection = null;
                }
            } else {
                this.getTreeViewer().setInput((Object)new ItemProvider());
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    protected void fireSelectionChanged(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
            ++i;
        }
    }

    public Control getControl() {
        if (this.treeViewer == null) {
            return null;
        }
        return this.treeViewer.getControl();
    }

    public ISelection getSelection() {
        ISelection retVal = null;
        if (this.getTreeViewer() != null) {
            retVal = this.getTreeViewer().getSelection();
        }
        return retVal;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event.getSelection());
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void setSelection(ISelection selection) {
        if (this.getTreeViewer() != null && !this.getTreeViewer().getControl().isDisposed()) {
            this.getTreeViewer().setSelection(selection);
        } else {
            this.deferredSelection = selection;
        }
    }
}

