/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig;

import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.strutsconfig.IStrutsConfigFileModifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class StrutsConfigFileModifierManager {
    private static final String FILE_MODIFIER_EXTENSION_ID = "com.ibm.etools.struts.configFileCreation";
    private static final String ELEM_FILE_MODIFIER = "fileModifier";
    private static final String ELEM_FILE_MODIFIER_ID = "id";
    private static final String ELEM_FILE_MODIFIER_CLASS = "class";
    private static final String ELEM_FACET = "facet";
    private static final String ELEM_FACET_ID = "facetId";
    private static final String ELEM_FACET_TYPE = "type";
    private static final String ELEM_FACET_TYPE_REQ = "require";
    private static final String ELEM_FACET_TYPE_INC = "include";
    private static final String ELEM_FACET_TYPE_EXC = "exclude";
    private static final StrutsConfigFileModifierManager manager = new StrutsConfigFileModifierManager();

    private StrutsConfigFileModifierManager() {
    }

    public static List getFileModifiersForComponent(IVirtualComponent component) {
        return manager.getInternalFileModifiersForProject(component);
    }

    private List getInternalFileModifiersForProject(IVirtualComponent component) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] conf = reg.getConfigurationElementsFor(FILE_MODIFIER_EXTENSION_ID);
        FacetData data = new FacetData();
        ArrayList<IStrutsConfigFileModifier> list = new ArrayList<IStrutsConfigFileModifier>();
        int i = 0;
        while (i < conf.length) {
            IStrutsConfigFileModifier fileModifier;
            IConfigurationElement currentConf = conf[i];
            data.processElement(currentConf);
            if (this.isMatching(data, component) && (fileModifier = this.getExcutableFileModifier(currentConf)) != null) {
                list.add(fileModifier);
            }
            ++i;
        }
        return list;
    }

    private IStrutsConfigFileModifier getExcutableFileModifier(IConfigurationElement confElement) {
        Object obj = null;
        try {
            obj = confElement.createExecutableExtension(ELEM_FILE_MODIFIER_CLASS);
        }
        catch (CoreException ce) {
            StrutsPlugin.getLogger().log((Throwable)ce);
        }
        if (obj instanceof IStrutsConfigFileModifier) {
            return (IStrutsConfigFileModifier)obj;
        }
        StrutsPlugin.getLogger().log("Extension does not implement com.ibm.etools.struts.strutsconfig.IStrutsConfigFileModifier");
        return null;
    }

    private boolean isMatching(FacetData data, IVirtualComponent component) {
        if (!data.hasFacetData()) {
            return false;
        }
        Set facetVersions = null;
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)component.getProject());
            facetVersions = facetedProject.getProjectFacets();
        }
        catch (CoreException coreException) {}
        if (facetVersions == null || facetVersions.isEmpty()) {
            return false;
        }
        Set facetIds = this.getFacetIds(facetVersions);
        if (data.hasRequire() && !facetIds.containsAll(data.getRequire())) {
            return false;
        }
        if (data.hasInclude() && !this.setContains(facetIds, data.getInclude())) {
            return false;
        }
        return !data.hasExclude() || !this.setContains(facetIds, data.getExclude());
    }

    private Set getFacetIds(Set facetVersions) {
        HashSet<String> set = new HashSet<String>();
        for (IProjectFacetVersion facetVersion : facetVersions) {
            set.add(facetVersion.getProjectFacet().getId());
        }
        return set;
    }

    private boolean setContains(Set set, List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (!set.contains(iter.next())) continue;
            return true;
        }
        return false;
    }

    private final class FacetData {
        private ArrayList require;
        private ArrayList include;
        private ArrayList exclude;

        private void processElement(IConfigurationElement element) {
            this.resetDataList();
            String name = element.getName();
            if (!StrutsConfigFileModifierManager.ELEM_FILE_MODIFIER.equals(name)) {
                return;
            }
            IConfigurationElement[] facetElements = element.getChildren(StrutsConfigFileModifierManager.ELEM_FACET);
            if (facetElements.length == 0) {
                return;
            }
            int i = 0;
            while (i < facetElements.length) {
                IConfigurationElement facetElement = facetElements[i];
                String facetId = facetElement.getAttribute(StrutsConfigFileModifierManager.ELEM_FACET_ID);
                if (this.isEmptyString(facetId)) {
                    StrutsPlugin.getLogger().log("Facet id is missing for configuration element" + element.getAttribute(StrutsConfigFileModifierManager.ELEM_FILE_MODIFIER_ID));
                } else {
                    String type = facetElement.getAttribute(StrutsConfigFileModifierManager.ELEM_FACET_TYPE);
                    if (this.isEmptyString(type)) {
                        StrutsPlugin.getLogger().log("Type for facet is missing for the configuration element" + element.getAttribute(StrutsConfigFileModifierManager.ELEM_FILE_MODIFIER_ID));
                    } else if (StrutsConfigFileModifierManager.ELEM_FACET_TYPE_REQ.equalsIgnoreCase(type)) {
                        this.addRequireId(facetId);
                    } else if (StrutsConfigFileModifierManager.ELEM_FACET_TYPE_INC.equalsIgnoreCase(type)) {
                        this.addIncludeId(facetId);
                    } else if (StrutsConfigFileModifierManager.ELEM_FACET_TYPE_EXC.equalsIgnoreCase(type)) {
                        this.addExcludeId(facetId);
                    }
                }
                ++i;
            }
        }

        private boolean isEmptyString(String string) {
            return string == null || string.length() == 0;
        }

        private void resetDataList() {
            if (this.hasRequire()) {
                this.require.clear();
            }
            if (this.hasInclude()) {
                this.include.clear();
            }
            if (this.hasExclude()) {
                this.exclude.clear();
            }
        }

        public boolean hasRequire() {
            return this.listNotNullOrEmpty(this.require);
        }

        public boolean hasInclude() {
            return this.listNotNullOrEmpty(this.include);
        }

        public boolean hasExclude() {
            return this.listNotNullOrEmpty(this.exclude);
        }

        public boolean hasFacetData() {
            return this.hasRequire() || this.hasInclude() || this.hasExclude();
        }

        private boolean listNotNullOrEmpty(List list) {
            return list != null && list.size() != 0;
        }

        public ArrayList getRequire() {
            return this.require;
        }

        public ArrayList getInclude() {
            return this.include;
        }

        public ArrayList getExclude() {
            return this.exclude;
        }

        public void addRequireId(String facetId) {
            this.require = this.addToList(this.require, facetId);
        }

        public void addIncludeId(String facetId) {
            this.include = this.addToList(this.include, facetId);
        }

        public void addExcludeId(String facetId) {
            this.exclude = this.addToList(this.exclude, facetId);
        }

        private ArrayList addToList(ArrayList list, String id) {
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(id);
            return list;
        }
    }
}

