/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.emf.strutsconfig.xml.StrutsConfigEditModelUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.strutsconfig.IStrutsConfigFileModifier;
import com.ibm.etools.struts.strutsconfig.StrutsConfigFileModifierManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StrutsConfigFileCreator {
    private int strutsVersion = -1;
    private String applicationResources = null;

    private StrutsConfigFileCreator() {
    }

    public StrutsConfigFileCreator(int strutsVersion, String applicationResources) {
        this();
        assert (strutsVersion >= 0 || strutsVersion <= 3);
        this.strutsVersion = strutsVersion;
        if (strutsVersion >= 1) {
            this.applicationResources = applicationResources;
        }
    }

    public StrutsConfigFileCreator(int strutsVersion) {
        this(strutsVersion, null);
    }

    public void writeTo(IFile file, IProgressMonitor monitor) throws CoreException {
        InputStream inputStream = null;
        try {
            inputStream = this.buildInputStream(ComponentUtilities.findComponent((IResource)file.getParent()));
        }
        catch (IOException exception) {
            throw new CoreException((IStatus)new Status(4, StrutsPlugin.getDefault().getBundle().getSymbolicName(), 0, NLS.bind((String)ResourceHandler.Nature_error_save_message_ioError, (Object)file.getName()), (Throwable)exception));
        }
        if (file.exists()) {
            file.setContents(inputStream, true, true, monitor);
        } else {
            file.create(inputStream, true, monitor);
        }
    }

    public InputStream buildInputStream(IVirtualComponent component) throws IOException {
        Document document = this.createDocument();
        this.processExternalExtension(document, component);
        return this.buildInputStream(document);
    }

    private Document createDocument() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException exception) {
            StrutsPlugin.getLogger().log((Throwable)exception);
            return null;
        }
        Document document = builder.newDocument();
        Element root = document.createElement("struts-config");
        document.appendChild(root);
        this.appendDcoumentSections(document, root);
        return document;
    }

    protected void appendDcoumentSections(Document document, Element root) {
        this.appendStrutsSpecificSections(document, root);
        this.appendApplicationResourcesSection(document, root);
        this.appendText(document, root, "\n");
    }

    protected void appendStrutsSpecificSections(Document document, Element root) {
        if (this.strutsVersion < 3) {
            this.appendSection(document, root, "data-sources");
        }
        this.appendSection(document, root, "form-beans");
        if (this.strutsVersion >= 1) {
            this.appendSection(document, root, "global-exceptions");
        }
        this.appendSection(document, root, "global-forwards");
        this.appendSection(document, root, "action-mappings");
    }

    protected void appendApplicationResourcesSection(Document document, Element root) {
        if (this.applicationResources != null) {
            this.appendText(document, root, "\n\t");
            this.appendText(document, root, "\n\t");
            Element element = document.createElement("message-resources");
            element.setAttribute("parameter", this.applicationResources);
            root.appendChild(element);
        }
    }

    protected Element appendSection(Document document, Node parent, String name) {
        this.appendText(document, parent, "\n\t");
        this.appendText(document, parent, "\n\t");
        return this.appendElement(document, parent, name);
    }

    protected Element appendElement(Document document, Node parent, String name) {
        Element element = document.createElement(name);
        this.appendText(document, element, "\n\t");
        parent.appendChild(element);
        return element;
    }

    protected void appendText(Document document, Node parent, String string) {
        parent.appendChild(document.createTextNode(string));
    }

    private InputStream buildInputStream(Document document) throws IOException {
        DOMSource source = new DOMSource(document, StrutsConfigEditModelUtil.getDTDSystemID(this.strutsVersion));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(outputStream);
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", Model2Util.getPreferredXMLEncoding());
            transformer.setOutputProperty("doctype-public", StrutsConfigEditModelUtil.getDTDPublicID(this.strutsVersion));
            transformer.setOutputProperty("doctype-system", StrutsConfigEditModelUtil.getDTDSystemID(this.strutsVersion));
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            outputStream.close();
        }
        catch (TransformerException exception) {
            StrutsPlugin.getLogger().log("Unexpected TransformerException creating Struts config. file", (Throwable)exception);
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    private void processExternalExtension(Document document, IVirtualComponent component) {
        List applicableModifiers = StrutsConfigFileModifierManager.getFileModifiersForComponent(component);
        if (applicableModifiers == null || applicableModifiers.size() == 0) {
            return;
        }
        int i = 0;
        while (i < applicableModifiers.size()) {
            IStrutsConfigFileModifier fileModifier = (IStrutsConfigFileModifier)applicableModifiers.get(i);
            fileModifier.process(document, component);
            ++i;
        }
    }
}

