/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.refactoring.processors;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.refactoring.processors.AbstractStrutsRenameProcessor;
import com.ibm.etools.struts.strutsconfig.validator.ValidateUtil;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class RenameGlobalForwardProcessor
extends AbstractStrutsRenameProcessor {
    private static final String FORWARD = "forward";
    private static final String NAME = "name";

    public String getIdentifier() {
        return "com.ibm.etools.struts.renameGlobalForward";
    }

    public String getProcessorName() {
        return ResourceHandler.refactoring_rename_global_forward;
    }

    public RefactoringStatus validateNewElementName(String text) {
        IProject project = this.getFile().getProject();
        if (text == null || "".equals(text)) {
            return RefactoringStatus.create((IStatus)new Status(4, StrutsPlugin.getPluginId(), NLS.bind((String)ResourceHandler.refactoring_empty_value_error, (Object[])new String[]{FORWARD, NAME})));
        }
        if (ValidateUtil.isStringContainWhiteSpace(text)) {
            return RefactoringStatus.create((IStatus)new Status(4, StrutsPlugin.getPluginId(), ResourceHandler.refactoring_forward_contains_whitespace_error));
        }
        String module = StrutsSearchUtil.getModuleForIFile((IFile)this.getFile(), null);
        Set globalForwards = StrutsSearchUtil.getGlobalForwards((IProject)project, (String)module, null);
        if (globalForwards != null) {
            for (ILink f : globalForwards) {
                if (!text.equals(f.getName())) continue;
                return RefactoringStatus.create((IStatus)new Status(4, StrutsPlugin.getPluginId(), NLS.bind((String)ResourceHandler.refactoring_value_is_duplicate_error, (Object[])new String[]{FORWARD, NAME, text})));
            }
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }
}

