/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.refactoring.participants;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.refactoring.RefactoringSupport;
import com.ibm.etools.references.refactoring.processor.FileTextRange;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.struts.nls.ResourceHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class StrutsArtifactRenameParticipant
extends RenameParticipant {
    private FileTextRange fTextRange;
    private RefactoringSupport refactoringSupport;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (!this.getArguments().getUpdateReferences()) {
            return RefactoringStatus.create((IStatus)Status.OK_STATUS);
        }
        RenameArguments arguments = this.getArguments();
        String newName = arguments.getNewName();
        ILink linkToChange = this.getLink(this.fTextRange);
        if (linkToChange != null) {
            HashMap<String, String> targetDescription = new HashMap<String, String>();
            if ("struts.action.link".equals(linkToChange.getSpecializedType().getId())) {
                targetDescription.put("actionName.id", newName);
            } else if ("struts.formbean.link".equals(linkToChange.getSpecializedType().getId())) {
                targetDescription.put("strutsformbean.id", newName);
            } else if ("struts.forward.link".equals(linkToChange.getSpecializedType().getId())) {
                targetDescription.put("strutsforward.id", newName);
            } else if ("struts.exception.link".equals(linkToChange.getSpecializedType().getId())) {
                targetDescription.put("strutsexception.id", newName);
            }
            this.refactoringSupport.createEdits(linkToChange, targetDescription, Collections.emptySet(), null);
        }
        return this.refactoringSupport.getStatus();
    }

    private ILink getLink(FileTextRange range) {
        SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{range.getFile()});
        SearchPattern pattern = SearchPattern.createWildcardPattern();
        DefaultSearchRequestor requestor = new DefaultSearchRequestor();
        new SearchEngine().search(pattern, scope, (SearchRequestor)requestor, null);
        Set<ILink> links = requestor.getMatches();
        links = this.rangeFilter(links, new TextRange(range.getOffset(), range.getLength(), 0));
        if (links.size() == 1) {
            return links.iterator().next();
        }
        return null;
    }

    private Set<ILink> rangeFilter(Set<ILink> links, TextRange container) {
        Iterator<ILink> iterator = links.iterator();
        while (iterator.hasNext()) {
            ILink link = iterator.next();
            if ("struts.exception.link".equals(link.getSpecializedType().getId())) {
                if (link.getLinkLocation() != null && link.getLinkLocation().contains(container)) continue;
                iterator.remove();
                continue;
            }
            String attribute = "name=";
            if ("struts.action.link".equals(link.getSpecializedType().getId())) {
                attribute = "path=";
            }
            if (link.getName() == null) {
                iterator.remove();
                continue;
            }
            String context = link.getContextText();
            int index = context.indexOf(attribute);
            index = context.indexOf(link.getName(), index + attribute.length());
            if (index >= 0) {
                int length;
                int offset = link.getContextLocation().getOffset() + index;
                TextRange nameRange = new TextRange(offset, length = link.getName().length(), 0);
                if (container.contains(nameRange)) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        return links;
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.refactoringSupport.createMergedChange(ResourceHandler.StrutsArtifactRenameParticipant_RenameAndUpdateReferences, (RefactoringParticipant)this, pm);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public String getName() {
        return ResourceHandler.StrutsArtifactRenameParticipant_MaintainReferences;
    }

    protected boolean initialize(Object element) {
        this.fTextRange = (FileTextRange)element;
        this.refactoringSupport = new RefactoringSupport();
        return true;
    }
}

