/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.projnavigator.nodes;

import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.IStrutsConstants;
import com.ibm.etools.struts.projnavigator.IStrutsProjNavNodeFactory;
import com.ibm.etools.struts.projnavigator.StrutsProjNavNode;
import com.ibm.etools.struts.projnavigator.factories.StrutsProjNavHandleNodeFactory;
import com.ibm.etools.struts.projnavigator.nodes.StrutsProjNavCategoryNode;
import com.ibm.etools.struts.projnavigator.nodes.StrutsProjNavResourceNode;
import com.ibm.etools.struts.projnavigator.nodes.StrutsRoot;
import com.ibm.etools.struts.projnavigator.providers.CategoryProvider;
import com.ibm.etools.struts.projnavigator.providers.IStrutsProjNavChildrenProvider;
import com.ibm.etools.struts.projnavigator.providers.StrutsResourcesProvider;
import com.ibm.etools.struts.strutsconfig.validator.StrutsMarkerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class StrutsProjNavModuleNode
extends StrutsProjNavNode {
    private static CategoryProvider categoryProvider = new CategoryProvider();
    private static StrutsResourcesProvider resourcesProvider = new StrutsResourcesProvider(1);
    private ArrayList<Object> resourceList;

    public StrutsProjNavModuleNode(Object projectElement, Object parent, String module) {
        super(projectElement, parent, module);
    }

    private ArrayList<Object> buildResourceList() {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] children = resourcesProvider.getChildren(this, this.getModule(), StrutsProjNavHandleNodeFactory.getFactory(), StrutsProjNavResourceNode.class);
        if (children != null) {
            list.addAll(Arrays.asList(children));
        }
        return list;
    }

    @Override
    public void dispose() {
        this.disposeResourceList();
        super.dispose();
    }

    private void disposeResourceList() {
        if (this.resourceList == null) {
            return;
        }
        for (StrutsProjNavResourceNode strutsProjNavResourceNode : this.resourceList) {
            strutsProjNavResourceNode.dispose();
        }
        this.resourceList = null;
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (adapterClass.equals(IVirtualComponent.class)) {
            return this.getComponent();
        }
        Object o = super.getAdapter(adapterClass);
        if (o != null) {
            return o;
        }
        return ((StrutsRoot)this.getParent()).getAdapter(adapterClass);
    }

    @Override
    protected Object[] getChildren(boolean create) {
        Object[] categories = super.getChildren(create);
        if (categories == null) {
            return null;
        }
        Object[] resources = this.getResourceListAsArray();
        if (resources.length == 0) {
            return categories;
        }
        Object[] allChildren = new Object[categories.length + resources.length];
        System.arraycopy(this.resourceList.toArray(), 0, allChildren, 0, this.resourceList.size());
        System.arraycopy(categories, 0, allChildren, resources.length, categories.length);
        return allChildren;
    }

    @Override
    public Class<StrutsProjNavCategoryNode> getChildrenType() {
        return StrutsProjNavCategoryNode.class;
    }

    private IVirtualComponent getComponent() {
        return (IVirtualComponent)this.getElement();
    }

    @Override
    public IStrutsProjNavNodeFactory getFactory() {
        return StrutsProjNavHandleNodeFactory.getFactory();
    }

    @Override
    public IStrutsProjNavChildrenProvider getProvider() {
        return categoryProvider;
    }

    private Object[] getResourceListAsArray() {
        if (this.resourceList == null) {
            this.resourceList = this.buildResourceList();
        }
        return this.resourceList.toArray();
    }

    @Override
    public int getStatus() {
        int markerServ = 0;
        if (this.children != null) {
            markerServ = this.getHighestSeverityFromAllChildren(this.children);
        }
        Collection files = StrutsSearchUtil.getStrutsConfigIFiles((IProject)this.getComponent().getProject(), (String)this.getModule());
        for (IFile file : files) {
            int sev = StrutsMarkerUtil.getHighestSeverityForFile(file);
            markerServ = Math.max(markerServ, sev);
        }
        return StrutsProjNavModuleNode.getStatusForIMarkerStatus(markerServ);
    }

    @Override
    public String getText() {
        return this.getStyledText().toString();
    }

    @Override
    public StyledString getStyledText() {
        String module = this.getModule();
        if (module == null) {
            module = "";
        }
        if (module.equals("")) {
            return new StyledString(IStrutsConstants.DEFAULTMODULE, StyledString.QUALIFIER_STYLER);
        }
        return new StyledString(module);
    }

    @Override
    public boolean isValidElement(Object element, Object parent) {
        if (element instanceof IProject) {
            return true;
        }
        return element instanceof IVirtualComponent;
    }
}

