/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.projnavigator;

import com.ibm.etools.struts.StrutsPlugin;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class StrutsProjNavJavaModelChangeManger
implements IElementChangedListener {
    private static StrutsProjNavJavaModelChangeManger manager = new StrutsProjNavJavaModelChangeManger();
    private HashSet listeners = new HashSet();
    private boolean listening = false;
    private HashSet itypes = new HashSet();

    private StrutsProjNavJavaModelChangeManger() {
    }

    public static StrutsProjNavJavaModelChangeManger getManager() {
        return manager;
    }

    public void replaceRegisteredType(IType originalType, IType newType) {
        if (originalType != null) {
            this.itypes.remove(originalType);
        }
        if (newType != null) {
            this.itypes.add(newType);
        }
    }

    public void addListener(IElementChangedListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
        this.setJavaCoreListeningOn();
    }

    public void removeListener(IElementChangedListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.setJavaCoreListeningOff();
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        StrutsPlugin.getLogger().trace("StrutsPlugin", "Java: Image Event caught by StrutsTreeviewerJavaModelChangeListenerManager");
        if (this.listeners.isEmpty()) {
            this.setJavaCoreListeningOff();
            return;
        }
        if (this.ignoreElementChangedEvent(event)) {
            return;
        }
        HashSet listenersClone = (HashSet)this.listeners.clone();
        Iterator iter = listenersClone.iterator();
        while (iter.hasNext()) {
            ((IElementChangedListener)iter.next()).elementChanged(event);
        }
    }

    private boolean ignoreElementChangedEvent(ElementChangedEvent event) {
        HashSet itypesClone;
        if ((event.getType() & 1) == 0) {
            return true;
        }
        IJavaElementDelta delta = event.getDelta();
        return !this.isITypeAffected(delta, itypesClone = (HashSet)this.itypes.clone());
    }

    private boolean isITypeAffected(IJavaElementDelta delta, HashSet itypesClone) {
        if (this.hasAffectedType(delta, itypesClone)) {
            return true;
        }
        IJavaElementDelta[] childrenDeltas = delta.getAffectedChildren();
        if (childrenDeltas != null) {
            int i = 0;
            while (i < childrenDeltas.length) {
                if (this.isITypeAffected(childrenDeltas[i], itypesClone)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean hasAffectedType(IJavaElementDelta delta, HashSet itypesClone) {
        if (delta != null && delta.getElement() != null && delta.getElement().getElementType() == 5) {
            switch (delta.getKind()) {
                case 1: {
                    return true;
                }
                case 2: {
                    return this.isRemovedCompilatiionUnitAffected((ICompilationUnit)delta.getElement(), itypesClone);
                }
                case 4: {
                    if ((delta.getFlags() & 0x40000) == 0) break;
                    return this.checkForAffectedIType((ICompilationUnit)delta.getElement(), itypesClone);
                }
            }
        }
        return false;
    }

    private boolean checkForAffectedIType(ICompilationUnit compilationUnit, HashSet itypesClone) {
        IType[] types = null;
        try {
            types = compilationUnit.getTypes();
        }
        catch (JavaModelException jme) {
            StrutsPlugin.getLogger().log((Throwable)jme);
        }
        if (types == null || types.length == 0) {
            return false;
        }
        int i = 0;
        while (i < types.length) {
            if (itypesClone.contains(types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isRemovedCompilatiionUnitAffected(ICompilationUnit compilationUnit, HashSet itypesClone) {
        for (IType type : itypesClone) {
            if (!compilationUnit.equals(type.getCompilationUnit())) continue;
            return true;
        }
        return false;
    }

    private void setJavaCoreListeningOn() {
        if (!this.listening) {
            JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
            this.listening = true;
        }
    }

    private void setJavaCoreListeningOff() {
        if (this.listening) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            this.itypes.clear();
            this.listening = false;
        }
    }
}

