/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.projnavigator;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.struts.internal.util.StrutsProjectUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.projnavigator.LoadingModelUIAnimationJob;
import com.ibm.etools.struts.projnavigator.StrutsModelLoadingNode;
import com.ibm.etools.struts.projnavigator.StrutsProjNavNode;
import com.ibm.etools.struts.projnavigator.nodes.StrutsProjNavCategoryNode;
import com.ibm.etools.struts.projnavigator.nodes.StrutsProjNavFormBeanNode;
import com.ibm.etools.struts.projnavigator.nodes.StrutsRoot;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class StrutsProjNavContentProvider
implements ICommonContentProvider {
    private TreeViewer fViewer;
    private final HashMap projectRootMap = new HashMap();
    private final LoadRule loadRule = new LoadRule();

    protected HashMap getProjectRootMap() {
        return this.projectRootMap;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof StrutsProjNavFormBeanNode || parentElement instanceof StrutsProjNavCategoryNode) {
            return this.getDeferrLoadedChildren((StrutsProjNavNode)parentElement);
        }
        if (parentElement instanceof StrutsProjNavNode) {
            return this.getDeferrLoadedChildren((StrutsProjNavNode)parentElement);
        }
        if (parentElement instanceof IAdaptable) {
            IProject project = (IProject)((IAdaptable)parentElement).getAdapter(IProject.class);
            if (project == null) {
                return null;
            }
            Object[] roots = (Object[])this.projectRootMap.get(project);
            if (roots == null) {
                IVirtualComponent component = Model2Util.findComponent((IResource)project);
                if (component != null && StrutsProjectUtil.isStruts((IProject)project)) {
                    Object[] list = new Object[]{new StrutsRoot((Object)component, null, this)};
                    this.projectRootMap.put(project, list);
                    return list;
                }
            } else {
                return roots;
            }
        }
        return null;
    }

    private Object[] getDeferrLoadedChildren(StrutsProjNavNode parentNode) {
        Object[] children = parentNode.getChildren(false);
        if (children != null) {
            return children;
        }
        if (parentNode instanceof StrutsModelLoadingNode) {
            return new Object[0];
        }
        if (StrutsModelLoadingNode.isBeingLoaded(parentNode)) {
            return new Object[]{StrutsModelLoadingNode.createPlaceHolder(parentNode)};
        }
        StrutsModelLoadingNode placeHolder = StrutsModelLoadingNode.createPlaceHolder(parentNode);
        if (StrutsModelLoadingNode.canBeginLoading(parentNode)) {
            LoadingModelUIAnimationJob updateUIJob = new LoadingModelUIAnimationJob((StructuredViewer)this.fViewer, placeHolder);
            updateUIJob.schedule();
            StrutsModelLoadingJob job = new StrutsModelLoadingJob((AbstractTreeViewer)this.fViewer, placeHolder, parentNode);
            job.setRule(this.loadRule);
            job.schedule();
        }
        return new Object[]{placeHolder};
    }

    public Object getParent(Object element) {
        boolean cfr_ignored_0 = element instanceof IAdaptable;
        if (element instanceof StrutsProjNavNode) {
            return ((StrutsProjNavNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof StrutsProjNavNode) {
            return ((StrutsProjNavNode)element).hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return null;
    }

    public void dispose() {
        if (this.projectRootMap == null || this.projectRootMap.isEmpty()) {
            return;
        }
        for (Object[] roots : this.projectRootMap.values()) {
            int i = 0;
            while (i < roots.length) {
                StrutsRoot root = (StrutsRoot)roots[i];
                root.dispose();
                ++i;
            }
        }
        this.projectRootMap.clear();
    }

    public void removeComponentEntry(IVirtualComponent component) {
        if (this.projectRootMap == null || this.projectRootMap.isEmpty()) {
            return;
        }
        IProject project = component.getProject();
        Object[] roots = (Object[])this.projectRootMap.get(project);
        if (roots != null) {
            int i = 0;
            while (i < roots.length) {
                StrutsRoot root = (StrutsRoot)roots[i];
                root.dispose();
                ++i;
            }
        }
        this.projectRootMap.remove(project);
        this.notifyRefresh(null);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        TreeViewer treeViewer = this.fViewer = viewer instanceof TreeViewer ? (TreeViewer)viewer : null;
        if (oldInput != null && newInput == null) {
            this.dispose();
        }
    }

    protected void notifyRefresh(Object element) {
        if (this.fViewer == null || this.fViewer.getTree().isDisposed()) {
            return;
        }
        RefreshViewerJob job = new RefreshViewerJob(this.fViewer, element);
        job.schedule();
    }

    protected void notifyUpdate(Object element) {
        if (this.fViewer == null || this.fViewer.getTree().isDisposed()) {
            return;
        }
        UpdateViewerJob job = new UpdateViewerJob(this.fViewer, element);
        job.schedule();
    }

    public static class ClearPlaceHolderJob
    extends UIJob {
        private final AbstractTreeViewer viewer;
        private final StrutsModelLoadingNode placeHolder;
        private final Object parent;

        public ClearPlaceHolderJob(AbstractTreeViewer viewer, StrutsModelLoadingNode placeHolder, Object parent) {
            super(ResourceHandler.ProjNavExtension_UpdateJob);
            this.setPriority(10);
            this.viewer = viewer;
            this.placeHolder = placeHolder;
            this.parent = parent;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            boolean shouldExpand = this.viewer.getExpandedState(this.parent);
            try {
                this.viewer.getControl().setRedraw(false);
                this.viewer.remove((Object)this.placeHolder);
                this.viewer.refresh(this.parent);
                this.viewer.setExpandedState(this.parent, shouldExpand);
            }
            finally {
                this.viewer.getControl().setRedraw(true);
            }
            return Status.OK_STATUS;
        }
    }

    public class LoadRule
    implements ISchedulingRule {
        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }

    private static final class RefreshViewerJob
    extends UIJob {
        private final Object element;
        private final TreeViewer viewer;

        private RefreshViewerJob(TreeViewer viewer, Object element) {
            super(ResourceHandler.ProjNavExtension_UpdateJob);
            this.setPriority(10);
            this.element = element;
            this.viewer = viewer;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.viewer != null && !this.viewer.getTree().isDisposed()) {
                boolean shouldExpand = this.viewer.getExpandedState(this.element);
                this.viewer.refresh(this.element);
                this.viewer.setExpandedState(this.element, shouldExpand);
            }
            return Status.OK_STATUS;
        }
    }

    public static class StrutsModelLoadingJob
    extends Job {
        private final StrutsModelLoadingNode placeHolder;
        private final AbstractTreeViewer viewer;
        private final StrutsProjNavNode parentNode;

        public StrutsModelLoadingJob(AbstractTreeViewer viewer, StrutsModelLoadingNode placeHolder, StrutsProjNavNode parentNode) {
            super(placeHolder.getText());
            this.setPriority(10);
            this.viewer = viewer;
            this.placeHolder = placeHolder;
            this.parentNode = parentNode;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.parentNode.getChildren(true);
            }
            finally {
                this.placeHolder.dispose();
                new ClearPlaceHolderJob(this.viewer, this.placeHolder, this.parentNode).schedule();
            }
            return Status.OK_STATUS;
        }
    }

    private static final class UpdateViewerJob
    extends UIJob {
        private final Object element;
        private final TreeViewer viewer;

        private UpdateViewerJob(TreeViewer viewer, Object element) {
            super(ResourceHandler.ProjNavExtension_UpdateJob);
            this.setPriority(10);
            this.element = element;
            this.viewer = viewer;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.viewer != null && !this.viewer.getTree().isDisposed()) {
                boolean shouldExpand = this.viewer.getExpandedState(this.element);
                this.viewer.update(this.element, null);
                this.viewer.setExpandedState(this.element, shouldExpand);
            }
            return Status.OK_STATUS;
        }
    }
}

