/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.preference;

import com.ibm.etools.struts.core.facet.StrutsVersionMediator;
import com.ibm.etools.struts.nls.ResourceHandler;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.osgi.util.NLS;

public class StrutsPreferences {
    private final Plugin plugin;
    public static final String RESTART_KEY = "restart";
    public static final boolean RESTART_DEFAULT = true;
    public static final String SECURITY_WARNING_KEY = "securityWarning";
    public static final boolean SECURITY_WARNING_DEFAULT = false;
    private static final String DEFAULT_STRUTS_VERSION_KEY = "defaultStrutsVersion";
    private static final String DEFAULT_STRUTS_VERSION_DEFAULT = StrutsVersionMediator.getDefaultStrutsVersion() == null ? null : StrutsVersionMediator.getDefaultStrutsVersion().getPropertyDescription();
    private static final String UNREALIZED_ACTION_MAPPING_DOUBLE_CLICK_ACTION = "double_click_unrealized_action_mapping";
    public static final String INVOKE_CONFIG_EDITOR = ResourceHandler.Preference_invoke_config_editor;
    public static final String INVOKE_ACTION_WIZARD = ResourceHandler.Preference_invoke_action_wizard;
    private String defaultUnrealizedActionMappingDoubleClickAction = INVOKE_ACTION_WIZARD;
    private static final String UNREALIZED_FORM_BEAN_DOUBLE_CLICK_ACTION = "double_click_unrealized_form_bean";
    public static final String INVOKE_FORM_BEAN_WIZARD = ResourceHandler.Preference_invoke_form_bean_wizard;
    private String defaultUnrealizedFormBeanDoubleClickAction = INVOKE_FORM_BEAN_WIZARD;
    private static final String ERRORS_DISPLAY_KEY = "errors_display";
    private static final boolean ERRORS_DISPLAY_DEFAULT = true;
    private static final String ERRORS_MESSAGES_KEY = "errors_messages";
    private static final String ERRORS_MESSAGES_DEFAULT = String.valueOf(NLS.bind((String)ResourceHandler.StrutsVCT_errorstag_msg0, (Object)"")) + "\r\n" + NLS.bind((String)ResourceHandler.StrutsVCT_errorstag_msg1, (Object)"") + "\r\n" + NLS.bind((String)ResourceHandler.StrutsVCT_errorstag_msg2, (Object)"");
    private static final String OPTIONS_KEY = "options";
    private static final String OPTIONS_DEFAULT = String.valueOf(ResourceHandler.StrutsVCT_optionstag_display_string) + " 1\r\n" + ResourceHandler.StrutsVCT_optionstag_display_string + " 2\r\n" + ResourceHandler.StrutsVCT_optionstag_display_string + " 3";
    private static final String EVALUATE_LOGIC_TO_TRUE_KEY = "logic_true";
    private static final boolean EVALUATE_LOGIC_TO_TRUE_DEFAULT = true;
    private static final String ITERATE_COUNT_KEY = "iterate_count";
    private static final int ITERATE_COUNT_DEFAULT = 5;
    private static final String BEAN_WRITE_NAME_DISPLAY_KEY = "bean_write_name_display";
    private static final boolean BEAN_WRITE_NAME_DISPLAY_DEFAULT = true;
    private static final String BEAN_WRITE_PROPERTY_DISPLAY_KEY = "bean_write_property_display";
    private static final boolean BEAN_WRITE_PROPERTY_DISPLAY_DEFAULT = true;
    private static final String MESSAGES_DISPLAY_KEY = "messages_display";
    private static final boolean MESSAGES_DISPLAY_DEFAULT = true;
    private static final String MESSAGES_MESSAGES_KEY = "messages_messages";
    private static final String MESSAGES_MESSAGES_DEFAULT = String.valueOf(NLS.bind((String)ResourceHandler.StrutsVCT_messagestag_msg0, (Object)"")) + "\r\n" + NLS.bind((String)ResourceHandler.StrutsVCT_messagestag_msg1, (Object)"") + "\r\n" + NLS.bind((String)ResourceHandler.StrutsVCT_messagestag_msg2, (Object)"");

    public StrutsPreferences(Plugin plugin) {
        this.plugin = plugin;
    }

    public void initializeDefaultPluginPreferences(Preferences preferences) {
        preferences.setDefault(RESTART_KEY, true);
        preferences.setDefault(SECURITY_WARNING_KEY, false);
        if (DEFAULT_STRUTS_VERSION_DEFAULT != null) {
            preferences.setDefault(DEFAULT_STRUTS_VERSION_KEY, DEFAULT_STRUTS_VERSION_DEFAULT);
        }
        preferences.setDefault(UNREALIZED_ACTION_MAPPING_DOUBLE_CLICK_ACTION, this.defaultUnrealizedActionMappingDoubleClickAction);
        preferences.setDefault(UNREALIZED_FORM_BEAN_DOUBLE_CLICK_ACTION, this.defaultUnrealizedFormBeanDoubleClickAction);
        preferences.setDefault(ERRORS_DISPLAY_KEY, true);
        preferences.setDefault(ERRORS_MESSAGES_KEY, ERRORS_MESSAGES_DEFAULT);
        preferences.setDefault(OPTIONS_KEY, OPTIONS_DEFAULT);
        preferences.setDefault(EVALUATE_LOGIC_TO_TRUE_KEY, true);
        preferences.setDefault(ITERATE_COUNT_KEY, 5);
        preferences.setDefault(BEAN_WRITE_NAME_DISPLAY_KEY, true);
        preferences.setDefault(BEAN_WRITE_PROPERTY_DISPLAY_KEY, true);
        preferences.setDefault(MESSAGES_DISPLAY_KEY, true);
        preferences.setDefault(MESSAGES_MESSAGES_KEY, MESSAGES_MESSAGES_DEFAULT);
    }

    protected Preferences getPreferences() {
        return this.plugin.getPluginPreferences();
    }

    public boolean getRestart() {
        return this.getPreferences().getBoolean(RESTART_KEY);
    }

    public void setRestart(boolean restart) {
        this.getPreferences().setValue(RESTART_KEY, restart);
    }

    public boolean getRestartDefault() {
        return this.getPreferences().getDefaultBoolean(RESTART_KEY);
    }

    public boolean getSecurityWarning() {
        return this.getPreferences().getBoolean(SECURITY_WARNING_KEY);
    }

    public void setSecurityWarning(boolean warning) {
        this.getPreferences().setValue(SECURITY_WARNING_KEY, warning);
    }

    public boolean getSecurityWarningDefault() {
        return this.getPreferences().getDefaultBoolean(SECURITY_WARNING_KEY);
    }

    public String getDefaultStrutsVersion() {
        String version = this.getPreferences().getString(DEFAULT_STRUTS_VERSION_KEY);
        if (!StrutsVersionMediator.isStrutsVersionSupported((String)version)) {
            version = StrutsVersionMediator.getDefaultStrutsVersion().getPropertyDescription();
        }
        return version;
    }

    public void setDefaultStrutsVersion(String defaultStrutsVersion) {
        this.getPreferences().setValue(DEFAULT_STRUTS_VERSION_KEY, defaultStrutsVersion);
    }

    public String getDefaultStrutsVersionDefault() {
        return this.getPreferences().getDefaultString(DEFAULT_STRUTS_VERSION_KEY);
    }

    public String getActionMappingDoubleClick() {
        return this.getPreferences().getString(UNREALIZED_ACTION_MAPPING_DOUBLE_CLICK_ACTION);
    }

    public void setActionMappingDoubleClick(String restart) {
        this.getPreferences().setValue(UNREALIZED_ACTION_MAPPING_DOUBLE_CLICK_ACTION, restart);
    }

    public String getFormBeanDoubleClick() {
        return this.getPreferences().getString(UNREALIZED_FORM_BEAN_DOUBLE_CLICK_ACTION);
    }

    public void setFormBeanDoubleClick(String restart) {
        this.getPreferences().setValue(UNREALIZED_FORM_BEAN_DOUBLE_CLICK_ACTION, restart);
    }

    public boolean getMessagesDisplay() {
        return this.getPreferences().getBoolean(MESSAGES_DISPLAY_KEY);
    }

    public void setMessagesDisplay(boolean messagesDisplay) {
        this.getPreferences().setValue(MESSAGES_DISPLAY_KEY, messagesDisplay);
    }

    public boolean getMessageDisplayDefault() {
        return true;
    }

    public boolean getBeanWriteNameDisplay() {
        return this.getPreferences().getBoolean(BEAN_WRITE_NAME_DISPLAY_KEY);
    }

    public void setBeanWriteNameDisplay(boolean beanWriteNameDisplay) {
        this.getPreferences().setValue(BEAN_WRITE_NAME_DISPLAY_KEY, beanWriteNameDisplay);
    }

    public boolean getBeanWriteNameDisplayDefault() {
        return true;
    }

    public boolean getBeanWritePropertyDisplay() {
        return this.getPreferences().getBoolean(BEAN_WRITE_PROPERTY_DISPLAY_KEY);
    }

    public void setBeanWritePropertyDisplay(boolean beanWritePropertyDisplay) {
        this.getPreferences().setValue(BEAN_WRITE_PROPERTY_DISPLAY_KEY, beanWritePropertyDisplay);
    }

    public boolean getBeanWritePropertyDisplayDefault() {
        return true;
    }

    public String getMessagesMessages() {
        return this.getPreferences().getString(MESSAGES_MESSAGES_KEY);
    }

    public void setMessagesMessages(String messagesMessages) {
        this.getPreferences().setValue(MESSAGES_MESSAGES_KEY, messagesMessages);
    }

    public String getMessagesMessagesDefault() {
        return MESSAGES_MESSAGES_DEFAULT;
    }

    public boolean getErrorsDisplay() {
        return this.getPreferences().getBoolean(ERRORS_DISPLAY_KEY);
    }

    public void setErrorsDisplay(boolean errorsDisplay) {
        this.getPreferences().setValue(ERRORS_DISPLAY_KEY, errorsDisplay);
    }

    public boolean getErrorsDisplayDefault() {
        return true;
    }

    public String getErrorsMessages() {
        return this.getPreferences().getString(ERRORS_MESSAGES_KEY);
    }

    public void setErrorsMessages(String errorsMessages) {
        this.getPreferences().setValue(ERRORS_MESSAGES_KEY, errorsMessages);
    }

    public String getErrorsMessagesDefault() {
        return ERRORS_MESSAGES_DEFAULT;
    }

    public String getOptions() {
        return this.getPreferences().getString(OPTIONS_KEY);
    }

    public void setOptions(String options) {
        this.getPreferences().setValue(OPTIONS_KEY, options);
    }

    public String getOptionsDefault() {
        return OPTIONS_DEFAULT;
    }

    public boolean getEvaluateLogicToTrue() {
        return this.getPreferences().getBoolean(EVALUATE_LOGIC_TO_TRUE_KEY);
    }

    public void setEvaluateLogicToTrue(boolean evaluateLogicToTrue) {
        this.getPreferences().setValue(EVALUATE_LOGIC_TO_TRUE_KEY, evaluateLogicToTrue);
    }

    public boolean getEvaluateLogicToTrueDefault() {
        return true;
    }

    public int getIterateCount() {
        return this.getPreferences().getInt(ITERATE_COUNT_KEY);
    }

    public void setIterateCount(int iterateCount) {
        this.getPreferences().setValue(ITERATE_COUNT_KEY, iterateCount);
    }

    public int getIterateCountDefault() {
        return 5;
    }
}

