/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.pagedataview.formbean;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.pagedataview.formbean.IStrutsPageDataNode;
import com.ibm.etools.struts.pagedataview.formbean.ui.internal.StrutsNodeViewAdapter;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNode;
import com.ibm.etools.webtools.pagedatamodel.sse.api.ISSEPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.util.PageDataModelUtil;
import com.ibm.etools.webtools.pagedataview.ui.IPageDataNodeUIAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class StrutsPageDataNode
extends PageDataNode
implements IStrutsPageDataNode,
ISSEPageDataNode {
    private IDOMNode node;
    protected boolean populatedChildren = false;
    private List<IFile> javaClassHandles = new ArrayList<IFile>();
    private List<ILink> formBeanHandles = new ArrayList<ILink>();

    public StrutsPageDataNode(IPageDataModel model, IPageDataNode parent) {
        super(model, parent);
    }

    protected void configFileChangedEvent() {
        IPageDataNode originalNode = this.copy();
        this.removeOldChildren();
        this.populateChildren(this.node);
        this.getPageDataModel().getPageDataNotifier().firePageNodeChanged(originalNode, (IPageDataNode)this);
    }

    public IPageDataNode copy() {
        StrutsPageDataNode strutsPageDataNode = new StrutsPageDataNode(this.getPageDataModel(), this.getParent());
        strutsPageDataNode.javaClassHandles = this.javaClassHandles;
        strutsPageDataNode.formBeanHandles = this.formBeanHandles;
        return strutsPageDataNode;
    }

    public final EList getChildren() {
        EList children = super.getChildren();
        if (this.shouldPopulateChildren()) {
            try {
                try {
                    Job.getJobManager().beginRule(this.getChildrenRule(), null);
                    if (!this.populatedChildren) {
                        this.populateChildren(this.node);
                        this.populatedChildren = true;
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    Job.getJobManager().endRule(this.getChildrenRule());
                }
            }
            finally {
                Job.getJobManager().endRule(this.getChildrenRule());
            }
        }
        return children;
    }

    protected boolean shouldPopulateChildren() {
        return true;
    }

    public boolean refresh(IDOMNode associatedNode, Object arg1, Object arg2, Object arg3) {
        this.removeOldChildren();
        this.populatedChildren = false;
        return false;
    }

    public void removeOldChildren() {
        this.javaClassHandles.clear();
        this.formBeanHandles.clear();
        this.clearChildren(true);
    }

    protected void populateChildren(IDOMNode node) {
        this.javaClassHandles = new ArrayList<IFile>();
        this.formBeanHandles = new ArrayList<ILink>();
        IFile file = PageDataModelUtil.getOwningResource((IDOMNode)node);
        try {
            String module = StrutsSearchUtil.getModuleForIFile((IFile)file, null);
            SearchScope scope = StrutsSearchUtil.getModuleScope((IProject)file.getProject(), (String)module, null);
            Set formBeans = StrutsSearchUtil.getAllFormBeans((SearchScope)scope, null);
            ArrayList<IFile> javaFiles = new ArrayList<IFile>();
            for (ILink formBean : formBeans) {
                ILink javaLink = StrutsSearchUtil.getJavaTarget((ILink)formBean);
                if (javaLink == null) continue;
                IFile javafile = (IFile)javaLink.getContainer().getResource();
                if (file == null) continue;
                javaFiles.add(javafile);
            }
            this.formBeanHandles.addAll(formBeans);
            this.javaClassHandles.addAll(javaFiles);
        }
        catch (ReferenceException e) {
            e.printStackTrace();
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPageDataNodeUIAttribute.ADAPTER_KEY)) {
            return StrutsNodeViewAdapter.getInstance();
        }
        if (key.equals(IBindingAttribute.ADAPTER_KEY)) {
            return null;
        }
        return super.getAdapter(key);
    }

    public void setNode(IDOMNode node) {
        this.node = node;
    }

    public boolean hasChildren() {
        return true;
    }

    public IDOMNode getDOMNode() {
        return null;
    }

    public void setDOMNode(IDOMNode domNode) {
    }

    public boolean isChildrenPopulated() {
        return this.populatedChildren;
    }

    public List<ILink> getFormBeanHandles() {
        return this.formBeanHandles;
    }
}

