/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.migration;

import com.ibm.etools.j2ee.migration.internal.ComposedMigrationConfig;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.configFile.id.contributions.ConfigFileIdentifierQuizMaster;
import com.ibm.etools.struts.configFile.id.contributions.IConfigFileIdentifier;
import com.ibm.etools.struts.configFile.id.contributions.Params;
import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.emf.strutsconfig.Exception0;
import com.ibm.etools.struts.emf.strutsconfig.Forward;
import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigPackage;
import com.ibm.etools.struts.internal.util.StrutsProjectUtil;
import com.ibm.etools.struts.util.StrutsArtifactEdit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class PostJ2EEMigrationOperation
extends AbstractDataModelOperation {
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        List models = (List)this.model.getProperty("IComposedMigrationConfigProperties.GET_ALL_VERSION_MIGRATABLE_CONFIGS");
        ArrayList statusList = new ArrayList(models.size());
        Iterator iterator = models.iterator();
        while (iterator.hasNext()) {
            IVirtualComponent component;
            IDataModel migratableModel = null;
            Object obj = iterator.next();
            if (obj instanceof IDataModel) {
                migratableModel = (IDataModel)obj;
            } else if (obj instanceof ComposedMigrationConfig) {
                migratableModel = ((ComposedMigrationConfig)obj).getDataModel();
            }
            if (migratableModel == null || !StrutsProjectUtil.isStruts((IProject)(component = (IVirtualComponent)migratableModel.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT")).getProject())) continue;
            this.migrate(component, statusList);
        }
        switch (statusList.size()) {
            case 0: {
                return Status.OK_STATUS;
            }
            case 1: {
                return (IStatus)statusList.get(0);
            }
        }
        IStatus[] statusArray = statusList.toArray(new IStatus[statusList.size()]);
        return new MultiStatus(StrutsPlugin.getPluginId(), 0, statusArray, "", null);
    }

    private void migrate(IVirtualComponent component, List statusList) {
        IConfigFileIdentifier identifier;
        IProject project = component.getProject();
        if (StrutsProjectUtil.isStruts((IProject)project) && (identifier = ConfigFileIdentifierQuizMaster.getConfigFileIdentifier(component)) != null) {
            Params params = identifier.getInitParams(component);
            if (params != null) {
                try {
                    for (Params.IParam param : params.getParams()) {
                        this.migrate(param, statusList);
                    }
                    params.save();
                }
                finally {
                    params.dispose();
                }
            }
            IFile[] files = identifier.getAllStrutsConfigFilesForComponent(component);
            int i = 0;
            while (i < files.length) {
                IFile file = files[i];
                this.migrate(file, statusList);
                ++i;
            }
        }
    }

    private void migrate(Params.IParam param, List statusList) {
        if ("config".equals(param.getName())) {
            List filenames = Model2Util.cds2List((String)param.getValue());
            boolean fixedAny = false;
            StringBuffer buffer = new StringBuffer();
            for (String filename : filenames) {
                String fixed = this.fix(filename);
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                if (fixed != null) {
                    buffer.append(fixed);
                    fixedAny = true;
                    continue;
                }
                buffer.append(filename);
            }
            if (fixedAny) {
                param.setValue(buffer.toString());
            }
            return;
        }
        if (param.getName().startsWith("config/")) {
            String filename = this.fix(param.getValue());
            if (filename != null) {
                param.setValue(filename);
            }
            return;
        }
    }

    private void migrate(IFile file, List statusList) {
        StrutsArtifactEdit artifactEdit;
        if (file.exists() && (artifactEdit = StrutsArtifactEdit.getStrutsArtifactEditForWrite(file)) != null) {
            try {
                StrutsConfig strutsConfig = artifactEdit.getStrutsConfig();
                if (strutsConfig != null) {
                    this.migrate(strutsConfig, statusList);
                }
                artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                artifactEdit.dispose();
            }
        }
    }

    private void migrate(StrutsConfig config, List statusList) {
        for (ActionMapping actionMapping : config.getActionMappings()) {
            this.migrate(actionMapping, (EStructuralFeature)StrutsconfigPackage.Literals.ACTION_MAPPING__PATH);
            this.migrate(actionMapping, (EStructuralFeature)StrutsconfigPackage.Literals.ACTION_MAPPING__FORWARD);
            this.migrate(actionMapping, (EStructuralFeature)StrutsconfigPackage.Literals.ACTION_MAPPING__INCLUDE);
            this.migrate(actionMapping, (EStructuralFeature)StrutsconfigPackage.Literals.ACTION_MAPPING__INPUT);
            for (Forward forward : actionMapping.getForwards()) {
                this.migrate(forward, (EStructuralFeature)StrutsconfigPackage.Literals.FORWARD__PATH);
            }
            for (Exception0 exception : actionMapping.getExceptions()) {
                this.migrate(exception, (EStructuralFeature)StrutsconfigPackage.Literals.EXCEPTION0__PATH);
            }
        }
        for (Forward forward : config.getGlobalForwards()) {
            this.migrate(forward, (EStructuralFeature)StrutsconfigPackage.Literals.FORWARD__PATH);
        }
        for (Exception0 exception : config.getGlobalExceptions()) {
            this.migrate(exception, (EStructuralFeature)StrutsconfigPackage.Literals.EXCEPTION0__PATH);
        }
    }

    private void migrate(EObject object, EStructuralFeature feature) {
        String fixed;
        String string = (String)object.eGet(feature);
        if (string != null && (fixed = this.fix(string)) != null) {
            object.eSet(feature, (Object)fixed);
        }
    }

    private String fix(String filename) {
        if (filename != null && filename.length() > 0 && filename.charAt(0) != '/') {
            return "/" + filename;
        }
        return null;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

